/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXPath;
import heronarts.lx.LXSerializable;
import heronarts.lx.command.LXCommand;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

public abstract class LXMidiMapping
implements LXSerializable {
    public final int channel;
    public final Type type;
    public final LXNormalizedParameter parameter;
    public final boolean isDiscrete;
    public final DiscreteParameter discreteParameter;
    public final boolean isBoolean;
    public final BooleanParameter booleanParameter;
    private static final String KEY_CHANNEL = "channel";
    private static final String KEY_TYPE = "type";

    private static int getChannel(JsonObject obj) {
        return obj.get(KEY_CHANNEL).getAsInt();
    }

    private static LXNormalizedParameter getParameter(LX lx, JsonObject obj) {
        LXPath parameter;
        if (obj.has("path") && (parameter = LXPath.get(lx, obj.get("path").getAsString())) instanceof LXNormalizedParameter) {
            return (LXNormalizedParameter)parameter;
        }
        return (LXNormalizedParameter)lx.getProjectComponent(obj.get("componentId").getAsInt()).getParameter(obj.get("parameterPath").getAsString());
    }

    protected LXMidiMapping(LX lx, int channel, Type type, LXNormalizedParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Cannot map null parameter");
        }
        if (parameter.getParent() == null) {
            throw new IllegalStateException("Cannot map parameter with no component: " + parameter);
        }
        this.channel = channel;
        this.type = type;
        this.parameter = parameter;
        this.isBoolean = parameter instanceof BooleanParameter;
        this.booleanParameter = this.isBoolean ? (BooleanParameter)parameter : null;
        this.isDiscrete = parameter instanceof DiscreteParameter;
        this.discreteParameter = this.isDiscrete ? (DiscreteParameter)parameter : null;
    }

    protected LXMidiMapping(LX lx, JsonObject object, Type type) {
        this(lx, object.get(KEY_CHANNEL).getAsInt(), type, LXMidiMapping.getParameter(lx, object));
    }

    static boolean isValidMessageType(LXShortMessage message) {
        return message instanceof MidiNote || message instanceof MidiControlChange;
    }

    public static LXMidiMapping create(LX lx, LXShortMessage message, LXNormalizedParameter parameter) {
        if (message instanceof MidiNote) {
            return new Note(lx, (MidiNote)message, parameter);
        }
        if (message instanceof MidiControlChange) {
            return new ControlChange(lx, (MidiControlChange)message, parameter);
        }
        throw new IllegalArgumentException("Not a valid message type for a MIDI mapping: " + message);
    }

    public static LXMidiMapping create(LX lx, JsonObject object) {
        Type type = Type.valueOf(object.get(KEY_TYPE).getAsString());
        switch (type) {
            case NOTE: {
                return new Note(lx, object);
            }
            case CONTROL_CHANGE: {
                return new ControlChange(lx, object);
            }
        }
        throw new IllegalArgumentException("Not a valid MidiMapping type: " + object);
    }

    abstract boolean matches(LXShortMessage var1);

    abstract void apply(LX var1, LXShortMessage var2);

    public abstract String getDescription();

    protected void setValue(boolean value) {
        if (this.parameter instanceof BooleanParameter) {
            ((BooleanParameter)this.parameter).setValue(value);
        } else {
            this.parameter.setNormalized(value ? 1.0 : 0.0);
        }
    }

    @Override
    public void save(LX lx, JsonObject object) {
        object.addProperty(KEY_CHANNEL, (Number)this.channel);
        object.addProperty(KEY_TYPE, this.type.name());
        object.addProperty("path", this.parameter.getCanonicalPath());
        object.addProperty("componentId", (Number)this.parameter.getParent().getId());
        object.addProperty("parameterPath", this.parameter.getPath());
    }

    @Override
    public void load(LX lx, JsonObject object) {
        throw new UnsupportedOperationException("Use LXMidiMapping.create() to load from JsonObject");
    }

    protected static DiscreteParameter makeDiscreteRangeParameter(DiscreteParameter parameter, boolean on, String label, String description) {
        int min = parameter.getMinValue();
        int max = parameter.getMaxValue();
        return (DiscreteParameter)new DiscreteParameter(label, on ? max : min, min, max + 1).setUnits(parameter.getUnits()).setOptions(parameter.getOptions(), false).setFormatter(v -> {
            int index = (int)v - min;
            String[] options = parameter.getOptions();
            return options != null && index < options.length ? options[index] : parameter.getFormatter().format(v);
        }).setDescription(description).setMappable(false);
    }

    protected static BoundedParameter makeBoundedRangeParameter(LXNormalizedParameter parameter, boolean on, String label, String description) {
        double v0 = 0.0;
        double v1 = 1.0;
        BoundedParameter.NormalizationCurve normalizationCurve = BoundedParameter.NormalizationCurve.NORMAL;
        if (parameter instanceof BoundedParameter) {
            BoundedParameter bounded = (BoundedParameter)parameter;
            v0 = bounded.range.v0;
            v1 = bounded.range.v1;
        }
        return (BoundedParameter)new BoundedParameter(label, on ? v1 : v0, v0, v1).setNormalizationCurve(normalizationCurve).setExponent(parameter.getExponent()).setPolarity(parameter.getPolarity()).setUnits(parameter.getUnits()).setFormatter(parameter.getFormatter()).setDescription(parameter.getDescription()).setMappable(false);
    }

    public static enum Type {
        NOTE,
        CONTROL_CHANGE;

    }

    public static class Note
    extends LXMidiMapping {
        public final int pitch;
        public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.TOGGLE).setDescription("How to process note on and off events");
        public final EnumParameter<DiscreteMode> discreteMode = new EnumParameter<DiscreteMode>("Discrete Mode", DiscreteMode.INCREMENT).setDescription("How to process note events for a parameter with a fixed set of options");
        public final BoundedParameter offValue;
        public final BoundedParameter onValue;
        public final DiscreteParameter fixedValue;
        private LXParameter.Collection parameters = new LXParameter.Collection();
        private boolean toggleState = false;
        private static final String KEY_PITCH = "pitch";

        private Note(LX lx, int channel, int pitch, LXNormalizedParameter parameter) {
            super(lx, channel, Type.NOTE, parameter);
            this.pitch = pitch;
            if (this.isDiscrete) {
                this.fixedValue = Note.makeDiscreteRangeParameter(this.discreteParameter, false, "Fixed", "Value set for a fixed note trigger");
                this.parameters.add("discreteMode", this.discreteMode);
                this.parameters.add("fixedValue", this.fixedValue);
                this.offValue = null;
                this.onValue = null;
            } else if (this.isBoolean) {
                this.parameters.add("mode", this.mode);
                this.mode.setValue((Object)Mode.getDefault(this.booleanParameter));
                this.fixedValue = null;
                this.offValue = null;
                this.onValue = null;
            } else {
                this.fixedValue = null;
                this.offValue = Note.makeBoundedRangeParameter(parameter, false, "Off", "Value when the MIDI note trigger is Off");
                this.onValue = Note.makeBoundedRangeParameter(parameter, true, "On", "Value when the MIDI note trigger is On");
                this.parameters.add("mode", this.mode);
                this.parameters.add("offValue", this.offValue);
                this.parameters.add("onValue", this.onValue);
            }
        }

        private Note(LX lx, MidiNote note, LXNormalizedParameter parameter) {
            this(lx, note.getChannel(), note.getPitch(), parameter);
        }

        private Note(LX lx, JsonObject object) {
            this(lx, LXMidiMapping.getChannel(object), object.get(KEY_PITCH).getAsInt(), LXMidiMapping.getParameter(lx, object));
            LXSerializable.Utils.loadParameters(object, this.parameters);
        }

        @Override
        boolean matches(LXShortMessage message) {
            if (message instanceof MidiNote) {
                MidiNote note = (MidiNote)message;
                return note.getChannel() == this.channel && note.getPitch() == this.pitch;
            }
            return false;
        }

        @Override
        void apply(LX lx, LXShortMessage message) {
            MidiNote note = (MidiNote)message;
            boolean noteOn = note.isNoteOn();
            if (this.parameter instanceof BooleanParameter) {
                BooleanParameter bool = (BooleanParameter)this.parameter;
                if (noteOn) {
                    switch (this.mode.getEnum()) {
                        case MOMENTARY: 
                        case ON: {
                            lx.command.perform(new LXCommand.Parameter.SetNormalized(bool, true));
                            break;
                        }
                        case OFF: {
                            lx.command.perform(new LXCommand.Parameter.SetNormalized(bool, false));
                            break;
                        }
                        default: {
                            lx.command.perform(new LXCommand.Parameter.Toggle(bool));
                            break;
                        }
                    }
                } else if (this.mode.getEnum() == Mode.MOMENTARY) {
                    bool.setValue(false);
                }
            } else if (this.parameter instanceof DiscreteParameter) {
                DiscreteParameter discrete = (DiscreteParameter)this.parameter;
                if (noteOn) {
                    switch (this.discreteMode.getEnum()) {
                        case DECREMENT: {
                            lx.command.perform(new LXCommand.Parameter.Decrement(discrete, true));
                            break;
                        }
                        case RANDOM: {
                            lx.command.perform(new LXCommand.Parameter.SetNormalized(discrete, Math.random()));
                            break;
                        }
                        case FIXED: {
                            lx.command.perform(new LXCommand.Parameter.SetIndex(discrete, this.fixedValue.getIndex()));
                            break;
                        }
                        default: {
                            lx.command.perform(new LXCommand.Parameter.Increment(discrete, true));
                        }
                    }
                }
            } else {
                if (noteOn) {
                    this.toggleState = !this.toggleState;
                }
                switch (this.mode.getEnum()) {
                    case MOMENTARY: {
                        lx.command.perform(new LXCommand.Parameter.SetNormalized(this.parameter, noteOn ? this.onValue.getValue() : this.offValue.getValue()));
                        break;
                    }
                    case TOGGLE: {
                        if (!noteOn) break;
                        lx.command.perform(new LXCommand.Parameter.SetNormalized(this.parameter, this.toggleState ? this.onValue.getValue() : this.offValue.getValue()));
                        break;
                    }
                    case ON: {
                        if (!noteOn) break;
                        lx.command.perform(new LXCommand.Parameter.SetNormalized(this.parameter, this.onValue.getValue()));
                        break;
                    }
                    case OFF: {
                        if (!noteOn) break;
                        lx.command.perform(new LXCommand.Parameter.SetNormalized(this.parameter, this.offValue.getValue()));
                    }
                }
            }
        }

        @Override
        public String getDescription() {
            return MidiNote.getPitchString(this.pitch);
        }

        @Override
        public void save(LX lx, JsonObject object) {
            super.save(lx, object);
            object.addProperty(KEY_PITCH, (Number)this.pitch);
            LXSerializable.Utils.saveParameters(object, this.parameters);
        }

        public static enum Mode {
            TOGGLE("Toggle"),
            MOMENTARY("Momentary"),
            ON("On"),
            OFF("Off");

            public final String label;

            private Mode(String label) {
                this.label = label;
            }

            public String toString() {
                return this.label;
            }

            public static Mode getDefault(BooleanParameter parameter) {
                switch (parameter.getMode()) {
                    case MOMENTARY: {
                        return MOMENTARY;
                    }
                }
                return TOGGLE;
            }
        }

        public static enum DiscreteMode {
            INCREMENT("Increment"),
            DECREMENT("Decrement"),
            FIXED("Fixed"),
            RANDOM("Random");

            public final String label;

            private DiscreteMode(String label) {
                this.label = label;
            }

            public String toString() {
                return this.label;
            }
        }
    }

    public static class ControlChange
    extends LXMidiMapping {
        public final int cc;
        public final DiscreteParameter minDiscrete;
        public final DiscreteParameter maxDiscrete;
        public final BoundedParameter minValue;
        public final BoundedParameter maxValue;
        private LXParameter.Collection parameters = new LXParameter.Collection();
        private long discreteMillis = 0L;
        private long normalizedMillis = 0L;
        private LXCommand.Parameter.SetValue discreteUpdate = null;
        private LXCommand.Parameter.SetNormalized normalizedUpdate = null;
        private static final long COALSECE_UPDATE_MILLIS = 1000L;
        private static final String KEY_CC = "cc";

        private ControlChange(LX lx, int channel, int cc, LXNormalizedParameter parameter) {
            super(lx, channel, Type.CONTROL_CHANGE, parameter);
            this.cc = cc;
            if (this.isDiscrete) {
                this.maxValue = null;
                this.minValue = null;
                this.minDiscrete = ControlChange.makeDiscreteRangeParameter(this.discreteParameter, false, "Min", "Minimum mapped value");
                this.maxDiscrete = ControlChange.makeDiscreteRangeParameter(this.discreteParameter, true, "Max", "Maximum mapped value");
                this.parameters.add("minDiscrete", this.minDiscrete);
                this.parameters.add("maxDiscrete", this.maxDiscrete);
            } else if (this.isBoolean) {
                this.maxDiscrete = null;
                this.minDiscrete = null;
                this.minValue = new BoundedParameter("Min", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Minimum value for the parameter to be switched on");
                this.maxValue = new BoundedParameter("Max", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Maximum value for the parameter to be switched on");
                this.parameters.add("minValue", this.minValue);
                this.parameters.add("maxValue", this.maxValue);
            } else {
                this.maxDiscrete = null;
                this.minDiscrete = null;
                this.minValue = ControlChange.makeBoundedRangeParameter(parameter, false, "Min", "Minimum mapped value");
                this.maxValue = ControlChange.makeBoundedRangeParameter(parameter, true, "Max", "Maximum mapped value");
                this.parameters.add("minValue", this.minValue);
                this.parameters.add("maxValue", this.maxValue);
            }
        }

        private ControlChange(LX lx, MidiControlChange controlChange, LXNormalizedParameter parameter) {
            this(lx, controlChange.getChannel(), controlChange.getCC(), parameter);
        }

        private ControlChange(LX lx, JsonObject object) {
            this(lx, LXMidiMapping.getChannel(object), object.get(KEY_CC).getAsInt(), LXMidiMapping.getParameter(lx, object));
            LXSerializable.Utils.loadParameters(object, this.parameters);
        }

        @Override
        boolean matches(LXShortMessage message) {
            if (message instanceof MidiControlChange) {
                MidiControlChange controlChange = (MidiControlChange)message;
                return controlChange.getChannel() == this.channel && controlChange.getCC() == this.cc;
            }
            return false;
        }

        private void setDiscreteCommand(LX lx, int value) {
            long elapsedMillis = lx.engine.nowMillis - this.discreteMillis;
            this.discreteMillis = lx.engine.nowMillis;
            if (this.discreteUpdate == null || elapsedMillis > 1000L) {
                this.discreteUpdate = new LXCommand.Parameter.SetValue(this.discreteParameter, value);
            }
            lx.command.perform(this.discreteUpdate.updateDiscrete(value));
        }

        private void setNormalizedCommand(LX lx, double normalized) {
            long elapsedMillis = lx.engine.nowMillis - this.normalizedMillis;
            this.normalizedMillis = lx.engine.nowMillis;
            if (this.normalizedUpdate == null || elapsedMillis > 1000L) {
                this.normalizedUpdate = new LXCommand.Parameter.SetNormalized(this.parameter, normalized);
            }
            lx.command.perform(this.normalizedUpdate.update(normalized));
        }

        @Override
        void apply(LX lx, LXShortMessage message) {
            MidiControlChange controlChange = (MidiControlChange)message;
            double normalized = controlChange.getNormalized();
            if (this.isDiscrete) {
                int max;
                int min = this.minDiscrete.getValuei();
                if (min > (max = this.maxDiscrete.getValuei())) {
                    int tmp = min;
                    min = max;
                    max = tmp;
                    normalized = 1.0 - normalized;
                }
                this.setDiscreteCommand(lx, LXUtils.min((int)((double)min + (double)(max - min + 1) * normalized), max));
            } else if (this.isBoolean) {
                boolean isOn;
                boolean bl = isOn = normalized >= this.minValue.getNormalized() && normalized <= this.maxValue.getNormalized();
                if (this.booleanParameter.isOn() != isOn) {
                    lx.command.perform(new LXCommand.Parameter.SetNormalized(this.booleanParameter, isOn));
                }
            } else {
                this.setNormalizedCommand(lx, LXUtils.lerp(this.minValue.getNormalized(), this.maxValue.getNormalized(), normalized));
            }
        }

        @Override
        public String getDescription() {
            return "CC" + this.cc;
        }

        @Override
        public void save(LX lx, JsonObject object) {
            super.save(lx, object);
            object.addProperty(KEY_CC, (Number)this.cc);
            LXSerializable.Utils.saveParameters(object, this.parameters);
        }
    }
}

