/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiDevice;
import heronarts.lx.midi.LXMidiEngine;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class LXMidiOutput
extends LXMidiDevice
implements Receiver {
    private Receiver receiver = null;
    private boolean isOpen = false;

    LXMidiOutput(LXMidiEngine engine, MidiDevice device) {
        super(engine, device);
    }

    @Override
    public void close() {
        if (this.isOpen) {
            try {
                this.receiver.close();
            }
            finally {
                this.receiver = null;
                this.isOpen = false;
            }
        }
    }

    public void send(MidiMessage message) {
        this.send(message, -1L);
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (!this.enabled.isOn()) {
            throw new UnsupportedOperationException("Cannot send() to an LXMidiOutput that is not enabled");
        }
        if (this.connected.isOn()) {
            try {
                this.receiver.send(message, timeStamp);
            }
            catch (Exception x) {
                LXMidiEngine.error(x, "Failed to send message to MIDI output, marking as disconnected: " + this.getName());
                this.connected.setValue(false);
            }
        }
    }

    public void sendSysex(byte[] sysex) {
        try {
            SysexMessage message = new SysexMessage();
            message.setMessage(sysex, sysex.length);
            this.send(message);
        }
        catch (InvalidMidiDataException imdx) {
            LXMidiEngine.error(imdx, "Invalid midi data sending sysex message: " + imdx.getLocalizedMessage());
        }
    }

    private void sendShortMessage(int command, int channel, int data1, int data2) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(command, channel, data1, data2);
            this.send(message);
        }
        catch (InvalidMidiDataException imdx) {
            LXMidiEngine.error(imdx, "Invalid midi data sending short message: " + imdx.getLocalizedMessage());
        }
    }

    public void sendNoteOn(int channel, int pitch, int velocity) {
        this.sendShortMessage(144, channel, pitch, velocity);
    }

    public void sendNoteOff(int channel, int pitch) {
        this.sendNoteOff(channel, pitch, 0);
    }

    public void sendNoteOff(int channel, int pitch, int velocity) {
        this.sendShortMessage(128, channel, pitch, velocity);
    }

    public void sendControlChange(int channel, int cc, int value) {
        this.sendShortMessage(176, channel, cc, value);
    }

    @Override
    protected void onEnabled(boolean enabled) {
        if (enabled && !this.isOpen) {
            try {
                if (!this.device.isOpen()) {
                    this.device.open();
                }
                this.receiver = this.device.getReceiver();
                this.isOpen = true;
            }
            catch (MidiUnavailableException mux) {
                LXMidiEngine.error("Could not enable LXMidiOutput device " + this + ": " + mux.getLocalizedMessage());
                this.enabled.setValue(false);
            }
        }
    }
}

