/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiAftertouch;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNoteOff;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiProgramChange;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public abstract class LXShortMessage
extends ShortMessage {
    private LXMidiInput input = null;

    public static LXShortMessage fromShortMessage(ShortMessage message) {
        switch (message.getCommand()) {
            case 144: {
                return new MidiNoteOn(message);
            }
            case 128: {
                return new MidiNoteOff(message);
            }
            case 176: {
                return new MidiControlChange(message);
            }
            case 192: {
                return new MidiProgramChange(message);
            }
            case 224: {
                return new MidiPitchBend(message);
            }
            case 208: {
                return new MidiAftertouch(message);
            }
        }
        throw new IllegalArgumentException("Unsupported LXMidi message command: " + message.getCommand());
    }

    static ShortMessage getMessage(int command, int status, int value1, int value2) throws InvalidMidiDataException {
        ShortMessage sm = new ShortMessage();
        sm.setMessage(command, status, value1, value2);
        return sm;
    }

    protected LXShortMessage(int command, int status, int value1, int value2) throws InvalidMidiDataException {
        this(LXShortMessage.getMessage(command, status, value1, value2), command);
    }

    LXShortMessage(ShortMessage message, int command) {
        super(message.getMessage());
        if (this.getCommand() != command) {
            throw new IllegalArgumentException("LXShortMessage constructed with command " + command + " but has actual command " + this.getCommand());
        }
    }

    LXShortMessage setInput(LXMidiInput input) {
        this.input = input;
        return this;
    }

    LXMidiInput getInput() {
        return this.input;
    }

    public void dispatch(LXMidiListener listener) {
        switch (this.getCommand()) {
            case 144: {
                MidiNoteOn note = (MidiNoteOn)this;
                if (note.getVelocity() == 0) {
                    listener.noteOffReceived(note);
                    break;
                }
                listener.noteOnReceived(note);
                break;
            }
            case 128: {
                listener.noteOffReceived((MidiNoteOff)this);
                break;
            }
            case 176: {
                listener.controlChangeReceived((MidiControlChange)this);
                break;
            }
            case 192: {
                listener.programChangeReceived((MidiProgramChange)this);
                break;
            }
            case 224: {
                listener.pitchBendReceived((MidiPitchBend)this);
                break;
            }
            case 208: {
                listener.aftertouchReceived((MidiAftertouch)this);
            }
        }
    }
}

