/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXShortMessage;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class MidiControlChange
extends LXShortMessage {
    public static final int BANK_SELECT = 0;
    public static final int MOD_WHEEL = 1;
    public static final int BREATH_CONTROLLER = 2;
    public static final int FOOT_CONTROLLER = 4;
    public static final int PORTAMENTO_TIME = 5;
    public static final int DATA_ENTRY_MSB = 6;
    public static final int MAIN_VOLUME = 7;
    public static final int BALANCE = 8;
    public static final int PAN = 10;
    public static final int DAMPER_PEDAL = 64;
    public static final int PORTAMENTO = 65;
    public static final int SOSTENUTO = 66;
    public static final int SOFT_PEDAL = 67;
    public static final int LEGATO_FOOTWSWITCH = 68;
    public static final int HOLD_2 = 69;
    public static final int PORTAMENTO_CONTROL = 84;
    public static final int DATA_INCREMENT = 96;
    public static final int NRPN_LSB = 98;
    public static final int NRPN_MSB = 99;
    public static final int RPN_LSB = 100;
    public static final int RPN_MSB = 101;
    public static final int RESET_ALL_CONTROLLERS = 121;
    public static final int LOCAL_CONTROL = 122;
    public static final int ALL_NOTES_OFF = 123;
    public static final int OMNI_OFF = 124;
    public static final int OMNI_ON = 125;
    public static final int POLY_OFF = 126;
    public static final int POLY_ON = 127;

    public MidiControlChange(int channel, int cc, int value) throws InvalidMidiDataException {
        super(176, channel, cc, value);
    }

    MidiControlChange(ShortMessage message) {
        super(message, 176);
    }

    public int getCC() {
        return this.getData1();
    }

    public int getValue() {
        return this.getData2();
    }

    public double getNormalized() {
        return (double)this.getValue() / 127.0;
    }

    public int getRelative() {
        int value = this.getValue();
        if (value >= 64) {
            return value - 128;
        }
        return value;
    }

    public String toString() {
        return "MidiControlChange:" + this.getChannel() + ":CC:" + this.getCC() + ":Value: " + this.getValue();
    }
}

