/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXShortMessage;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public abstract class MidiNote
extends LXShortMessage {
    private static final String[] PITCHES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    protected MidiNote(int command, int channel, int pitch, int velocity) throws InvalidMidiDataException {
        super(command, channel, pitch, velocity);
    }

    protected MidiNote(ShortMessage message, int command) {
        super(message, command);
    }

    public static String getPitchString(int pitch) {
        return PITCHES[pitch % 12] + Integer.toString(pitch / 12 - 2);
    }

    public String getPitchString() {
        return MidiNote.getPitchString(this.getPitch());
    }

    public int getPitch() {
        return this.getData1();
    }

    public int getVelocity() {
        return this.getData2();
    }

    public boolean isNoteOn() {
        return this.getCommand() == 144 && this.getVelocity() > 0;
    }
}

