/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class APC40
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final String DEVICE_NAME = "Akai APC40";
    public static final byte GENERIC_MODE = 64;
    public static final byte ABLETON_MODE = 65;
    public static final byte ABLETON_ALTERNATE_MODE = 66;
    protected static final int LED_STYLE_OFF = 0;
    protected static final int LED_STYLE_SINGLE = 1;
    protected static final int LED_STYLE_UNIPOLAR = 2;
    protected static final int LED_STYLE_BIPOLAR = 3;
    public static final int NUM_CHANNELS = 8;
    public static final int CHANNEL_FADER = 7;
    public static final int MASTER_FADER = 14;
    public static final int CROSSFADER = 15;
    public static final int CUE_LEVEL = 47;
    public static final int DEVICE_KNOB = 16;
    public static final int DEVICE_KNOB_NUM = 8;
    public static final int DEVICE_KNOB_MAX = 24;
    public static final int DEVICE_KNOB_STYLE = 24;
    public static final int DEVICE_KNOB_STYLE_MAX = 32;
    public static final int TRACK_KNOB = 48;
    public static final int TRACK_KNOB_NUM = 8;
    public static final int TRACK_KNOB_MAX = 55;
    public static final int TRACK_KNOB_STYLE = 56;
    public static final int TRACK_KNOB_STYLE_MAX = 64;
    public static final int CLIP_LAUNCH = 53;
    public static final int CLIP_LAUNCH_ROWS = 5;
    public static final int CLIP_LAUNCH_MAX = 57;
    public static final int CLIP_LAUNCH_COLUMNS = 8;
    public static final int CHANNEL_ARM = 48;
    public static final int CHANNEL_SOLO = 49;
    public static final int CHANNEL_ACTIVE = 50;
    public static final int CHANNEL_FOCUS = 51;
    public static final int CLIP_STOP = 52;
    public static final int CHANNEL_CROSSFADE_GROUP = 66;
    public static final int MASTER_FOCUS = 80;
    public static final int STOP_ALL_CLIPS = 81;
    public static final int SCENE_LAUNCH = 82;
    public static final int SCENE_LAUNCH_NUM = 5;
    public static final int SCENE_LAUNCH_MAX = 86;
    public static final int PAN = 87;
    public static final int SEND_A = 88;
    public static final int SEND_B = 89;
    public static final int SEND_C = 90;
    public static final int PLAY = 91;
    public static final int STOP = 92;
    public static final int RECORD = 93;
    public static final int BANK_SELECT_UP = 94;
    public static final int BANK_SELECT_DOWN = 95;
    public static final int BANK_SELECT_RIGHT = 96;
    public static final int BANK_SELECT_LEFT = 97;
    public static final int SHIFT = 98;
    public static final int TAP_TEMPO = 99;
    public static final int NUDGE_PLUS = 100;
    public static final int NUDGE_MINUS = 101;
    public static final int CLIP_TRACK = 58;
    public static final int DEVICE_ON_OFF = 59;
    public static final int DEVICE_LEFT = 60;
    public static final int DEVICE_RIGHT = 61;
    public static final int DETAIL_VIEW = 62;
    public static final int REC_QUANTIZE = 63;
    public static final int MIDI_OVERDUB = 64;
    public static final int METRONOME = 65;
    public static final int LED_OFF = 0;
    public static final int LED_ON = 1;
    public static final int LED_BLINK = 2;
    public static final int LED_GREEN = 1;
    public static final int LED_GREEN_BLINK = 2;
    public static final int LED_RED = 3;
    public static final int LED_RED_BLINK = 4;
    public static final int LED_YELLOW = 5;
    public static final int LED_YELLOW_BLINK = 6;
    private GridMode gridMode = GridMode.PATTERN;
    private boolean shiftOn = false;
    private final Map<LXAbstractChannel, ChannelListener> channelListeners = new HashMap<LXAbstractChannel, ChannelListener>();
    private final DeviceListener deviceListener = new DeviceListener();
    public final BooleanParameter masterFaderEnabled = new BooleanParameter("Master Fader", true).setDescription("Whether the master fader is enabled");
    public final BooleanParameter crossfaderEnabled = new BooleanParameter("Crossfader", true).setDescription("Whether the A/B crossfader is enabled");
    public final BooleanParameter clipLaunchEnabled = new BooleanParameter("Clip Launch", true).setDescription("Whether the clip launch buttons are enabled");
    private final LXMixerEngine.Listener mixerEngineListener = new LXMixerEngine.Listener(){

        @Override
        public void channelRemoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40.this.unregisterChannel(channel);
            APC40.this.sendChannels();
        }

        @Override
        public void channelMoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40.this.sendChannels();
        }

        @Override
        public void channelAdded(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40.this.sendChannels();
            APC40.this.registerChannel(channel);
        }
    };
    private final LXParameterListener cueAListener = p -> this.sendNoteOn(0, 62, this.lx.engine.mixer.cueA.isOn() ? 1 : 0);
    private final LXParameterListener cueBListener = p -> this.sendNoteOn(0, 63, this.lx.engine.mixer.cueB.isOn() ? 1 : 0);
    private final LXParameterListener tempoListener = p -> this.sendNoteOn(0, 65, this.lx.engine.tempo.enabled.isOn() ? 1 : 0);
    private final LXParameterListener focusedChannelListener = p -> this.sendChannelFocus();
    private boolean isRegistered = false;

    public APC40(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.addSetting("masterFaderEnabled", this.masterFaderEnabled);
        this.addSetting("crossfaderEnabled", this.crossfaderEnabled);
        this.addSetting("clipLaunchEnabled", this.clipLaunchEnabled);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.clipLaunchEnabled) {
            if (this.clipLaunchEnabled.isOn()) {
                this.sendChannels();
            } else {
                this.clearClipLaunch();
            }
        }
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.setApcMode((byte)66);
            this.initialize(false);
            this.register();
        } else {
            this.deviceListener.registerDevice(null);
            for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
                if (!(channel instanceof LXChannel)) continue;
                ((LXChannel)channel).controlSurfaceFocusLength.setValue(0.0);
            }
            if (this.isRegistered) {
                this.unregister();
            }
            this.setApcMode((byte)64);
        }
    }

    @Override
    protected void onReconnect() {
        if (this.enabled.isOn()) {
            this.setApcMode((byte)66);
            this.initialize(true);
            this.deviceListener.resend();
        }
    }

    private void setApcMode(byte mode) {
        this.output.sendSysex(new byte[]{-16, 71, 0, 115, 96, 0, 4, mode, 9, 3, 1, -9});
    }

    private void initialize(boolean reconnect) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.sendControlChange(0, 24 + i, 0);
        }
        for (i = 0; i < 8; ++i) {
            this.sendControlChange(0, 56 + i, 1);
            if (reconnect) continue;
            this.sendControlChange(0, 48 + i, 64);
        }
        this.sendChannels();
    }

    private void sendChannels() {
        for (int i = 0; i < 8; ++i) {
            this.sendChannel(i, this.getChannel(i));
        }
        this.sendChannelFocus();
    }

    private void sendChannelGrid() {
        for (int i = 0; i < 8; ++i) {
            LXAbstractChannel channel = this.getChannel(i);
            this.sendChannelPatterns(i, channel);
            this.sendChannelClips(i, channel);
        }
    }

    private void clearChannelGrid() {
        for (int i = 0; i < 8; ++i) {
            this.sendChannel(i, null);
        }
    }

    private void clearClipLaunch() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 53; j <= 57; ++j) {
                this.sendNoteOn(i, j, 0);
            }
            this.sendNoteOn(i, 52, 0);
        }
        for (int j = 82; j < 86; ++j) {
            this.sendNoteOn(0, j, 0);
        }
    }

    private void sendChannel(int index, LXAbstractChannel channel) {
        if (channel != null) {
            this.sendNoteOn(index, 50, channel.enabled.isOn() ? 1 : 0);
            this.sendNoteOn(index, 66, channel.crossfadeGroup.getValuei());
            this.sendNoteOn(index, 49, channel.cueActive.isOn() ? 1 : 0);
            this.sendNoteOn(index, 48, channel.arm.isOn() ? 1 : 0);
        } else {
            this.sendNoteOn(index, 50, 0);
            this.sendNoteOn(index, 66, 0);
            this.sendNoteOn(index, 49, 0);
            this.sendNoteOn(index, 48, 0);
        }
        this.sendChannelPatterns(index, channel);
        this.sendChannelClips(index, channel);
    }

    private void sendChannelPatterns(int index, LXAbstractChannel channelBus) {
        if (!this.clipLaunchEnabled.isOn()) {
            return;
        }
        if (index >= 8 || this.gridMode != GridMode.PATTERN) {
            return;
        }
        if (channelBus instanceof LXChannel) {
            LXChannel channel = (LXChannel)channelBus;
            boolean blendMode = channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND;
            int baseIndex = channel.controlSurfaceFocusIndex.getValuei();
            int endIndex = channel.patterns.size() - baseIndex;
            int activeIndex = channel.getActivePatternIndex() - baseIndex;
            int nextIndex = channel.getNextPatternIndex() - baseIndex;
            int focusedIndex = channel.patterns.size() == 0 ? -1 : channel.focusedPattern.getValuei() - baseIndex;
            for (int y = 0; y < 5; ++y) {
                int pitch = 53 + y;
                int color = 0;
                if (blendMode) {
                    if (y < endIndex) {
                        color = channel.patterns.get((int)(baseIndex + y)).enabled.isOn() ? 1 : 3;
                    }
                } else if (y == activeIndex) {
                    color = 1;
                } else if (y == nextIndex) {
                    color = 2;
                } else if (y == focusedIndex) {
                    color = 3;
                } else if (y < endIndex) {
                    color = 5;
                }
                this.sendNoteOn(index, pitch, color);
            }
        } else {
            for (int y = 0; y < 5; ++y) {
                this.sendNoteOn(index, 53 + y, 0);
            }
        }
    }

    private void sendChannelClips(int index, LXAbstractChannel channel) {
        if (!this.clipLaunchEnabled.isOn()) {
            return;
        }
        if (index >= 8 || this.gridMode != GridMode.CLIP) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            LXClip clip;
            int pitch = 53 + i;
            int color = 0;
            if (channel != null && (clip = channel.getClip(i)) != null) {
                color = clip.isRunning() ? 1 : (channel.arm.isOn() ? 3 : 5);
            }
            this.sendNoteOn(index, pitch, color);
        }
    }

    private void sendChannelFocus() {
        int focusedChannel = this.lx.engine.mixer.focusedChannel.getValuei();
        boolean masterFocused = focusedChannel == this.lx.engine.mixer.channels.size();
        for (int i = 0; i < 8; ++i) {
            this.sendNoteOn(i, 51, !masterFocused && i == focusedChannel ? 1 : 0);
        }
        this.sendNoteOn(0, 80, masterFocused ? 1 : 0);
    }

    private void register() {
        this.isRegistered = true;
        this.deviceListener.focusedDevice.register();
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.registerChannel(channel);
        }
        this.lx.engine.mixer.addListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.addListener(this.focusedChannelListener);
        this.lx.engine.mixer.cueA.addListener(this.cueAListener, true);
        this.lx.engine.mixer.cueB.addListener(this.cueBListener, true);
        this.lx.engine.tempo.enabled.addListener(this.tempoListener, true);
        this.sendGridMode();
    }

    private void unregister() {
        this.isRegistered = false;
        this.deviceListener.focusedDevice.unregister();
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.unregisterChannel(channel);
        }
        this.lx.engine.mixer.removeListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.removeListener(this.focusedChannelListener);
        this.lx.engine.mixer.cueA.removeListener(this.cueAListener);
        this.lx.engine.mixer.cueB.removeListener(this.cueBListener);
        this.lx.engine.tempo.enabled.removeListener(this.tempoListener);
        this.clearChannelGrid();
    }

    private void registerChannel(LXAbstractChannel channel) {
        this.channelListeners.put(channel, new ChannelListener(channel));
    }

    private void unregisterChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channelListener.dispose();
        }
    }

    private LXAbstractChannel getChannel(int index) {
        if (index < this.lx.engine.mixer.channels.size()) {
            return this.lx.engine.mixer.channels.get(index);
        }
        return null;
    }

    private LXAbstractChannel getChannel(LXShortMessage message) {
        return this.getChannel(message.getChannel());
    }

    private void noteReceived(MidiNote note, boolean on) {
        LXAbstractChannel channel;
        int pitch = note.getPitch();
        switch (pitch) {
            case 98: {
                this.shiftOn = on;
                return;
            }
            case 65: {
                if (on) {
                    this.lx.engine.tempo.enabled.toggle();
                }
                return;
            }
            case 99: {
                this.lx.engine.tempo.tap.setValue(on);
                return;
            }
            case 101: {
                this.lx.engine.tempo.nudgeDown.setValue(on);
                return;
            }
            case 100: {
                this.lx.engine.tempo.nudgeUp.setValue(on);
                return;
            }
        }
        switch (pitch) {
            case 52: 
            case 60: 
            case 61: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
            }
        }
        if (pitch >= 82 && pitch <= 86) {
            this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
        }
        if (!this.clipLaunchEnabled.isOn() && pitch >= 53 && pitch <= 57) {
            this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
        }
        if (on) {
            switch (pitch) {
                case 80: {
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.masterBus);
                    this.lx.engine.mixer.focusedChannel.setValue(this.lx.engine.mixer.channels.size());
                    return;
                }
                case 97: {
                    this.lx.engine.mixer.focusedChannel.decrement(false);
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    return;
                }
                case 96: {
                    this.lx.engine.mixer.focusedChannel.increment(false);
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    return;
                }
                case 94: {
                    LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                    if (bus instanceof LXChannel) {
                        ((LXChannel)bus).focusedPattern.decrement(this.shiftOn ? 5 : 1, false);
                    }
                    return;
                }
                case 95: {
                    LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                    if (bus instanceof LXChannel) {
                        ((LXChannel)bus).focusedPattern.increment(this.shiftOn ? 5 : 1, false);
                    }
                    return;
                }
                case 62: {
                    this.lx.engine.mixer.cueA.toggle();
                    return;
                }
                case 63: {
                    this.lx.engine.mixer.cueB.toggle();
                    return;
                }
                case 81: {
                    if (this.clipLaunchEnabled.isOn()) {
                        this.lx.engine.clips.stopClips();
                    }
                    return;
                }
            }
            if (pitch >= 82 && pitch <= 86) {
                if (this.clipLaunchEnabled.isOn()) {
                    this.lx.engine.clips.launchScene(pitch - 82);
                }
                return;
            }
            if (pitch >= 53 && pitch <= 57) {
                if (!this.clipLaunchEnabled.isOn()) {
                    return;
                }
                int channelIndex = note.getChannel();
                int index = pitch - 53;
                LXAbstractChannel channel2 = this.getChannel(channelIndex);
                if (channel2 != null) {
                    if (this.gridMode == GridMode.PATTERN) {
                        if (channel2 instanceof LXChannel) {
                            LXChannel c = (LXChannel)channel2;
                            if ((index += c.controlSurfaceFocusIndex.getValuei()) < c.getPatterns().size()) {
                                c.focusedPattern.setValue(index);
                                if (!this.shiftOn) {
                                    if (c.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                                        c.patterns.get((int)index).enabled.toggle();
                                    } else {
                                        c.goPatternIndex(index);
                                    }
                                }
                            }
                        }
                    } else if (this.gridMode == GridMode.CLIP) {
                        LXClip clip = channel2.getClip(index);
                        if (clip == null) {
                            clip = channel2.addClip(index);
                        } else if (clip.isRunning()) {
                            clip.stop();
                        } else {
                            clip.trigger();
                            this.lx.engine.clips.setFocusedClip(clip);
                        }
                    }
                }
                return;
            }
        }
        if ((channel = this.getChannel(note)) == null) {
            return;
        }
        if (!on) {
            return;
        }
        switch (note.getPitch()) {
            case 48: {
                channel.arm.toggle();
                return;
            }
            case 50: {
                channel.enabled.toggle();
                return;
            }
            case 49: {
                channel.cueActive.toggle();
                return;
            }
            case 66: {
                if (this.shiftOn) {
                    channel.blendMode.increment();
                } else {
                    channel.crossfadeGroup.increment();
                }
                return;
            }
            case 52: {
                channel.stopClips();
                return;
            }
            case 51: {
                if (this.shiftOn) {
                    if (channel instanceof LXChannel) {
                        ((LXChannel)channel).autoCycleEnabled.toggle();
                    }
                } else {
                    this.lx.engine.mixer.focusedChannel.setValue(channel.getIndex());
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                }
                return;
            }
            case 58: {
                this.toggleGridMode();
                return;
            }
            case 59: {
                this.deviceListener.onDeviceOnOff();
                return;
            }
            case 60: {
                this.deviceListener.focusedDevice.previousDevice();
                return;
            }
            case 61: {
                this.deviceListener.focusedDevice.nextDevice();
                return;
            }
            case 91: {
                LXBus focusedChannel = this.lx.engine.mixer.getFocusedChannel();
                if (focusedChannel instanceof LXChannel) {
                    LXChannel patternChannel = (LXChannel)focusedChannel;
                    patternChannel.goPattern(patternChannel.getFocusedPattern());
                }
                return;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: {
                return;
            }
        }
        LXMidiEngine.error("APC40 received unmapped note: " + note);
    }

    private void toggleGridMode() {
        if (this.gridMode == GridMode.PATTERN) {
            this.gridMode = GridMode.CLIP;
            this.sendChannelGrid();
        } else {
            this.gridMode = GridMode.PATTERN;
            this.sendChannelGrid();
        }
        this.sendGridMode();
    }

    private void sendGridMode() {
        this.sendNoteOn(0, 58, this.gridMode == GridMode.CLIP ? 1 : 0);
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int number = cc.getCC();
        switch (number) {
            case 47: {
                if (this.shiftOn) {
                    this.lx.engine.palette.color.primary.saturation.incrementValue(cc.getRelative());
                } else {
                    this.lx.engine.palette.color.primary.hue.incrementValue(cc.getRelative(), true);
                }
                return;
            }
            case 7: {
                int channel = cc.getChannel();
                if (channel < this.lx.engine.mixer.channels.size()) {
                    this.lx.engine.mixer.channels.get((int)channel).fader.setNormalized(cc.getNormalized());
                }
                return;
            }
            case 14: {
                if (this.masterFaderEnabled.isOn()) {
                    this.lx.engine.mixer.masterBus.fader.setNormalized(cc.getNormalized());
                }
                return;
            }
            case 15: {
                if (this.crossfaderEnabled.isOn()) {
                    this.lx.engine.mixer.crossfader.setNormalized(cc.getNormalized());
                }
                return;
            }
        }
        if (number >= 16 && number <= 24) {
            this.deviceListener.onKnob(number - 16, cc.getNormalized());
            return;
        }
        if (number >= 48 && number <= 55) {
            this.sendControlChange(cc.getChannel(), cc.getCC(), cc.getValue());
            return;
        }
        LXMidiEngine.error("APC40 unmapped CC: " + cc);
    }

    @Override
    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
        if (this.enabled.isOn()) {
            this.setApcMode((byte)64);
        }
        this.deviceListener.dispose();
        super.dispose();
    }

    public static enum GridMode {
        PATTERN,
        CLIP;

    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private final LXListenableNormalizedParameter[] knobs = new LXListenableNormalizedParameter[8];

        DeviceListener() {
            Arrays.fill(this.knobs, null);
            this.focusedDevice = new FocusedDevice(APC40.this.lx, APC40.this, this);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        void resend() {
            for (int i = 0; i < this.knobs.length; ++i) {
                LXListenableNormalizedParameter parameter = this.knobs[i];
                if (parameter != null) {
                    APC40.this.sendControlChange(0, 24 + i, parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2);
                    double normalized = parameter.getBaseNormalized();
                    APC40.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
                    continue;
                }
                APC40.this.sendControlChange(0, 24 + i, 0);
            }
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                isEnabled = effect.enabled.isOn();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                isEnabled = this.isPatternEnabled(pattern);
            }
            APC40.this.sendNoteOn(0, 59, isEnabled ? 1 : 0);
        }

        private boolean isPatternEnabled(LXPattern pattern) {
            switch (pattern.getChannel().compositeMode.getEnum()) {
                case BLEND: {
                    return pattern.enabled.isOn();
                }
            }
            return pattern == pattern.getChannel().getTargetPattern();
        }

        private void clearKnobsAfter(int i) {
            while (i < this.knobs.length) {
                APC40.this.sendControlChange(0, 24 + i, 0);
                ++i;
            }
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device == device) {
                return;
            }
            this.unregisterDevice();
            this.device = device;
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                effect.enabled.addListener(this);
                isEnabled = effect.isEnabled();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                pattern.enabled.addListener(this);
                isEnabled = this.isPatternEnabled(pattern);
            }
            if (this.device != null) {
                this.device.remoteControlsChanged.addListener(this);
            }
            APC40.this.sendNoteOn(0, 59, isEnabled ? 1 : 0);
            if (this.device == null) {
                this.clearKnobsAfter(0);
                return;
            }
            this.registerDeviceKnobs();
        }

        private void registerDeviceKnobs() {
            int i = 0;
            ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
            for (LXListenableNormalizedParameter parameter : this.device.getRemoteControls()) {
                if (i >= this.knobs.length) break;
                this.knobs[i] = parameter;
                if (parameter != null) {
                    if (!uniqueParameters.contains(parameter)) {
                        parameter.addListener(this);
                        uniqueParameters.add(parameter);
                    }
                    APC40.this.sendControlChange(0, 24 + i, parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2);
                    this.sendKnobValue(this.knobs[i], i);
                } else {
                    APC40.this.sendControlChange(0, 24 + i, 0);
                }
                ++i;
            }
            this.clearKnobsAfter(i);
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            LXPattern pattern;
            LXEffect effect = this.device instanceof LXEffect ? (LXEffect)this.device : null;
            LXPattern lXPattern = pattern = this.device instanceof LXPattern ? (LXPattern)this.device : null;
            if (parameter == this.device.remoteControlsChanged) {
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
            } else if (effect != null && parameter == effect.enabled) {
                APC40.this.sendNoteOn(0, 59, effect.enabled.isOn() ? 1 : 0);
            } else if (pattern != null && parameter == pattern.enabled) {
                APC40.this.sendNoteOn(0, 59, this.isPatternEnabled(pattern) ? 1 : 0);
                APC40.this.sendChannelPatterns(pattern.getChannel().getIndex(), pattern.getChannel());
            } else {
                for (int i = 0; i < this.knobs.length; ++i) {
                    if (parameter != this.knobs[i]) continue;
                    this.sendKnobValue(this.knobs[i], i);
                }
            }
        }

        private void sendKnobValue(LXListenableNormalizedParameter knobParam, int i) {
            double normalized = knobParam.getBaseNormalized();
            if (knobParam instanceof DiscreteParameter && knobParam.isWrappable()) {
                DiscreteParameter discrete = (DiscreteParameter)knobParam;
                normalized = ((float)(discrete.getBaseValuei() - discrete.getMinValue()) + 0.5f) / (float)discrete.getRange();
            }
            APC40.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
        }

        void onDeviceOnOff() {
            if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                LXChannel channel = pattern.getChannel();
                if (channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                    pattern.enabled.toggle();
                } else {
                    pattern.getChannel().goPatternIndex(pattern.getIndex());
                }
                APC40.this.sendNoteOn(0, 59, this.isPatternEnabled(pattern) ? 1 : 0);
            } else if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                effect.enabled.toggle();
            }
        }

        void onKnob(int index, double normalized) {
            if (this.knobs[index] != null) {
                if (this.knobs[index].isWrappable()) {
                    if (normalized == 0.0) {
                        normalized = 1.0;
                    } else if (normalized == 1.0) {
                        normalized = 0.0;
                    }
                }
                this.knobs[index].setNormalized(normalized);
            }
        }

        private void unregisterDevice() {
            if (this.device != null) {
                if (this.device instanceof LXEffect) {
                    LXEffect effect = (LXEffect)this.device;
                    effect.enabled.removeListener(this);
                }
                if (this.device instanceof LXPattern) {
                    LXPattern pattern = (LXPattern)this.device;
                    pattern.enabled.removeListener(this);
                }
                this.device.remoteControlsChanged.removeListener(this);
                this.unregisterDeviceKnobs();
                this.device = null;
            }
        }

        private void unregisterDeviceKnobs() {
            ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
            for (int i = 0; i < this.knobs.length; ++i) {
                if (this.knobs[i] == null) continue;
                if (!uniqueParameters.contains(this.knobs[i])) {
                    uniqueParameters.add(this.knobs[i]);
                    this.knobs[i].removeListener(this);
                }
                this.knobs[i] = null;
            }
        }

        private void dispose() {
            this.unregisterDevice();
        }
    }

    private class ChannelListener
    implements LXChannel.Listener,
    LXBus.ClipListener,
    LXParameterListener {
        private final LXAbstractChannel channel;
        private final LXParameterListener onCompositeModeChanged = this::onCompositeModeChanged;

        ChannelListener(LXAbstractChannel channel) {
            this.channel = channel;
            if (channel instanceof LXChannel) {
                ((LXChannel)channel).addListener(this);
                ((LXChannel)channel).compositeMode.addListener(this.onCompositeModeChanged);
            } else {
                channel.addListener(this);
            }
            channel.addClipListener(this);
            channel.cueActive.addListener(this);
            channel.enabled.addListener(this);
            channel.crossfadeGroup.addListener(this);
            channel.arm.addListener(this);
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.focusedPattern.addListener(this);
                c.controlSurfaceFocusLength.setValue(5.0);
                int focusedPatternIndex = c.getFocusedPatternIndex();
                c.controlSurfaceFocusIndex.setValue(focusedPatternIndex < 5 ? 0.0 : (double)(focusedPatternIndex - 5 + 1));
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                clip.running.addListener(this);
            }
        }

        public void dispose() {
            if (this.channel instanceof LXChannel) {
                ((LXChannel)this.channel).removeListener(this);
                ((LXChannel)this.channel).compositeMode.removeListener(this.onCompositeModeChanged);
            } else {
                this.channel.removeListener(this);
            }
            this.channel.removeClipListener(this);
            this.channel.cueActive.removeListener(this);
            this.channel.enabled.removeListener(this);
            this.channel.crossfadeGroup.removeListener(this);
            this.channel.arm.removeListener(this);
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                c.focusedPattern.removeListener(this);
                c.controlSurfaceFocusLength.setValue(0.0);
                c.controlSurfaceFocusIndex.setValue(0.0);
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                clip.running.removeListener(this);
            }
        }

        private void onCompositeModeChanged(LXParameter p) {
            int index = this.channel.getIndex();
            if (index >= 8) {
                return;
            }
            APC40.this.sendChannelPatterns(index, this.channel);
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            int index = this.channel.getIndex();
            if (index >= 8) {
                return;
            }
            if (p == this.channel.cueActive) {
                APC40.this.sendNoteOn(index, 49, this.channel.cueActive.isOn() ? 1 : 0);
            } else if (p == this.channel.enabled) {
                APC40.this.sendNoteOn(index, 50, this.channel.enabled.isOn() ? 1 : 0);
            } else if (p == this.channel.crossfadeGroup) {
                APC40.this.sendNoteOn(index, 66, this.channel.crossfadeGroup.getValuei());
            } else if (p == this.channel.arm) {
                APC40.this.sendNoteOn(index, 48, this.channel.arm.isOn() ? 1 : 0);
                APC40.this.sendChannelClips(this.channel.getIndex(), this.channel);
            } else if (p.getParent() instanceof LXClip) {
                APC40.this.sendChannelClips(index, this.channel);
            }
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                if (p == c.focusedPattern) {
                    int channelSurfaceIndex;
                    int focusedPatternIndex = c.getFocusedPatternIndex();
                    if (focusedPatternIndex < (channelSurfaceIndex = c.controlSurfaceFocusIndex.getValuei())) {
                        c.controlSurfaceFocusIndex.setValue(focusedPatternIndex);
                    } else if (focusedPatternIndex >= channelSurfaceIndex + 5) {
                        c.controlSurfaceFocusIndex.setValue(focusedPatternIndex - 5 + 1);
                    }
                    APC40.this.sendChannelPatterns(index, c);
                }
            }
        }

        @Override
        public void effectAdded(LXBus channel, LXEffect effect) {
        }

        @Override
        public void effectRemoved(LXBus channel, LXEffect effect) {
        }

        @Override
        public void effectMoved(LXBus channel, LXEffect effect) {
        }

        @Override
        public void indexChanged(LXAbstractChannel channel) {
        }

        @Override
        public void groupChanged(LXChannel channel, LXGroup group) {
        }

        @Override
        public void patternAdded(LXChannel channel, LXPattern pattern) {
            APC40.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            APC40.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternMoved(LXChannel channel, LXPattern pattern) {
            APC40.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
            APC40.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternDidChange(LXChannel channel, LXPattern pattern) {
            APC40.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void clipAdded(LXBus bus, LXClip clip) {
            clip.running.addListener(this);
            APC40.this.sendChannelClips(this.channel.getIndex(), this.channel);
        }

        @Override
        public void clipRemoved(LXBus bus, LXClip clip) {
            clip.running.removeListener(this);
            APC40.this.sendChannelClips(this.channel.getIndex(), this.channel);
        }
    }
}

