/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXSwatch;
import heronarts.lx.color.LinkedColorParameter;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.APC40Mk2Colors;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class APC40Mk2
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final String DEVICE_NAME = "APC40 mkII";
    public static final byte GENERIC_MODE = 64;
    public static final byte ABLETON_MODE = 65;
    public static final byte ABLETON_ALTERNATE_MODE = 66;
    protected static final int LED_STYLE_OFF = 0;
    protected static final int LED_STYLE_SINGLE = 1;
    protected static final int LED_STYLE_UNIPOLAR = 2;
    protected static final int LED_STYLE_BIPOLAR = 3;
    public static final int NUM_CHANNELS = 8;
    public static final int CLIP_LAUNCH_ROWS = 5;
    public static final int CLIP_LAUNCH_COLUMNS = 8;
    public static final int PALETTE_SWATCH_ROWS = 5;
    public static final int PALETTE_SWATCH_COLUMNS = 8;
    public static final int MASTER_SWATCH = -1;
    public static final int RAINBOW_GRID_COLUMNS = 72;
    public static final int RAINBOW_GRID_ROWS = 5;
    public static final int RAINBOW_HUE_STEP = 5;
    private static final int[] RAINBOW_GRID_SAT = new int[]{100, 70, 50, 100, 100};
    private static final int[] RAINBOW_GRID_BRI = new int[]{100, 100, 100, 50, 25};
    public static final int CHANNEL_FADER = 7;
    public static final int TEMPO = 13;
    public static final int MASTER_FADER = 14;
    public static final int CROSSFADER = 15;
    public static final int CUE_LEVEL = 47;
    public static final int DEVICE_KNOB = 16;
    public static final int DEVICE_KNOB_NUM = 8;
    public static final int DEVICE_KNOB_MAX = 24;
    public static final int DEVICE_KNOB_STYLE = 24;
    public static final int DEVICE_KNOB_STYLE_MAX = 32;
    public static final int CHANNEL_KNOB = 48;
    public static final int CHANNEL_KNOB_NUM = 8;
    public static final int CHANNEL_KNOB_MAX = 55;
    public static final int CHANNEL_KNOB_STYLE = 56;
    public static final int CHANNEL_KNOB_STYLE_MAX = 64;
    public static final int CLIP_LAUNCH = 0;
    public static final int CLIP_LAUNCH_NUM = 40;
    public static final int CLIP_LAUNCH_MAX = 39;
    public static final int CHANNEL_ARM = 48;
    public static final int CHANNEL_SOLO = 49;
    public static final int CHANNEL_ACTIVE = 50;
    public static final int CHANNEL_FOCUS = 51;
    public static final int CLIP_STOP = 52;
    public static final int DEVICE_LEFT = 58;
    public static final int DEVICE_RIGHT = 59;
    public static final int BANK_LEFT = 60;
    public static final int BANK_RIGHT = 61;
    public static final int DEVICE_ON_OFF = 62;
    public static final int DEVICE_LOCK = 63;
    public static final int CLIP_DEVICE_VIEW = 64;
    public static final int DETAIL_VIEW = 65;
    public static final int CHANNEL_CROSSFADE_GROUP = 66;
    public static final int MASTER_FOCUS = 80;
    public static final int STOP_ALL_CLIPS = 81;
    public static final int SCENE_LAUNCH = 82;
    public static final int SCENE_LAUNCH_NUM = 5;
    public static final int SCENE_LAUNCH_MAX = 86;
    public static final int PAN = 87;
    public static final int SENDS = 88;
    public static final int USER = 89;
    public static final int PLAY = 91;
    public static final int RECORD = 93;
    public static final int SESSION = 102;
    public static final int BANK_SELECT_UP = 94;
    public static final int BANK_SELECT_DOWN = 95;
    public static final int BANK_SELECT_RIGHT = 96;
    public static final int BANK_SELECT_LEFT = 97;
    public static final int SHIFT = 98;
    public static final int METRONOME = 90;
    public static final int TAP_TEMPO = 99;
    public static final int NUDGE_MINUS = 100;
    public static final int NUDGE_PLUS = 101;
    public static final int BANK = 103;
    public static final int LED_OFF = 0;
    public static final int LED_ON = 1;
    public static final int LED_GRAY = 2;
    public static final int LED_CYAN = 114;
    public static final int LED_GRAY_DIM = 117;
    public static final int LED_RED = 120;
    public static final int LED_RED_HALF = 121;
    public static final int LED_ORANGE_RED = 60;
    public static final int LED_GREEN = 122;
    public static final int LED_GREEN_HALF = 123;
    public static final int LED_YELLOW = 124;
    public static final int LED_AMBER = 126;
    public static final int LED_AMBER_HALF = 9;
    public static final int LED_AMBER_DIM = 10;
    public static final int LED_MODE_PRIMARY = 0;
    public static final int LED_MODE_PULSE = 10;
    public static final int LED_MODE_BLINK = 15;
    private boolean shiftOn = false;
    private boolean bankOn = true;
    private boolean deviceLockOn = false;
    private Integer colorClipboard = null;
    private LXDynamicColor focusColor = null;
    private boolean rainbowMode = false;
    private int rainbowColumnOffset = 0;
    private boolean isAux = false;
    private final APC40Mk2Colors apc40Mk2Colors = new APC40Mk2Colors();
    private final Map<LXAbstractChannel, ChannelListener> channelListeners = new HashMap<LXAbstractChannel, ChannelListener>();
    private final DeviceListener deviceListener;
    private GridMode gridMode = this.getGridMode();
    public final BooleanParameter masterFaderEnabled = new BooleanParameter("Master Fader", true).setDescription("Whether the master fader is enabled");
    public final BooleanParameter crossfaderEnabled = new BooleanParameter("Crossfader", true).setDescription("Whether the A/B crossfader is enabled");
    public final BooleanParameter performanceLock = new BooleanParameter("Performance Lock", false).setDescription("Keep surface in Performance mode regardless of Design/Perform toggle");
    private static final int[] RAINBOW_GRID = APC40Mk2.makeRainbowGrid();
    private final LXMixerEngine.Listener mixerEngineListener = new LXMixerEngine.Listener(){

        @Override
        public void channelRemoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40Mk2.this.unregisterChannel(channel);
            APC40Mk2.this.sendChannels();
        }

        @Override
        public void channelMoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40Mk2.this.sendChannels();
        }

        @Override
        public void channelAdded(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40Mk2.this.sendChannels();
            APC40Mk2.this.registerChannel(channel);
        }
    };
    private final LXParameterListener cueAListener = p -> {
        if (!this.isAuxActive()) {
            this.sendNoteOn(0, 64, this.lx.engine.mixer.cueA.isOn() ? 1 : 0);
        }
    };
    private final LXParameterListener cueBListener = p -> {
        if (!this.isAuxActive()) {
            this.sendNoteOn(0, 65, this.lx.engine.mixer.cueB.isOn() ? 1 : 0);
        }
    };
    private final LXParameterListener auxAListener = p -> {
        if (this.isAuxActive()) {
            this.sendNoteOn(0, 64, this.lx.engine.mixer.auxA.isOn() ? 1 : 0);
        }
    };
    private final LXParameterListener auxBListener = p -> {
        if (this.isAuxActive()) {
            this.sendNoteOn(0, 65, this.lx.engine.mixer.auxB.isOn() ? 1 : 0);
        }
    };
    private final LXParameterListener tempoListener = p -> this.sendNoteOn(0, 90, this.lx.engine.tempo.enabled.isOn() ? 1 : 0);
    private final LXParameterListener performanceModeListener = p -> this.updatePerformanceMode();
    private final LXParameterListener focusedChannelListener = p -> this.sendChannelFocus();
    private final LXParameterListener clipGridListener = p -> this.sendChannelGrid();
    private boolean isRegistered = false;
    private final CueState cueState = new CueState();
    private final CueState auxState = new CueState();

    private GridMode getGridMode() {
        if (this.deviceLockOn) {
            return GridMode.PALETTE;
        }
        if (this.bankOn) {
            return GridMode.PATTERN;
        }
        return GridMode.CLIP;
    }

    private void updateGridMode() {
        this.gridMode = this.getGridMode();
        this.sendChannelGrid();
        this.sendChannelFocus();
    }

    private LXListenableNormalizedParameter getActiveSubparameter(AggregateParameter agg) {
        if (agg instanceof LinkedColorParameter) {
            LinkedColorParameter lcp = (LinkedColorParameter)agg;
            if (lcp.mode.getEnum() == LinkedColorParameter.Mode.PALETTE) {
                return lcp.index;
            }
        }
        if (agg instanceof ColorParameter) {
            ColorParameter colorParameter = (ColorParameter)agg;
            if (this.shiftOn) {
                return colorParameter.saturation;
            }
            return colorParameter.hue;
        }
        LX.error("APC40Mk2 found AggregateParameter type with no subparameter: " + agg.getClass().getName());
        return null;
    }

    private void sendPerformanceLights() {
        boolean performanceMode = this.isPerformanceMode();
        this.sendNoteOn(0, 91, performanceMode && !this.isAux ? 1 : 0);
        this.sendNoteOn(0, 93, performanceMode && this.isAux ? 1 : 0);
        this.sendNoteOn(0, 102, performanceMode ? 1 : 0);
    }

    private void sendCueLights() {
        if (this.isAuxActive()) {
            this.sendNoteOn(0, 64, this.lx.engine.mixer.auxA.isOn() ? 1 : 0);
            this.sendNoteOn(0, 65, this.lx.engine.mixer.auxB.isOn() ? 1 : 0);
        } else {
            this.sendNoteOn(0, 64, this.lx.engine.mixer.cueA.isOn() ? 1 : 0);
            this.sendNoteOn(0, 65, this.lx.engine.mixer.cueB.isOn() ? 1 : 0);
        }
    }

    private void setAux(boolean isAux) {
        this.isAux = isAux;
        this.deviceListener.focusedDevice.setAux(isAux);
        this.lx.engine.performanceMode.setValue(true);
        this.sendPerformanceLights();
        this.sendCueLights();
        this.sendChannelFocus();
        this.sendChannelCues();
    }

    public APC40Mk2(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.deviceListener = new DeviceListener(lx);
        this.addSetting("masterFaderEnabled", this.masterFaderEnabled);
        this.addSetting("crossfaderEnabled", this.crossfaderEnabled);
        this.addSetting("performanceLock", this.performanceLock);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.performanceLock && this.enabled.isOn()) {
            this.updatePerformanceMode();
        }
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.setApcMode((byte)66);
            this.initialize(false);
            this.register();
        } else {
            this.deviceListener.registerDevice(null);
            for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
                if (!(channel instanceof LXChannel)) continue;
                ((LXChannel)channel).controlSurfaceFocusLength.setValue(0.0);
            }
            if (this.isRegistered) {
                this.unregister();
            }
            this.setApcMode((byte)64);
        }
    }

    @Override
    protected void onReconnect() {
        if (this.enabled.isOn()) {
            this.setApcMode((byte)66);
            this.initialize(true);
            this.deviceListener.resend();
        }
    }

    private void setApcMode(byte mode) {
        this.output.sendSysex(new byte[]{-16, 71, 0, 41, 96, 0, 4, mode, 9, 3, 1, -9});
    }

    private void initialize(boolean reconnect) {
        int i;
        this.output.sendNoteOn(0, 103, this.bankOn ? 1 : 0);
        this.output.sendNoteOn(0, 63, this.deviceLockOn ? 1 : 0);
        if (!reconnect) {
            this.resetPaletteVars();
        }
        this.sendPerformanceLights();
        for (i = 0; i < 8; ++i) {
            this.sendControlChange(0, 24 + i, 0);
        }
        for (i = 0; i < 8; ++i) {
            this.sendControlChange(0, 56 + i, 1);
            if (reconnect) continue;
            this.sendControlChange(0, 48 + i, 64);
        }
        this.sendChannels();
        this.cueState.reset();
        this.auxState.reset();
    }

    private void resetPaletteVars() {
        this.colorClipboard = null;
        this.focusColor = null;
        this.rainbowMode = false;
        this.clearSceneLaunch();
    }

    private void sendChannels() {
        for (int i = 0; i < 8; ++i) {
            this.sendChannel(i, this.getChannel(i));
        }
        this.sendChannelFocus();
    }

    private void sendChannelCues() {
        for (int i = 0; i < 8; ++i) {
            LXAbstractChannel channel = this.getChannel(i);
            if (channel != null) {
                this.sendNoteOn(i, 49, channel.cueActive.isOn() ? 1 : 0);
                this.sendNoteOn(i, 48, (this.isPerformanceMode() ? channel.auxActive.isOn() : channel.arm.isOn()) ? 1 : 0);
                continue;
            }
            this.sendNoteOn(i, 49, 0);
            this.sendNoteOn(i, 48, 0);
        }
    }

    private void sendChannelGrid() {
        if (!this.rainbowMode) {
            for (int i = 0; i < 8; ++i) {
                LXAbstractChannel channel = this.getChannel(i);
                this.sendChannelPatterns(i, channel);
                this.sendChannelClips(i, channel);
                this.sendSwatch(i);
            }
        }
        this.sendSwatch(-1);
    }

    private void clearChannelGrid() {
        for (int i = 0; i < 8; ++i) {
            this.sendChannel(i, null);
        }
    }

    private void sendChannel(int index, LXAbstractChannel channel) {
        if (channel != null) {
            this.sendNoteOn(index, 50, channel.enabled.isOn() ? 1 : 0);
            this.sendNoteOn(index, 66, channel.crossfadeGroup.getValuei());
            this.sendNoteOn(index, 49, channel.cueActive.isOn() ? 1 : 0);
            this.sendNoteOn(index, 48, (this.isPerformanceMode() ? channel.auxActive.isOn() : channel.arm.isOn()) ? 1 : 0);
        } else {
            this.sendNoteOn(index, 50, 0);
            this.sendNoteOn(index, 66, 0);
            this.sendNoteOn(index, 49, 0);
            this.sendNoteOn(index, 48, 0);
        }
        this.sendChannelPatterns(index, channel);
        this.sendChannelClips(index, channel);
    }

    private void sendChannelPatterns(int index, LXAbstractChannel channelBus) {
        if (index >= 8 || this.gridMode != GridMode.PATTERN) {
            return;
        }
        if (channelBus instanceof LXChannel) {
            LXChannel channel = (LXChannel)channelBus;
            boolean blendMode = channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND;
            int baseIndex = channel.controlSurfaceFocusIndex.getValuei();
            int endIndex = channel.patterns.size() - baseIndex;
            int activeIndex = channel.getActivePatternIndex() - baseIndex;
            int nextIndex = channel.getNextPatternIndex() - baseIndex;
            int focusedIndex = channel.patterns.size() == 0 ? -1 : channel.focusedPattern.getValuei() - baseIndex;
            for (int y = 0; y < 5; ++y) {
                int note = 0 + 8 * (4 - y) + index;
                int midiChannel = 0;
                int color = 0;
                if (blendMode) {
                    if (y < endIndex) {
                        color = channel.patterns.get((int)(baseIndex + y)).enabled.isOn() ? (y == focusedIndex ? 60 : 9) : (y == focusedIndex ? 2 : 117);
                    }
                } else if (y == activeIndex) {
                    color = 60;
                } else if (y == nextIndex) {
                    this.sendNoteOn(0, note, 60);
                    midiChannel = 10;
                    color = 9;
                } else if (y == focusedIndex) {
                    color = 10;
                } else if (y < endIndex) {
                    color = 117;
                }
                this.sendNoteOn(midiChannel, note, color);
            }
        } else {
            for (int y = 0; y < 5; ++y) {
                this.sendNoteOn(0, 0 + 8 * (4 - y) + index, 0);
            }
        }
    }

    private void sendChannelClips(int index, LXAbstractChannel channel) {
        int clipOffset = this.lx.engine.clips.clipViewGridOffset.getValuei();
        for (int i = 0; i < 5; ++i) {
            LXClip clip = null;
            int clipIndex = clipOffset + i;
            if (channel != null) {
                clip = channel.getClip(clipIndex);
            }
            this.sendClip(index, channel, clipIndex, clip);
        }
    }

    private void sendClip(int channelIndex, LXAbstractChannel channel, int clipIndex, LXClip clip) {
        int slotIndex = clipIndex - this.lx.engine.clips.clipViewGridOffset.getValuei();
        if (this.gridMode != GridMode.CLIP || channelIndex >= 8 || slotIndex >= 5) {
            return;
        }
        int color = 0;
        int mode = 0;
        int pitch = 0 + channelIndex + 8 * (4 - slotIndex);
        if (channel != null && clip != null) {
            int n = channel.arm.isOn() ? 121 : (color = clip.loop.isOn() ? 114 : 2);
            if (clip.isRunning()) {
                color = channel.arm.isOn() ? 120 : 122;
                this.sendNoteOn(0, pitch, color);
                mode = 10;
                color = channel.arm.isOn() ? 121 : (clip.loop.isOn() ? 114 : 123);
            }
        }
        this.sendNoteOn(mode, pitch, color);
    }

    private void clearSceneLaunch() {
        for (int i = 0; i < 5; ++i) {
            this.sendNoteOn(0, 82 + i, 0);
        }
    }

    private void sendDeviceOnOff() {
        this.deviceListener.sendDeviceOnOff();
    }

    private void sendSwatches() {
        for (int i = 0; i < 8; ++i) {
            this.sendSwatch(i);
        }
        this.sendSwatch(-1);
    }

    private void sendSwatch(int index) {
        if (this.gridMode != GridMode.PALETTE || index >= 8) {
            return;
        }
        LXSwatch swatch = this.getSwatch(index);
        for (int i = 0; i < 5; ++i) {
            int color = 0;
            int mode = 0;
            int pitch = index == -1 ? 82 + i : 0 + index + 8 * (4 - i);
            if (swatch != null && i < swatch.colors.size()) {
                int palColor = swatch.colors.get(i).getColor();
                color = this.apc40Mk2Colors.nearest(palColor);
            }
            this.sendNoteOn(mode, pitch, color);
        }
    }

    private static int[] makeRainbowGrid() {
        int[] rainbowGrid = new int[360];
        for (int col = 0; col < 72; ++col) {
            int hue = col * 5;
            for (int row = 0; row < 5; ++row) {
                int i = col * 5 + row;
                rainbowGrid[i++] = LXColor.hsb(hue, RAINBOW_GRID_SAT[row], RAINBOW_GRID_BRI[row]);
            }
        }
        return rainbowGrid;
    }

    private int rainbowGridColor(int relCol, int row) {
        int absCol = (72 + relCol + this.rainbowColumnOffset) % 72;
        return RAINBOW_GRID[absCol * 5 + row];
    }

    private void sendRainbowPickerGrid() {
        for (int col = 0; col < 8; ++col) {
            for (int row = 0; row < 5; ++row) {
                int pitch = 0 + col + 8 * (4 - row);
                int color = this.rainbowGridColor(col, row);
                int colorId = this.apc40Mk2Colors.nearest(color);
                this.sendNoteOn(0, pitch, colorId);
            }
        }
    }

    private void updateColorKnobs() {
        for (int i = 0; i < this.deviceListener.knobs.length; ++i) {
            LXListenableParameter knob = this.deviceListener.knobs[i];
            if (!(knob instanceof ColorParameter)) continue;
            ColorParameter cp = (ColorParameter)knob;
            LXListenableNormalizedParameter subparam = this.getActiveSubparameter(cp);
            double normalized = subparam.getNormalized();
            this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
        }
    }

    private void sendChannelFocus() {
        int focusedChannel = this.lx.engine.mixer.focusedChannel.getValuei();
        int focusedChannelAux = this.lx.engine.mixer.focusedChannelAux.getValuei();
        boolean masterFocused = focusedChannel == this.lx.engine.mixer.channels.size();
        boolean masterFocusedAux = focusedChannelAux == this.lx.engine.mixer.channels.size();
        boolean isAuxActive = this.isAuxActive();
        int focusedChannelMain = isAuxActive ? focusedChannelAux : focusedChannel;
        boolean masterFocusedMain = isAuxActive ? masterFocusedAux : masterFocused;
        int focusedChannelAlt = isAuxActive ? focusedChannel : focusedChannelAux;
        boolean masterFocusedAlt = isAuxActive ? masterFocused : masterFocusedAux;
        for (int i = 0; i < 8; ++i) {
            boolean clipStopOn = false;
            boolean focusOn = false;
            if (this.gridMode == GridMode.PALETTE) {
                if (!this.rainbowMode) {
                    clipStopOn = i < this.lx.engine.palette.swatches.size();
                }
            } else if (this.gridMode != GridMode.CLIP && this.gridMode == GridMode.PATTERN && this.isPerformanceMode()) {
                clipStopOn = !masterFocusedAlt && i == focusedChannelAlt;
            }
            focusOn = !masterFocusedMain && i == focusedChannelMain;
            this.sendNoteOn(i, 52, clipStopOn ? 1 : 0);
            this.sendNoteOn(i, 51, focusOn ? 1 : 0);
        }
        this.sendNoteOn(0, 80, masterFocusedMain ? 1 : 0);
    }

    private boolean isPerformanceMode() {
        return this.lx.engine.performanceMode.isOn() || this.performanceLock.isOn();
    }

    private boolean isAuxActive() {
        return this.isPerformanceMode() && this.isAux;
    }

    private void updatePerformanceMode() {
        this.sendPerformanceLights();
        this.sendCueLights();
        this.sendChannelFocus();
        this.sendChannelCues();
    }

    private void register() {
        this.isRegistered = true;
        this.deviceListener.focusedDevice.register();
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.registerChannel(channel);
        }
        this.lx.engine.performanceMode.addListener(this.performanceModeListener, true);
        this.lx.engine.clips.clipViewGridOffset.addListener(this.clipGridListener);
        this.lx.engine.clips.numScenes.addListener(this.clipGridListener);
        this.lx.engine.mixer.addListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.addListener(this.focusedChannelListener);
        this.lx.engine.mixer.focusedChannelAux.addListener(this.focusedChannelListener);
        this.lx.engine.mixer.cueA.addListener(this.cueAListener, true);
        this.lx.engine.mixer.cueB.addListener(this.cueBListener, true);
        this.lx.engine.mixer.auxA.addListener(this.auxAListener, true);
        this.lx.engine.mixer.auxB.addListener(this.auxBListener, true);
        this.lx.engine.tempo.enabled.addListener(this.tempoListener, true);
    }

    private void unregister() {
        this.isRegistered = false;
        this.deviceListener.focusedDevice.unregister();
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.unregisterChannel(channel);
        }
        this.lx.engine.performanceMode.removeListener(this.performanceModeListener);
        this.lx.engine.clips.clipViewGridOffset.removeListener(this.clipGridListener);
        this.lx.engine.clips.numScenes.removeListener(this.clipGridListener);
        this.lx.engine.mixer.removeListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.removeListener(this.focusedChannelListener);
        this.lx.engine.mixer.focusedChannelAux.removeListener(this.focusedChannelListener);
        this.lx.engine.mixer.cueA.removeListener(this.cueAListener);
        this.lx.engine.mixer.cueB.removeListener(this.cueBListener);
        this.lx.engine.mixer.auxA.removeListener(this.auxAListener);
        this.lx.engine.mixer.auxB.removeListener(this.auxBListener);
        this.lx.engine.tempo.enabled.removeListener(this.tempoListener);
        this.clearChannelGrid();
    }

    private void registerChannel(LXAbstractChannel channel) {
        this.channelListeners.put(channel, new ChannelListener(channel));
    }

    private void unregisterChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channelListener.dispose();
        }
    }

    private LXAbstractChannel getChannel(int index) {
        if (index < this.lx.engine.mixer.channels.size()) {
            return this.lx.engine.mixer.channels.get(index);
        }
        return null;
    }

    private LXAbstractChannel getChannel(LXShortMessage message) {
        return this.getChannel(message.getChannel());
    }

    private LXSwatch getSwatch(int index) {
        if (index < 0) {
            return this.lx.engine.palette.swatch;
        }
        if (index < this.lx.engine.palette.swatches.size()) {
            return this.lx.engine.palette.swatches.get(index);
        }
        return null;
    }

    private LXBus getFocusedChannel() {
        return this.isAuxActive() ? this.lx.engine.mixer.getFocusedChannelAux() : this.lx.engine.mixer.getFocusedChannel();
    }

    private DiscreteParameter getFocusedChannelTarget() {
        return this.isAuxActive() ? this.lx.engine.mixer.focusedChannelAux : this.lx.engine.mixer.focusedChannel;
    }

    private DiscreteParameter getFocusedChannelAltTarget() {
        return this.isAuxActive() ? this.lx.engine.mixer.focusedChannel : this.lx.engine.mixer.focusedChannelAux;
    }

    private void noteReceived(MidiNote note, boolean on) {
        int pitch = note.getPitch();
        switch (pitch) {
            case 98: {
                this.shiftOn = on;
                this.updateColorKnobs();
                return;
            }
            case 103: {
                if (on) {
                    if (this.shiftOn) {
                        this.lx.engine.clips.clipViewExpanded.toggle();
                    } else if (this.deviceLockOn) {
                        this.deviceLockOn = false;
                        this.sendNoteOn(note.getChannel(), 63, 0);
                        this.resetPaletteVars();
                    } else {
                        this.bankOn = !this.bankOn;
                        this.sendNoteOn(note.getChannel(), pitch, this.bankOn ? 1 : 0);
                    }
                    this.updateGridMode();
                }
                return;
            }
            case 63: {
                if (on) {
                    this.deviceLockOn = !this.deviceLockOn;
                    this.sendNoteOn(note.getChannel(), pitch, this.deviceLockOn ? 1 : 0);
                    if (!this.deviceLockOn) {
                        this.resetPaletteVars();
                    }
                    this.updateGridMode();
                }
                return;
            }
            case 90: {
                if (on) {
                    this.lx.engine.tempo.enabled.toggle();
                }
                return;
            }
            case 99: {
                if (this.rainbowMode) {
                    this.rainbowMode = false;
                    this.focusColor = null;
                    this.colorClipboard = null;
                    this.sendChannelFocus();
                    this.sendChannelGrid();
                } else {
                    this.lx.engine.tempo.tap.setValue(on);
                }
                return;
            }
            case 100: {
                this.lx.engine.tempo.nudgeDown.setValue(on);
                return;
            }
            case 101: {
                this.lx.engine.tempo.nudgeUp.setValue(on);
                return;
            }
        }
        switch (pitch) {
            case 52: {
                if (this.gridMode != GridMode.CLIP) break;
                this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
            }
        }
        if (pitch >= 82 && pitch <= 86 && this.gridMode != GridMode.PALETTE) {
            this.sendNoteOn(note.getChannel(), pitch, on ? 122 : 0);
        }
        if (on) {
            switch (pitch) {
                case 91: {
                    this.setAux(false);
                    return;
                }
                case 93: {
                    this.setAux(true);
                    return;
                }
                case 102: {
                    this.lx.engine.performanceMode.toggle();
                    return;
                }
                case 80: {
                    this.getFocusedChannelTarget().setValue(this.lx.engine.mixer.channels.size());
                    if (!this.isAuxActive()) {
                        this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.masterBus);
                    }
                    return;
                }
                case 97: {
                    this.deviceListener.focusedDevice.previousChannel();
                    if (!this.isAuxActive()) {
                        this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    }
                    return;
                }
                case 96: {
                    this.deviceListener.focusedDevice.nextChannel();
                    if (!this.isAuxActive()) {
                        this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    }
                    return;
                }
                case 94: {
                    LXBus bus = this.getFocusedChannel();
                    if (this.shiftOn) {
                        this.lx.engine.clips.clipViewGridOffset.decrement();
                    } else if (bus instanceof LXChannel) {
                        ((LXChannel)bus).focusedPattern.decrement(this.shiftOn ? 5 : 1, false);
                    }
                    return;
                }
                case 95: {
                    LXBus bus = this.getFocusedChannel();
                    if (this.shiftOn) {
                        this.lx.engine.clips.clipViewGridOffset.increment();
                    } else if (bus instanceof LXChannel) {
                        ((LXChannel)bus).focusedPattern.increment(this.shiftOn ? 5 : 1, false);
                    }
                    return;
                }
                case 64: {
                    if (this.isAuxActive()) {
                        this.lx.engine.mixer.auxA.toggle();
                    } else {
                        this.lx.engine.mixer.cueA.toggle();
                    }
                    return;
                }
                case 65: {
                    if (this.isAuxActive()) {
                        this.lx.engine.mixer.auxB.toggle();
                    } else {
                        this.lx.engine.mixer.cueB.toggle();
                    }
                    return;
                }
                case 81: {
                    if (this.gridMode == GridMode.PALETTE) {
                        this.colorClipboard = null;
                        this.focusColor = null;
                    } else if (this.gridMode == GridMode.CLIP) {
                        this.lx.engine.clips.stopClips();
                    } else if (this.gridMode == GridMode.PATTERN && this.isPerformanceMode()) {
                        this.getFocusedChannelAltTarget().setValue(this.lx.engine.mixer.channels.size());
                        if (this.isAuxActive()) {
                            this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.masterBus);
                        }
                    }
                    return;
                }
            }
            if (pitch >= 82 && pitch <= 86) {
                int index = pitch - 82;
                if (this.gridMode == GridMode.PALETTE) {
                    boolean colorChanged = false;
                    LXSwatch swatch = this.getSwatch(-1);
                    if (index > swatch.colors.size() - 1 && index < 5) {
                        swatch.addColor();
                        colorChanged = true;
                    }
                    this.focusColor = swatch.getColor(index);
                    if (this.colorClipboard != null) {
                        this.focusColor.primary.setColor(this.colorClipboard);
                        colorChanged = true;
                    }
                    if (colorChanged) {
                        this.sendSwatch(-1);
                    }
                } else {
                    this.lx.engine.clips.launchScene(index + this.lx.engine.clips.clipViewGridOffset.getValuei());
                }
                return;
            }
            if (pitch >= 0 && pitch <= 39) {
                int channelIndex = (pitch - 0) % 8;
                int index = 4 - (pitch - 0) / 8;
                if (this.rainbowMode) {
                    this.colorClipboard = this.rainbowGridColor(channelIndex, index);
                    return;
                }
                if (this.gridMode == GridMode.PALETTE) {
                    LXSwatch swatch = this.getSwatch(channelIndex);
                    if (swatch != null) {
                        if (index < swatch.colors.size()) {
                            this.focusColor = swatch.colors.get(index);
                            this.colorClipboard = this.focusColor.primary.getColor();
                        } else if (index < 5) {
                            LXDynamicColor color = swatch.addColor();
                            if (this.colorClipboard != null) {
                                color.primary.setColor(this.colorClipboard);
                            } else {
                                this.colorClipboard = color.primary.getColor();
                            }
                            this.sendSwatch(channelIndex);
                        } else {
                            this.colorClipboard = null;
                        }
                    }
                    return;
                }
                LXAbstractChannel channel = this.getChannel(channelIndex);
                if (channel != null) {
                    if (this.gridMode == GridMode.PATTERN) {
                        if (channel instanceof LXChannel) {
                            LXChannel c = (LXChannel)channel;
                            if ((index += c.controlSurfaceFocusIndex.getValuei()) < c.getPatterns().size()) {
                                c.focusedPattern.setValue(index);
                                if (!this.shiftOn) {
                                    if (c.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                                        c.patterns.get((int)index).enabled.toggle();
                                    } else {
                                        c.goPatternIndex(index);
                                    }
                                }
                            }
                        }
                    } else {
                        int clipIndex = index + this.lx.engine.clips.clipViewGridOffset.getValuei();
                        LXClip clip = channel.getClip(clipIndex);
                        if (clip == null) {
                            clip = channel.addClip(clipIndex);
                            clip.loop.setValue(this.shiftOn);
                        } else if (this.shiftOn) {
                            clip.loop.toggle();
                        } else if (clip.isRunning()) {
                            clip.stop();
                        } else {
                            clip.trigger();
                            this.lx.engine.clips.setFocusedClip(clip);
                        }
                    }
                }
                return;
            }
        }
        if (this.gridMode == GridMode.PALETTE) {
            if (this.rainbowMode || !on) {
                return;
            }
            switch (note.getPitch()) {
                case 52: {
                    int swatchNum = note.getChannel();
                    if (swatchNum >= this.lx.engine.palette.swatches.size()) break;
                    this.lx.engine.palette.setSwatch(this.lx.engine.palette.swatches.get(swatchNum));
                    this.sendSwatch(-1);
                    break;
                }
                default: {
                    LXMidiEngine.error("APC40mk2 in DEV_LOCK received unmapped note: " + note);
                }
            }
            return;
        }
        LXAbstractChannel channel = this.getChannel(note);
        if (channel == null) {
            return;
        }
        if (note.getPitch() == 49) {
            this.handleMultiCue(on, this.cueState, channel, false);
            return;
        }
        if (note.getPitch() == 48 && this.isPerformanceMode()) {
            this.handleMultiCue(on, this.auxState, channel, true);
            return;
        }
        if (!on) {
            return;
        }
        switch (note.getPitch()) {
            case 48: {
                if (this.isPerformanceMode()) break;
                channel.arm.toggle();
                break;
            }
            case 50: {
                channel.enabled.toggle();
                break;
            }
            case 66: {
                if (this.shiftOn) {
                    channel.blendMode.increment();
                    break;
                }
                channel.crossfadeGroup.increment();
                break;
            }
            case 52: {
                if (this.gridMode == GridMode.CLIP) {
                    channel.stopClips();
                    break;
                }
                if (this.gridMode != GridMode.PATTERN || !this.isPerformanceMode()) break;
                this.getFocusedChannelAltTarget().setValue(channel.getIndex());
                break;
            }
            case 51: {
                if (this.shiftOn) {
                    if (!(channel instanceof LXChannel)) break;
                    ((LXChannel)channel).autoCycleEnabled.toggle();
                    break;
                }
                this.getFocusedChannelTarget().setValue(channel.getIndex());
                if (this.isAuxActive()) break;
                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                break;
            }
            case 62: {
                this.deviceListener.onDeviceOnOff();
                break;
            }
            case 58: {
                this.deviceListener.focusedDevice.previousDevice();
                break;
            }
            case 59: {
                this.deviceListener.focusedDevice.nextDevice();
                break;
            }
            case 60: 
            case 61: {
                this.deviceListener.incrementBank(pitch == 60 ? -1 : 1);
                break;
            }
            default: {
                LXMidiEngine.error("APC40mk2 received unmapped note: " + note);
            }
        }
    }

    private void handleMultiCue(boolean on, CueState state, LXAbstractChannel channel, boolean aux) {
        BooleanParameter active;
        BooleanParameter booleanParameter = active = aux ? channel.auxActive : channel.cueActive;
        if (on) {
            boolean alreadyOn = active.isOn();
            state.singleCueStartedOn = state.cueDown == 0 && alreadyOn;
            if (alreadyOn) {
                if (state.cueDown == 0) {
                    if (aux) {
                        this.lx.engine.mixer.enableChannelAux(channel, true);
                    } else {
                        this.lx.engine.mixer.enableChannelCue(channel, true);
                    }
                } else {
                    active.setValue(false);
                }
            } else if (aux) {
                this.lx.engine.mixer.enableChannelAux(channel, state.cueDown == 0);
            } else {
                this.lx.engine.mixer.enableChannelCue(channel, state.cueDown == 0);
            }
            ++state.cueDown;
        } else {
            state.cueDown = LXUtils.max(0, state.cueDown - 1);
            if (state.singleCueStartedOn) {
                active.setValue(false);
                state.singleCueStartedOn = false;
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int number = cc.getCC();
        switch (number) {
            case 13: {
                if (this.gridMode == GridMode.PALETTE) {
                    if (this.rainbowMode) {
                        this.rainbowColumnOffset = (this.rainbowColumnOffset + cc.getRelative()) % 72;
                        this.focusColor = null;
                        this.colorClipboard = null;
                    } else {
                        this.rainbowMode = true;
                        this.sendChannelFocus();
                    }
                    this.sendRainbowPickerGrid();
                } else if (this.shiftOn) {
                    this.lx.engine.tempo.adjustBpm(0.1 * (double)cc.getRelative());
                } else {
                    this.lx.engine.tempo.adjustBpm(cc.getRelative());
                }
                return;
            }
            case 47: {
                if (this.focusColor == null) {
                    this.focusColor = this.lx.engine.palette.color;
                }
                LXListenableNormalizedParameter subparam = this.getActiveSubparameter(this.focusColor.primary);
                subparam.incrementValue(cc.getRelative());
                this.colorClipboard = this.focusColor.primary.getColor();
                if (this.gridMode == GridMode.PALETTE) {
                    if (this.rainbowMode) {
                        this.sendSwatch(-1);
                    } else {
                        this.sendSwatches();
                    }
                }
                return;
            }
            case 7: {
                int channel = cc.getChannel();
                if (channel < this.lx.engine.mixer.channels.size()) {
                    this.lx.engine.mixer.channels.get((int)channel).fader.setNormalized(cc.getNormalized());
                }
                return;
            }
            case 14: {
                if (this.masterFaderEnabled.isOn()) {
                    this.lx.engine.mixer.masterBus.fader.setNormalized(cc.getNormalized());
                }
                return;
            }
            case 15: {
                if (this.crossfaderEnabled.isOn()) {
                    this.lx.engine.mixer.crossfader.setNormalized(cc.getNormalized());
                }
                return;
            }
        }
        if (number >= 16 && number <= 24) {
            this.deviceListener.onKnob(number - 16, cc.getNormalized());
            return;
        }
        if (number >= 48 && number <= 55) {
            this.sendControlChange(cc.getChannel(), cc.getCC(), cc.getValue());
            return;
        }
    }

    @Override
    public int getRemoteControlStart() {
        return 8 * this.deviceListener.bankNumber;
    }

    @Override
    public int getRemoteControlLength() {
        return 8;
    }

    @Override
    public boolean isRemoteControlAux() {
        return this.isAuxActive();
    }

    @Override
    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
        if (this.enabled.isOn()) {
            this.setApcMode((byte)64);
        }
        this.deviceListener.dispose();
        super.dispose();
    }

    private static enum GridMode {
        PATTERN,
        CLIP,
        PALETTE;

    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private int bankNumber = 0;
        private final LXListenableParameter[] knobs = new LXListenableParameter[8];

        private DeviceListener(LX lx) {
            Arrays.fill(this.knobs, null);
            this.focusedDevice = new FocusedDevice(lx, APC40Mk2.this, this);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        private void resend() {
            for (int i = 0; i < this.knobs.length; ++i) {
                LXListenableNormalizedParameter parameter = this.parameterForKnob(this.knobs[i]);
                if (parameter != null) {
                    APC40Mk2.this.sendControlChange(0, 24 + i, parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2);
                    double normalized = parameter.getBaseNormalized();
                    APC40Mk2.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
                    continue;
                }
                APC40Mk2.this.sendControlChange(0, 24 + i, 0);
            }
            this.sendDeviceOnOff();
        }

        private void sendDeviceOnOff() {
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                isEnabled = effect.enabled.isOn();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                isEnabled = this.isPatternEnabled(pattern);
            }
            APC40Mk2.this.sendNoteOn(0, 62, isEnabled ? 1 : 0);
        }

        private void clearKnobsAfter(int i) {
            while (i < this.knobs.length) {
                APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                ++i;
            }
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device == device) {
                return;
            }
            this.unregisterDevice();
            this.device = device;
            this.bankNumber = 0;
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                effect.enabled.addListener(this);
                isEnabled = effect.isEnabled();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                pattern.enabled.addListener(this);
                isEnabled = this.isPatternEnabled(pattern);
            }
            if (this.device != null) {
                this.device.remoteControlsChanged.addListener(this);
            }
            APC40Mk2.this.sendNoteOn(0, 62, isEnabled ? 1 : 0);
            if (this.device == null) {
                this.clearKnobsAfter(0);
                return;
            }
            this.registerDeviceKnobs();
        }

        private boolean isPatternEnabled(LXPattern pattern) {
            switch (pattern.getChannel().compositeMode.getEnum()) {
                case BLEND: {
                    return pattern.enabled.isOn();
                }
            }
            return pattern == pattern.getChannel().getTargetPattern();
        }

        private void incrementBank(int amt) {
            int test;
            if (this.device != null && (test = this.bankNumber + amt) >= 0 && test * 8 < this.device.getRemoteControls().length) {
                this.bankNumber = test;
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
                this.focusedDevice.updateRemoteControlFocus();
            }
        }

        private void registerDeviceKnobs() {
            int i = 0;
            int skip = this.bankNumber * 8;
            int s = 0;
            ArrayList<LXListenableParameter> uniqueParameters = new ArrayList<LXListenableParameter>();
            if (this.device instanceof LXEffect) {
                uniqueParameters.add(((LXEffect)this.device).enabled);
            } else if (this.device instanceof LXPattern) {
                uniqueParameters.add(((LXPattern)this.device).enabled);
            }
            for (LXListenableNormalizedParameter parameter : this.device.getRemoteControls()) {
                LXListenableNormalizedParameter knobParam;
                if (s++ < skip) continue;
                if (i >= this.knobs.length) break;
                if (parameter == null) {
                    this.knobs[i] = null;
                    APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                    ++i;
                    continue;
                }
                AggregateParameter parent = parameter.getParentParameter();
                if (parent != null) {
                    this.knobs[i] = parent;
                    if (!uniqueParameters.contains(parent)) {
                        uniqueParameters.add(parent);
                        for (LXListenableParameter subParam : parent.subparameters.values()) {
                            subParam.addListener(this);
                        }
                    }
                } else {
                    this.knobs[i] = parameter;
                    if (!uniqueParameters.contains(parameter)) {
                        uniqueParameters.add(parameter);
                        parameter.addListener(this);
                    }
                }
                if ((knobParam = this.parameterForKnob(this.knobs[i])) == null) {
                    APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                } else {
                    int ledStyle = parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2;
                    APC40Mk2.this.sendControlChange(0, 24 + i, ledStyle);
                    this.sendKnobValue(knobParam, i);
                }
                ++i;
            }
            this.clearKnobsAfter(i);
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            LXPattern pattern;
            LXEffect effect = this.device instanceof LXEffect ? (LXEffect)this.device : null;
            LXPattern lXPattern = pattern = this.device instanceof LXPattern ? (LXPattern)this.device : null;
            if (parameter == this.device.remoteControlsChanged) {
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
            } else {
                if (effect != null && parameter == effect.enabled) {
                    APC40Mk2.this.sendNoteOn(0, 62, effect.enabled.isOn() ? 1 : 0);
                } else if (pattern != null && parameter == pattern.enabled) {
                    APC40Mk2.this.sendNoteOn(0, 62, this.isPatternEnabled(pattern) ? 1 : 0);
                    APC40Mk2.this.sendChannelPatterns(pattern.getChannel().getIndex(), pattern.getChannel());
                }
                for (int i = 0; i < this.knobs.length; ++i) {
                    LXListenableNormalizedParameter knobParam = this.parameterForKnob(this.knobs[i]);
                    if (parameter != knobParam) continue;
                    this.sendKnobValue(knobParam, i);
                }
            }
        }

        private void sendKnobValue(LXListenableNormalizedParameter knobParam, int i) {
            double normalized = knobParam.getBaseNormalized();
            if (knobParam instanceof DiscreteParameter && knobParam.isWrappable()) {
                DiscreteParameter discrete = (DiscreteParameter)knobParam;
                normalized = ((float)(discrete.getBaseValuei() - discrete.getMinValue()) + 0.5f) / (float)discrete.getRange();
            }
            APC40Mk2.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
        }

        private LXListenableNormalizedParameter parameterForKnob(LXListenableParameter knob) {
            if (knob == null || knob instanceof LXListenableNormalizedParameter) {
                return (LXListenableNormalizedParameter)knob;
            }
            if (knob instanceof AggregateParameter) {
                return APC40Mk2.this.getActiveSubparameter((AggregateParameter)knob);
            }
            return null;
        }

        private void onDeviceOnOff() {
            if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                LXChannel channel = pattern.getChannel();
                if (channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                    pattern.enabled.toggle();
                } else {
                    pattern.getChannel().goPatternIndex(pattern.getIndex());
                }
                APC40Mk2.this.sendNoteOn(0, 62, this.isPatternEnabled(pattern) ? 1 : 0);
            } else if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                effect.enabled.toggle();
            }
        }

        private void onKnob(int index, double normalized) {
            LXListenableNormalizedParameter knobParam;
            LXListenableParameter knob = this.knobs[index];
            if (knob == null) {
                return;
            }
            if (knob instanceof LinkedColorParameter) {
                int palIndex;
                LinkedColorParameter lcp = (LinkedColorParameter)knob;
                if (APC40Mk2.this.focusColor != null && (palIndex = APC40Mk2.this.lx.engine.palette.swatch.colors.indexOf(APC40Mk2.this.focusColor)) >= 0) {
                    lcp.mode.setValue((Object)LinkedColorParameter.Mode.PALETTE);
                    lcp.index.setValue(palIndex + 1);
                    return;
                }
                if (APC40Mk2.this.colorClipboard != null) {
                    lcp.mode.setValue((Object)LinkedColorParameter.Mode.STATIC);
                }
            }
            if (knob instanceof ColorParameter) {
                ColorParameter cp = (ColorParameter)knob;
                if (APC40Mk2.this.focusColor != null) {
                    cp.setColor(APC40Mk2.this.focusColor.getColor());
                    return;
                }
                if (APC40Mk2.this.colorClipboard != null) {
                    cp.setColor(APC40Mk2.this.colorClipboard);
                    return;
                }
            }
            if ((knobParam = this.parameterForKnob(knob)).isWrappable()) {
                if (normalized == 0.0) {
                    normalized = 1.0;
                } else if (normalized == 1.0) {
                    normalized = 0.0;
                }
            }
            knobParam.setNormalized(normalized);
        }

        private void unregisterDevice() {
            if (this.device != null) {
                if (this.device instanceof LXEffect) {
                    LXEffect effect = (LXEffect)this.device;
                    effect.enabled.removeListener(this);
                } else if (this.device instanceof LXPattern) {
                    LXPattern pattern = (LXPattern)this.device;
                    pattern.enabled.removeListener(this);
                }
                this.device.remoteControlsChanged.removeListener(this);
                this.unregisterDeviceKnobs();
                this.device = null;
            }
        }

        private void unregisterDeviceKnobs() {
            if (this.device != null) {
                ArrayList<LXListenableParameter> uniqueParameters = new ArrayList<LXListenableParameter>();
                if (this.device instanceof LXEffect) {
                    uniqueParameters.add(((LXEffect)this.device).enabled);
                } else if (this.device instanceof LXPattern) {
                    uniqueParameters.add(((LXPattern)this.device).enabled);
                }
                for (int i = 0; i < this.knobs.length; ++i) {
                    if (this.knobs[i] == null) continue;
                    if (this.knobs[i] instanceof AggregateParameter) {
                        AggregateParameter ap = (AggregateParameter)this.knobs[i];
                        if (!uniqueParameters.contains(ap)) {
                            uniqueParameters.add(ap);
                            for (LXListenableParameter sub : ap.subparameters.values()) {
                                sub.removeListener(this);
                            }
                        }
                    } else if (!uniqueParameters.contains(this.knobs[i])) {
                        uniqueParameters.add(this.knobs[i]);
                        this.knobs[i].removeListener(this);
                    }
                    this.knobs[i] = null;
                    APC40Mk2.this.sendControlChange(0, 16 + i, 0);
                    APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                }
            }
        }

        private void dispose() {
            this.unregisterDevice();
        }
    }

    private class CueState {
        private int cueDown = 0;
        private boolean singleCueStartedOn = false;

        private CueState() {
        }

        private void reset() {
            this.cueDown = 0;
            this.singleCueStartedOn = false;
        }
    }

    private class ChannelListener
    implements LXChannel.Listener,
    LXBus.ClipListener,
    LXParameterListener {
        private final LXAbstractChannel channel;
        private final LXParameterListener onCompositeModeChanged = this::onCompositeModeChanged;

        ChannelListener(LXAbstractChannel channel) {
            this.channel = channel;
            if (channel instanceof LXChannel) {
                ((LXChannel)channel).addListener(this);
                ((LXChannel)channel).compositeMode.addListener(this.onCompositeModeChanged);
            } else {
                channel.addListener(this);
            }
            channel.addClipListener(this);
            channel.cueActive.addListener(this);
            channel.auxActive.addListener(this);
            channel.enabled.addListener(this);
            channel.crossfadeGroup.addListener(this);
            channel.arm.addListener(this);
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.focusedPattern.addListener(this);
                c.controlSurfaceFocusLength.setValue(5.0);
                int focusedPatternIndex = c.getFocusedPatternIndex();
                c.controlSurfaceFocusIndex.setValue(focusedPatternIndex < 5 ? 0.0 : (double)(focusedPatternIndex - 5 + 1));
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                clip.running.addListener(this);
                clip.loop.addListener(this);
            }
        }

        public void dispose() {
            if (this.channel instanceof LXChannel) {
                ((LXChannel)this.channel).removeListener(this);
                ((LXChannel)this.channel).compositeMode.removeListener(this.onCompositeModeChanged);
            } else {
                this.channel.removeListener(this);
            }
            this.channel.removeClipListener(this);
            this.channel.cueActive.removeListener(this);
            this.channel.auxActive.removeListener(this);
            this.channel.enabled.removeListener(this);
            this.channel.crossfadeGroup.removeListener(this);
            this.channel.arm.removeListener(this);
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                c.focusedPattern.removeListener(this);
                c.controlSurfaceFocusLength.setValue(0.0);
                c.controlSurfaceFocusIndex.setValue(0.0);
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                clip.running.removeListener(this);
                clip.loop.removeListener(this);
            }
        }

        private void onCompositeModeChanged(LXParameter p) {
            int index = this.channel.getIndex();
            if (index >= 8) {
                return;
            }
            APC40Mk2.this.sendChannelPatterns(index, this.channel);
            APC40Mk2.this.sendDeviceOnOff();
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            int index = this.channel.getIndex();
            if (index >= 8) {
                return;
            }
            if (p == this.channel.cueActive) {
                APC40Mk2.this.sendNoteOn(index, 49, this.channel.cueActive.isOn() ? 1 : 0);
            } else if (p == this.channel.auxActive) {
                if (APC40Mk2.this.isPerformanceMode()) {
                    APC40Mk2.this.sendNoteOn(index, 48, this.channel.auxActive.isOn() ? 1 : 0);
                }
            } else if (p == this.channel.enabled) {
                APC40Mk2.this.sendNoteOn(index, 50, this.channel.enabled.isOn() ? 1 : 0);
            } else if (p == this.channel.crossfadeGroup) {
                APC40Mk2.this.sendNoteOn(index, 66, this.channel.crossfadeGroup.getValuei());
            } else if (p == this.channel.arm) {
                if (!APC40Mk2.this.isPerformanceMode()) {
                    APC40Mk2.this.sendNoteOn(index, 48, this.channel.arm.isOn() ? 1 : 0);
                }
                APC40Mk2.this.sendChannelClips(this.channel.getIndex(), this.channel);
            } else if (p.getParent() instanceof LXClip) {
                LXClip clip = (LXClip)p.getParent();
                APC40Mk2.this.sendClip(index, this.channel, clip.getIndex(), clip);
            }
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                if (p == c.focusedPattern) {
                    int channelSurfaceIndex;
                    int focusedPatternIndex = c.getFocusedPatternIndex();
                    if (focusedPatternIndex < (channelSurfaceIndex = c.controlSurfaceFocusIndex.getValuei())) {
                        c.controlSurfaceFocusIndex.setValue(focusedPatternIndex);
                    } else if (focusedPatternIndex >= channelSurfaceIndex + 5) {
                        c.controlSurfaceFocusIndex.setValue(focusedPatternIndex - 5 + 1);
                    }
                    APC40Mk2.this.sendChannelPatterns(index, c);
                }
            }
        }

        @Override
        public void patternAdded(LXChannel channel, LXPattern pattern) {
            APC40Mk2.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            APC40Mk2.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternMoved(LXChannel channel, LXPattern pattern) {
            APC40Mk2.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
            APC40Mk2.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void patternDidChange(LXChannel channel, LXPattern pattern) {
            APC40Mk2.this.sendChannelPatterns(channel.getIndex(), channel);
        }

        @Override
        public void clipAdded(LXBus bus, LXClip clip) {
            clip.running.addListener(this);
            clip.loop.addListener(this);
            APC40Mk2.this.sendClip(this.channel.getIndex(), this.channel, clip.getIndex(), clip);
        }

        @Override
        public void clipRemoved(LXBus bus, LXClip clip) {
            clip.running.removeListener(this);
            clip.loop.removeListener(this);
            APC40Mk2.this.sendChannelClips(this.channel.getIndex(), this.channel);
        }
    }
}

