/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import java.util.HashMap;
import java.util.Map;

public class APCmini
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final String DEVICE_NAME = "APC MINI";
    public static final int NUM_CHANNELS = 8;
    public static final double PARAMETER_INCREMENT_AMOUNT = 0.1;
    public static final int CHANNEL_FADER = 48;
    public static final int CHANNEL_FADER_MAX = 55;
    public static final int MASTER_FADER = 56;
    public static final int MIDI_CHANNEL = 0;
    public static final int CLIP_LAUNCH = 0;
    public static final int CLIP_LAUNCH_ROWS = 8;
    public static final int CLIP_LAUNCH_COLUMNS = 8;
    public static final int CLIP_LAUNCH_NUM = 64;
    public static final int CLIP_LAUNCH_MAX = 63;
    public static final int CHANNEL_BUTTON = 64;
    public static final int CHANNEL_BUTTON_MAX = 71;
    public static final int SCENE_LAUNCH = 82;
    public static final int SCENE_LAUNCH_NUM = 6;
    public static final int SCENE_LAUNCH_MAX = 87;
    public static final int TOGGLE_CLIPS = 88;
    public static final int TOGGLE_PARAMETERS = 89;
    public static final int PARAMETER_COLUMNS = 8;
    public static final int PARAMETER_COLUMN_STRIDE = 1;
    public static final int PARAMETER_ROWS = 2;
    public static final int PARAMETER_ROW_STRIDE = -4;
    public static final int PARAMETER_NUM = 16;
    public static final int PARAMETER_START = 56;
    public static final int SHIFT = 98;
    public static final int SELECT_UP = 64;
    public static final int SELECT_DOWN = 65;
    public static final int SELECT_LEFT = 66;
    public static final int SELECT_RIGHT = 67;
    public static final int FADER_CTRL_VOLUME = 68;
    public static final int FADER_CTRL_PAN = 69;
    public static final int FADER_CTRL_SEND = 70;
    public static final int FADER_CTRL_DEVICE = 71;
    public static final int CHANNEL_BUTTON_FOCUS = 68;
    public static final int CHANNEL_BUTTON_ENABLED = 69;
    public static final int CHANNEL_BUTTON_CUE = 70;
    public static final int CHANNEL_BUTTON_ARM = 71;
    public static final int CHANNEL_BUTTON_CROSSFADEGROUP = 0;
    public static final int CLIP_STOP = 82;
    public static final int SOLO = 83;
    public static final int REC_ARM = 84;
    public static final int MUTE = 85;
    public static final int SELECT = 86;
    public static final int EXTRA1 = 87;
    public static final int EXTRA2 = 88;
    public static final int STOP_ALL_CLIPS = 89;
    public static final int LED_OFF = 0;
    public static final int LED_ON = 1;
    public static final int LED_BLINK = 2;
    public static final int LED_GREEN = 1;
    public static final int LED_GREEN_BLINK = 2;
    public static final int LED_RED = 3;
    public static final int LED_RED_BLINK = 4;
    public static final int LED_YELLOW = 5;
    public static final int LED_YELLOW_BLINK = 6;
    public static final int LED_PATTERN_ACTIVE = 3;
    public static final int LED_PATTERN_TRANSITION = 4;
    public static final int LED_PATTERN_FOCUSED = 6;
    public static final int LED_PATTERN_INACTIVE = 5;
    public static final int LED_CLIP_INACTIVE = 5;
    public static final int LED_CLIP_PLAY = 1;
    public static final int LED_CLIP_ARM = 3;
    public static final int LED_CLIP_RECORD = 4;
    public static final int LED_PARAMETER_INCREMENT = 1;
    public static final int LED_PARAMETER_DECREMENT = 5;
    public static final int LED_PARAMETER_RESET = 3;
    public static final int LED_PARAMETER_ISDEFAULT = 0;
    private ChannelButtonMode channelButtonMode = ChannelButtonMode.FOCUS;
    private GridMode gridMode = GridMode.PATTERNS;
    private boolean shiftOn = false;
    private final Map<LXAbstractChannel, ChannelListener> channelListeners = new HashMap<LXAbstractChannel, ChannelListener>();
    private final DeviceListener deviceListener = new DeviceListener();
    private final LXMixerEngine.Listener mixerEngineListener = new LXMixerEngine.Listener(){

        @Override
        public void channelRemoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APCmini.this.unregisterChannel(channel);
            if (APCmini.this.gridMode != GridMode.PARAMETERS) {
                APCmini.this.sendGrid();
            }
        }

        @Override
        public void channelMoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            if (APCmini.this.gridMode != GridMode.PARAMETERS) {
                APCmini.this.sendGrid();
            } else {
                APCmini.this.sendChannelButtonRow();
            }
        }

        @Override
        public void channelAdded(LXMixerEngine mixer, LXAbstractChannel channel) {
            if (APCmini.this.gridMode != GridMode.PARAMETERS) {
                APCmini.this.sendGrid();
            }
            APCmini.this.registerChannel(channel);
        }
    };
    private final LXParameterListener focusedChannelListener = p -> {
        this.sendChannelFocus();
        this.deviceListener.registerChannel(this.lx.engine.mixer.getFocusedChannel());
    };
    private boolean isRegistered = false;

    public APCmini(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.initialize(false);
            this.register();
        } else {
            this.deviceListener.register(null);
            for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
                if (!(channel instanceof LXChannel)) continue;
                ((LXChannel)channel).controlSurfaceFocusLength.setValue(0.0);
            }
            if (this.isRegistered) {
                this.unregister();
            }
        }
    }

    @Override
    protected void onReconnect() {
        if (this.enabled.isOn()) {
            this.initialize(true);
            this.deviceListener.resend();
        }
    }

    private void initialize(boolean reconnect) {
        this.sendGrid();
    }

    private void sendGrid() {
        this.sendNoteOn(0, 88, this.gridMode == GridMode.CLIPS ? 1 : 0);
        this.sendNoteOn(0, 89, this.gridMode == GridMode.PARAMETERS ? 1 : 0);
        this.sendChannelButtonRow();
        if (this.gridMode == GridMode.PARAMETERS) {
            this.deviceListener.resend();
        } else {
            block4: for (int i = 0; i < 8; ++i) {
                LXAbstractChannel channel = this.getChannel(i);
                switch (this.gridMode) {
                    case PATTERNS: {
                        this.sendChannelPatterns(i, channel);
                        continue block4;
                    }
                    case CLIPS: {
                        this.sendChannelClips(i, channel);
                        continue block4;
                    }
                }
            }
        }
    }

    private void clearGrid() {
        this.sendNoteOn(0, 88, 0);
        this.sendNoteOn(0, 89, 0);
        for (int i = 0; i < 8; ++i) {
            this.sendChannelPatterns(i, null);
        }
    }

    private void sendChannelPatterns(int index, LXAbstractChannel channelBus) {
        if (index >= 8) {
            return;
        }
        if (channelBus instanceof LXChannel) {
            LXChannel channel = (LXChannel)channelBus;
            int baseIndex = channel.controlSurfaceFocusIndex.getValuei();
            int endIndex = channel.patterns.size() - baseIndex;
            int activeIndex = channel.getActivePatternIndex() - baseIndex;
            int nextIndex = channel.getNextPatternIndex() - baseIndex;
            int focusedIndex = channel.focusedPattern.getValuei() - baseIndex;
            if (channel.patterns.size() == 0) {
                focusedIndex = -1;
            }
            for (int y = 0; y < 8; ++y) {
                int note = 0 + 8 * (7 - y) + index;
                int color = 0;
                if (y == activeIndex) {
                    color = 3;
                } else if (y == nextIndex) {
                    color = 4;
                } else if (y == focusedIndex) {
                    color = 6;
                } else if (y < endIndex) {
                    color = 5;
                }
                this.sendNoteOn(0, note, color);
            }
        } else {
            for (int y = 0; y < 8; ++y) {
                this.sendNoteOn(0, 0 + 8 * (7 - y) + index, 0);
            }
        }
    }

    private void sendChannelClips(int index, LXAbstractChannel channel) {
        for (int i = 0; i < 8; ++i) {
            LXClip clip = null;
            if (channel != null) {
                clip = channel.getClip(i);
            }
            this.sendClip(index, channel, i, clip);
        }
    }

    private void sendClip(int channelIndex, LXAbstractChannel channel, int clipIndex, LXClip clip) {
        if (this.gridMode != GridMode.CLIPS || channelIndex >= 8 || clipIndex >= 8) {
            return;
        }
        int color = 0;
        int pitch = 0 + channelIndex + 8 * (7 - clipIndex);
        if (channel != null && clip != null) {
            color = channel.arm.isOn() ? (clip.isRunning() ? 4 : 3) : (clip.isRunning() ? 1 : 5);
        }
        this.sendNoteOn(0, pitch, color);
    }

    private void sendChannelFocus() {
        if (this.channelButtonMode == ChannelButtonMode.FOCUS && !this.shiftOn) {
            this.sendChannelButtonRow();
        }
    }

    private void setChannelButtonMode(ChannelButtonMode mode) {
        this.channelButtonMode = mode;
        this.sendChannelButtonRow();
    }

    private void sendChannelButtonRow() {
        for (int i = 0; i < 8; ++i) {
            this.sendChannelButton(i, this.getChannel(i));
        }
    }

    private void clearChannelButtonRow() {
        for (int i = 0; i < 8; ++i) {
            this.sendNoteOn(0, 64 + i, 0);
        }
    }

    private void sendChannelButton(int index, LXAbstractChannel channel) {
        if (this.shiftOn) {
            int shiftCode = index + 64;
            int color = 0;
            switch (shiftCode) {
                case 68: {
                    color = this.channelButtonMode == ChannelButtonMode.FOCUS ? 1 : 0;
                    break;
                }
                case 69: {
                    color = this.channelButtonMode == ChannelButtonMode.ENABLED ? 1 : 0;
                    break;
                }
                case 70: {
                    color = this.channelButtonMode == ChannelButtonMode.CUE ? 1 : 0;
                    break;
                }
                case 71: {
                    color = this.channelButtonMode == ChannelButtonMode.ARM ? 1 : 0;
                }
            }
            this.sendNoteOn(0, 64 + index, color);
        } else if (channel != null) {
            switch (this.channelButtonMode) {
                case FOCUS: {
                    this.sendNoteOn(0, 64 + index, index == this.lx.engine.mixer.focusedChannel.getValuei() ? 1 : 0);
                    break;
                }
                case ENABLED: {
                    this.sendNoteOn(0, 64 + index, channel.enabled.isOn() ? 1 : 0);
                    break;
                }
                case CUE: {
                    this.sendNoteOn(0, 64 + index, channel.cueActive.isOn() ? 1 : 0);
                    break;
                }
                case ARM: {
                    this.sendNoteOn(0, 64 + index, channel.arm.isOn() ? 1 : 0);
                    break;
                }
                case CROSSFADEGROUP: {
                    this.sendNoteOn(0, 64 + index, 0);
                }
            }
        } else {
            this.sendNoteOn(0, 64 + index, 0);
        }
    }

    private void register() {
        this.isRegistered = true;
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.registerChannel(channel);
        }
        this.lx.engine.mixer.addListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.addListener(this.focusedChannelListener);
        this.deviceListener.registerChannel(this.lx.engine.mixer.getFocusedChannel());
    }

    private void unregister() {
        this.isRegistered = false;
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.unregisterChannel(channel);
        }
        this.lx.engine.mixer.removeListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.removeListener(this.focusedChannelListener);
        this.clearGrid();
        this.clearChannelButtonRow();
    }

    private void registerChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = new ChannelListener(channel);
        this.channelListeners.put(channel, channelListener);
    }

    private void unregisterChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channelListener.dispose();
        }
    }

    private LXAbstractChannel getChannel(int index) {
        if (index < this.lx.engine.mixer.channels.size()) {
            return this.lx.engine.mixer.channels.get(index);
        }
        return null;
    }

    private void noteReceived(MidiNote note, boolean on) {
        int pitch = note.getPitch();
        if (pitch == 98) {
            this.shiftOn = on;
            this.sendChannelButtonRow();
            return;
        }
        if (this.shiftOn) {
            switch (pitch) {
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 89: {
                    this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
                }
            }
            if (on) {
                switch (pitch) {
                    case 66: {
                        if (this.gridMode == GridMode.PARAMETERS) {
                            this.deviceListener.registerPrevious();
                        } else {
                            this.lx.engine.mixer.focusedChannel.decrement(false);
                            this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                        }
                        return;
                    }
                    case 67: {
                        if (this.gridMode == GridMode.PARAMETERS) {
                            this.deviceListener.registerNext();
                        } else {
                            this.lx.engine.mixer.focusedChannel.increment(false);
                            this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                        }
                        return;
                    }
                    case 64: {
                        LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.decrement(1, false);
                        }
                        return;
                    }
                    case 65: {
                        LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.increment(1, false);
                        }
                        return;
                    }
                    case 68: {
                        this.setChannelButtonMode(ChannelButtonMode.FOCUS);
                        return;
                    }
                    case 69: {
                        this.setChannelButtonMode(ChannelButtonMode.ENABLED);
                        return;
                    }
                    case 70: {
                        this.setChannelButtonMode(ChannelButtonMode.CUE);
                        return;
                    }
                    case 71: {
                        this.setChannelButtonMode(ChannelButtonMode.ARM);
                        return;
                    }
                    case 0: {
                        return;
                    }
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: {
                        return;
                    }
                    case 89: {
                        this.lx.engine.clips.stopClips();
                        return;
                    }
                }
            }
        } else {
            if (pitch >= 82 && pitch <= 87) {
                this.sendNoteOn(note.getChannel(), pitch, on ? 1 : 0);
            }
            if (on) {
                LXAbstractChannel channel;
                switch (pitch) {
                    case 88: {
                        this.gridMode = this.gridMode == GridMode.CLIPS ? GridMode.PATTERNS : GridMode.CLIPS;
                        this.sendGrid();
                        return;
                    }
                    case 89: {
                        this.gridMode = this.gridMode == GridMode.PARAMETERS ? GridMode.PATTERNS : GridMode.PARAMETERS;
                        this.sendGrid();
                        return;
                    }
                }
                if (pitch >= 82 && pitch <= 87) {
                    this.lx.engine.clips.launchScene(pitch - 82);
                    return;
                }
                if (pitch >= 0 && pitch <= 63) {
                    int channelIndex = (pitch - 0) % 8;
                    int index = 7 - (pitch - 0) / 8;
                    if (this.gridMode == GridMode.PARAMETERS) {
                        this.deviceListener.onParameterButton(channelIndex, index);
                        return;
                    }
                    LXAbstractChannel channel2 = this.getChannel(channelIndex);
                    if (channel2 != null) {
                        if (this.gridMode == GridMode.CLIPS) {
                            LXClip clip = channel2.getClip(index);
                            if (clip == null) {
                                clip = channel2.addClip(index);
                            } else if (clip.isRunning()) {
                                clip.stop();
                            } else {
                                clip.trigger();
                                this.lx.engine.clips.setFocusedClip(clip);
                            }
                        } else if (channel2 instanceof LXChannel) {
                            LXChannel c = (LXChannel)channel2;
                            if ((index += c.controlSurfaceFocusIndex.getValuei()) < c.getPatterns().size()) {
                                c.focusedPattern.setValue(index);
                                if (!this.shiftOn) {
                                    c.goPatternIndex(index);
                                }
                            }
                        }
                    }
                    return;
                }
                if (pitch >= 64 && pitch <= 71 && (channel = this.getChannel(pitch - 64)) != null) {
                    switch (this.channelButtonMode) {
                        case FOCUS: {
                            this.lx.engine.mixer.focusedChannel.setValue(channel.getIndex());
                            this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                            break;
                        }
                        case ENABLED: {
                            channel.enabled.toggle();
                            break;
                        }
                        case CUE: {
                            channel.cueActive.toggle();
                            break;
                        }
                        case ARM: {
                            channel.arm.toggle();
                            break;
                        }
                        case CROSSFADEGROUP: {
                            channel.crossfadeGroup.increment();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int number = cc.getCC();
        switch (number) {
            case 56: {
                this.lx.engine.mixer.masterBus.fader.setNormalized(cc.getNormalized());
                return;
            }
        }
        if (number >= 48 && number <= 55) {
            int channel = number - 48;
            if (channel < this.lx.engine.mixer.channels.size()) {
                this.lx.engine.mixer.channels.get((int)channel).fader.setNormalized(cc.getNormalized());
            }
            return;
        }
        LXMidiEngine.error("APC MINI unmapped control change: " + cc);
    }

    @Override
    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
        this.deviceListener.dispose();
        super.dispose();
    }

    public static enum ChannelButtonMode {
        ARM,
        CROSSFADEGROUP,
        CUE,
        ENABLED,
        FOCUS;

    }

    public static enum GridMode {
        PATTERNS,
        PARAMETERS,
        CLIPS;

    }

    private class DeviceListener
    implements LXParameterListener {
        private LXDeviceComponent device = null;
        private LXEffect effect = null;
        private LXPattern pattern = null;
        private LXBus channel = null;
        private final LXListenableNormalizedParameter[] knobs = new LXListenableNormalizedParameter[16];

        DeviceListener() {
            for (int i = 0; i < this.knobs.length; ++i) {
                this.knobs[i] = null;
            }
        }

        void resend() {
            if (APCmini.this.gridMode == GridMode.PARAMETERS) {
                for (int i = 0; i < this.knobs.length; ++i) {
                    LXListenableNormalizedParameter parameter = this.knobs[i];
                    int patternButton = this.getPatternButton(i);
                    if (parameter != null) {
                        APCmini.this.sendNoteOn(0, patternButton, 1);
                        APCmini.this.sendNoteOn(0, patternButton - 8, 5);
                        APCmini.this.sendNoteOn(0, patternButton - 16, parameter.isDefault() ? 0 : 3);
                    } else {
                        APCmini.this.sendNoteOn(0, patternButton, 0);
                        APCmini.this.sendNoteOn(0, patternButton - 8, 0);
                        APCmini.this.sendNoteOn(0, patternButton - 16, 0);
                    }
                    APCmini.this.sendNoteOn(0, patternButton - 24, 0);
                }
            }
        }

        int getPatternButton(int index) {
            int row = index / 8;
            int column = index % 8;
            return 56 + row * 8 * -4 + column * 1;
        }

        void registerChannel(LXBus channel) {
            this.unregisterChannel();
            this.channel = channel;
            if (channel instanceof LXChannel) {
                ((LXChannel)channel).focusedPattern.addListener(this);
                this.register(((LXChannel)channel).getFocusedPattern());
            } else if (channel.effects.size() > 0) {
                this.register(channel.getEffect(0));
            } else {
                this.register(null);
            }
        }

        void registerPrevious() {
            if (this.effect != null) {
                int effectIndex = this.effect.getIndex();
                if (effectIndex > 0) {
                    this.register(this.effect.getBus().getEffect(effectIndex - 1));
                } else if (this.channel instanceof LXChannel) {
                    this.register(((LXChannel)this.channel).getFocusedPattern());
                }
            }
        }

        void registerNext() {
            if (this.effect != null) {
                int effectIndex = this.effect.getIndex();
                if (effectIndex < this.effect.getBus().effects.size() - 1) {
                    this.register(this.effect.getBus().getEffect(effectIndex + 1));
                }
            } else if (this.pattern != null && this.channel.effects.size() > 0) {
                this.register(this.channel.getEffect(0));
            }
        }

        void register(LXDeviceComponent device) {
            if (this.device != device) {
                this.unregister(false);
                this.device = device;
                if (this.device instanceof LXPattern) {
                    this.pattern = (LXPattern)this.device;
                }
                int i = 0;
                if (this.device != null) {
                    for (LXListenableNormalizedParameter parameter : this.device.getRemoteControls()) {
                        if (i >= this.knobs.length) break;
                        this.knobs[i] = parameter;
                        int patternButton = this.getPatternButton(i);
                        if (parameter != null) {
                            parameter.addListener(this);
                            if (APCmini.this.gridMode == GridMode.PARAMETERS) {
                                APCmini.this.sendNoteOn(0, patternButton, 1);
                                APCmini.this.sendNoteOn(0, patternButton - 8, 5);
                                APCmini.this.sendNoteOn(0, patternButton - 16, parameter.isDefault() ? 0 : 3);
                                APCmini.this.sendNoteOn(0, patternButton - 24, 0);
                            }
                        } else {
                            APCmini.this.sendNoteOn(0, patternButton, 0);
                            APCmini.this.sendNoteOn(0, patternButton - 8, 0);
                            APCmini.this.sendNoteOn(0, patternButton - 16, 0);
                            APCmini.this.sendNoteOn(0, patternButton - 24, 0);
                        }
                        ++i;
                    }
                    this.device.controlSurfaceSemaphore.increment();
                }
                if (APCmini.this.gridMode == GridMode.PARAMETERS) {
                    while (i < this.knobs.length) {
                        int patternButton = this.getPatternButton(i);
                        APCmini.this.sendNoteOn(0, patternButton, 0);
                        APCmini.this.sendNoteOn(0, patternButton - 8, 0);
                        APCmini.this.sendNoteOn(0, patternButton - 16, 0);
                        APCmini.this.sendNoteOn(0, patternButton - 24, 0);
                        ++i;
                    }
                }
            }
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            block3: {
                block2: {
                    if (this.channel == null || !(this.channel instanceof LXChannel) || parameter != ((LXChannel)this.channel).focusedPattern) break block2;
                    if (this.device != null && !(this.device instanceof LXPattern)) break block3;
                    this.register(((LXChannel)this.channel).getFocusedPattern());
                    break block3;
                }
                if (APCmini.this.gridMode == GridMode.PARAMETERS) {
                    for (int i = 0; i < this.knobs.length; ++i) {
                        if (parameter != this.knobs[i]) continue;
                        int patternButton = this.getPatternButton(i);
                        APCmini.this.sendNoteOn(0, patternButton - 16, ((LXListenableNormalizedParameter)parameter).isDefault() ? 0 : 3);
                        break;
                    }
                }
            }
        }

        void onParameterButton(int columnIndex, int rowIndex) {
            int button;
            int paramIndex = 0;
            for (button = rowIndex; button > 3; button -= 4) {
                paramIndex += 8;
            }
            LXListenableNormalizedParameter param = this.knobs[paramIndex += columnIndex];
            if (param != null) {
                switch (button) {
                    case 0: {
                        if (param instanceof BooleanParameter) {
                            ((BooleanParameter)param).setValue(true);
                            break;
                        }
                        if (param instanceof DiscreteParameter) {
                            ((DiscreteParameter)param).increment();
                            break;
                        }
                        param.setNormalized(param.getNormalized() + 0.1);
                        break;
                    }
                    case 1: {
                        if (param instanceof BooleanParameter) {
                            ((BooleanParameter)param).setValue(false);
                            break;
                        }
                        if (param instanceof DiscreteParameter) {
                            ((DiscreteParameter)param).decrement();
                            break;
                        }
                        param.setNormalized(param.getNormalized() - 0.1);
                        break;
                    }
                    case 2: {
                        param.reset();
                    }
                }
            }
        }

        private void unregister(boolean clearParams) {
            if (this.device != null) {
                for (int i = 0; i < this.knobs.length; ++i) {
                    if (this.knobs[i] == null) continue;
                    this.knobs[i].removeListener(this);
                    this.knobs[i] = null;
                    if (APCmini.this.gridMode != GridMode.PARAMETERS || !clearParams) continue;
                    int patternButton = this.getPatternButton(i);
                    APCmini.this.sendNoteOn(0, patternButton, 0);
                    APCmini.this.sendNoteOn(0, patternButton - 8, 0);
                    APCmini.this.sendNoteOn(0, patternButton - 16, 0);
                    APCmini.this.sendNoteOn(0, patternButton - 24, 0);
                }
                this.device.controlSurfaceSemaphore.decrement();
            }
            this.pattern = null;
            this.effect = null;
            this.device = null;
        }

        private void unregisterChannel() {
            if (this.channel != null && this.channel instanceof LXChannel) {
                ((LXChannel)this.channel).focusedPattern.removeListener(this);
            }
            this.channel = null;
        }

        private void dispose() {
            this.unregister(true);
            this.unregisterChannel();
        }
    }

    private class ChannelListener
    implements LXChannel.Listener,
    LXBus.ClipListener,
    LXParameterListener {
        private final LXAbstractChannel channel;

        ChannelListener(LXAbstractChannel channel) {
            this.channel = channel;
            if (channel instanceof LXChannel) {
                ((LXChannel)channel).addListener(this);
            } else {
                channel.addListener(this);
            }
            channel.addClipListener(this);
            channel.cueActive.addListener(this);
            channel.enabled.addListener(this);
            channel.crossfadeGroup.addListener(this);
            channel.arm.addListener(this);
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.focusedPattern.addListener(this);
                c.controlSurfaceFocusLength.setValue(8.0);
                int focusedPatternIndex = c.getFocusedPatternIndex();
                c.controlSurfaceFocusIndex.setValue(focusedPatternIndex < 8 ? 0.0 : (double)(focusedPatternIndex - 8 + 1));
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                clip.running.addListener(this);
            }
        }

        public void dispose() {
            if (this.channel instanceof LXChannel) {
                ((LXChannel)this.channel).removeListener(this);
            } else {
                this.channel.removeListener(this);
            }
            this.channel.removeClipListener(this);
            this.channel.cueActive.removeListener(this);
            this.channel.enabled.removeListener(this);
            this.channel.crossfadeGroup.removeListener(this);
            this.channel.arm.removeListener(this);
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                c.focusedPattern.removeListener(this);
                c.controlSurfaceFocusLength.setValue(0.0);
                c.controlSurfaceFocusIndex.setValue(0.0);
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                clip.running.removeListener(this);
            }
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            int index = this.channel.getIndex();
            if (index >= 8) {
                return;
            }
            if (p == this.channel.cueActive) {
                if (APCmini.this.channelButtonMode == ChannelButtonMode.CUE) {
                    APCmini.this.sendNoteOn(0, 64 + index, this.channel.cueActive.isOn() ? 1 : 0);
                }
            } else if (p == this.channel.enabled) {
                if (APCmini.this.channelButtonMode == ChannelButtonMode.ENABLED) {
                    APCmini.this.sendNoteOn(0, 64 + index, this.channel.enabled.isOn() ? 1 : 0);
                }
            } else if (p == this.channel.crossfadeGroup) {
                APCmini.this.sendNoteOn(0, 64 + index, 0);
            } else if (p == this.channel.arm) {
                APCmini.this.sendNoteOn(0, 64 + index, this.channel.arm.isOn() ? 1 : 0);
                APCmini.this.sendChannelClips(this.channel.getIndex(), this.channel);
            } else if (p.getParent() instanceof LXClip) {
                LXClip clip = (LXClip)p.getParent();
                APCmini.this.sendClip(index, this.channel, clip.getIndex(), clip);
            }
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                if (p == c.focusedPattern) {
                    int channelSurfaceIndex;
                    int focusedPatternIndex = c.getFocusedPatternIndex();
                    if (focusedPatternIndex < (channelSurfaceIndex = c.controlSurfaceFocusIndex.getValuei())) {
                        c.controlSurfaceFocusIndex.setValue(focusedPatternIndex);
                    } else if (focusedPatternIndex >= channelSurfaceIndex + 8) {
                        c.controlSurfaceFocusIndex.setValue(focusedPatternIndex - 8 + 1);
                    }
                    APCmini.this.sendChannelPatterns(index, c);
                }
            }
        }

        @Override
        public void effectAdded(LXBus channel, LXEffect effect) {
        }

        @Override
        public void effectRemoved(LXBus channel, LXEffect effect) {
        }

        @Override
        public void effectMoved(LXBus channel, LXEffect effect) {
        }

        @Override
        public void indexChanged(LXAbstractChannel channel) {
        }

        @Override
        public void groupChanged(LXChannel channel, LXGroup group) {
        }

        @Override
        public void patternAdded(LXChannel channel, LXPattern pattern) {
            if (APCmini.this.gridMode == GridMode.PATTERNS) {
                APCmini.this.sendChannelPatterns(channel.getIndex(), channel);
            }
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            if (APCmini.this.gridMode == GridMode.PATTERNS) {
                APCmini.this.sendChannelPatterns(channel.getIndex(), channel);
            }
        }

        @Override
        public void patternMoved(LXChannel channel, LXPattern pattern) {
            if (APCmini.this.gridMode == GridMode.PATTERNS) {
                APCmini.this.sendChannelPatterns(channel.getIndex(), channel);
            }
        }

        @Override
        public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
            if (APCmini.this.gridMode == GridMode.PATTERNS) {
                APCmini.this.sendChannelPatterns(channel.getIndex(), channel);
            }
        }

        @Override
        public void patternDidChange(LXChannel channel, LXPattern pattern) {
            if (APCmini.this.gridMode == GridMode.PATTERNS) {
                APCmini.this.sendChannelPatterns(channel.getIndex(), channel);
            }
        }

        @Override
        public void clipAdded(LXBus bus, LXClip clip) {
            clip.running.addListener(this);
            APCmini.this.sendClip(this.channel.getIndex(), this.channel, clip.getIndex(), clip);
        }

        @Override
        public void clipRemoved(LXBus bus, LXClip clip) {
            clip.running.removeListener(this);
            APCmini.this.sendChannelClips(this.channel.getIndex(), this.channel);
        }
    }
}

