/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiAftertouch;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiProgramChange;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.utils.LXUtils;

public class DJMA9
extends LXMidiSurface {
    public static final String DEVICE_NAME = "DJM-A9";
    public final EnumParameter<MidiChannel> midiChannel = new EnumParameter<MidiChannel>("MIDI Channel", MidiChannel.CH1);
    public static final Channel[] ALL_CHANNELS = Channel.values();
    public static final int MASTER_FADER = 24;
    public static final int BOOTH_FADER = 25;
    public static final int BOOTH_EQ_HI = 109;
    public static final int BOOTH_EQ_LOW = 110;
    public static final int MULTIIO_SENDCH_1 = 34;
    public static final int MULTIIO_SENDCH_2 = 35;
    public static final int MULTIIO_SENDCH_3 = 36;
    public static final int MULTIIO_SENDCH_4 = 37;
    public static final int MULTIIO_SENDCH_MIC = 38;
    public static final int MULTIIO_SENDCH_CFA = 39;
    public static final int MULTIIO_SENDCH_CFB = 40;
    public static final int MULTIIO_SENDCH_MASTER = 41;
    public static final int MULTIIO_LEVEL = 113;
    public static final int XPAD_SLIDER = 116;
    public static final int BEAT_LEFT = 76;
    public static final int BEAT_RIGHT = 77;
    public static final int AUTO_TAP = 69;
    public static final int BEAT_TAP_TEMPO = 78;
    public static final int TIME_MSB = 13;
    public static final int TIME_LSB = 45;
    public static final int FX_LOW = 104;
    public static final int FX_MID = 103;
    public static final int FX_HIGH = 102;
    public static final int FX_TYPE_DELAY = 42;
    public static final int FX_TYPE_ECHO = 55;
    public static final int FX_TYPE_PINGPONG = 51;
    public static final int FX_TYPE_SPIRAL = 43;
    public static final int FX_TYPE_HELIX = 62;
    public static final int FX_TYPE_REVERB = 54;
    public static final int FX_TYPE_FLANGER = 50;
    public static final int FX_TYPE_PHASER = 57;
    public static final int FX_TYPE_FILTER = 59;
    public static final int FX_TYPE_TRIPLETFILTER = 58;
    public static final int FX_TYPE_TRANS = 53;
    public static final int FX_TYPE_ROLL = 46;
    public static final int FX_TYPE_TRIPLETROLL = 47;
    public static final int FX_TYPE_MOBIUS = 61;
    public static final int FX_LEVEL = 91;
    public static final int FX_ONOFF = 114;
    public static final int SLIDE_LEFT = 0;
    public static final int SLIDE_CENTER = 64;
    public static final int SLIDE_RIGHT = 127;
    public static final int CROSSFADER = 11;
    public static final int EQ_CURVE = 33;
    public static final int CHANNEL_FADER_CURVE = 94;
    public static final int CROSSFADER_CURVE = 95;
    public static final int CHANNEL_FADER1 = 17;
    public static final int CHANNEL_FADER2 = 18;
    public static final int CHANNEL_FADER3 = 19;
    public static final int CHANNEL_FADER4 = 20;
    public static final int CROSSFADER_ASSIGN1 = 65;
    public static final int CROSSFADER_ASSIGN2 = 66;
    public static final int CROSSFADER_ASSIGN3 = 67;
    public static final int CROSSFADER_ASSIGN4 = 68;
    public static final int TRIM1 = 1;
    public static final int TRIM2 = 6;
    public static final int TRIM3 = 12;
    public static final int TRIM4 = 80;
    public static final int HIGH1 = 2;
    public static final int HIGH2 = 7;
    public static final int HIGH3 = 14;
    public static final int HIGH4 = 81;
    public static final int MID1 = 3;
    public static final int MID2 = 8;
    public static final int MID3 = 15;
    public static final int MID4 = 92;
    public static final int LOW1 = 4;
    public static final int LOW2 = 9;
    public static final int LOW3 = 21;
    public static final int LOW4 = 82;
    public static final int COLOR1 = 5;
    public static final int COLOR2 = 10;
    public static final int COLOR3 = 22;
    public static final int COLOR4 = 83;
    public static final int COLOR_PARAMETER = 108;
    public static final int PHONES_MIX_A = 27;
    public static final int PHONES_LEVEL_A = 26;
    public static final int PHONES_MIX_B = 85;
    public static final int PHONES_LEVEL_B = 86;
    public static final int MIC_EQ_HIGH = 30;
    public static final int MIC_EQ_LOW = 31;
    public static final int MIC_FX_ECHO = 97;
    public static final int MIC_FX_PITCH = 98;
    public static final int MIC_FX_MEGAPHONE = 99;
    public static final int MIC_FX_PARAMETER = 100;
    public static final int MIC_REVERB_PARAMETER = 101;
    public static final int MULTIIO_INSERT_SOURCE = 111;
    public static final int QUANTIZE = 118;
    public static final int BEAT_FX_ASSIGN1 = 1;
    public static final int BEAT_FX_ASSIGN2 = 2;
    public static final int BEAT_FX_ASSIGN3 = 3;
    public static final int BEAT_FX_ASSIGN4 = 4;
    public static final int BEAT_FX_ASSIGN_MIC = 5;
    public static final int BEAT_FX_ASSIGN_CFA = 6;
    public static final int BEAT_FX_ASSIGN_CFB = 7;
    public static final int BEAT_FX_ASSIGN_MASTER = 8;
    public static final int COLOR_FX_SPACE = 85;
    public static final int COLOR_FX_DUBECHO = 105;
    public static final int COLOR_FX_CRUSH = 106;
    public static final int COLOR_FX_SWEEP = 107;
    public static final int COLOR_FX_NOISE = 86;
    public static final int COLOR_FX_FILTER = 87;
    public static final int CUE1_A = 10;
    public static final int CUE2_A = 11;
    public static final int CUE3_A = 12;
    public static final int CUE4_A = 13;
    public static final int CUE_MASTER_A = 14;
    public static final int CUE_LINK_A = 15;
    public static final int PHONES_MONO_SPLIT_A = 33;
    public static final int CUE1_B = 16;
    public static final int CUE2_B = 17;
    public static final int CUE3_B = 18;
    public static final int CUE4_B = 19;
    public static final int CUE_MASTER_B = 20;
    public static final int CUE_LINK_B = 21;
    public static final int PHONES_MONO_SPLIT_B = 34;
    public static final int MIC_TALKOVER = 97;
    public static final int MIC_REVERB = 96;
    public static final int MIC_ON = 98;
    public final BoundedParameter low1raw = new BoundedParameter("low1raw");
    public final BoundedParameter low2raw = new BoundedParameter("low2raw");
    public final BoundedParameter low3raw = new BoundedParameter("low3raw");
    public final BoundedParameter low4raw = new BoundedParameter("low4raw");
    public final BoundedParameter mid1raw = new BoundedParameter("mid1raw");
    public final BoundedParameter mid2raw = new BoundedParameter("mid2raw");
    public final BoundedParameter mid3raw = new BoundedParameter("mid3raw");
    public final BoundedParameter mid4raw = new BoundedParameter("mid4raw");
    public final BoundedParameter high1raw = new BoundedParameter("high1raw");
    public final BoundedParameter high2raw = new BoundedParameter("high2raw");
    public final BoundedParameter high3raw = new BoundedParameter("high3raw");
    public final BoundedParameter high4raw = new BoundedParameter("high4raw");
    public final BoundedParameter fade1 = new BoundedParameter("fade1", 1.0);
    public final BoundedParameter fade2 = new BoundedParameter("fade2", 1.0);
    public final BoundedParameter fade3 = new BoundedParameter("fade3", 1.0);
    public final BoundedParameter fade4 = new BoundedParameter("fade4", 1.0);
    public final BoundedParameter masterFader = new BoundedParameter("masterFader");
    public final BoundedParameter boothMonitor = new BoundedParameter("boothMonitor");
    public final BoundedParameter crossfader = new BoundedParameter("crossFader");
    public final BoundedParameter color1raw = new BoundedParameter("color1raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter color2raw = new BoundedParameter("color2raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter color3raw = new BoundedParameter("color3raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter color4raw = new BoundedParameter("color4raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter colorParameter = new BoundedParameter("colorParam", 0.55, 0.1, 1.0);
    public final BoundedParameter colorSensitivity = new BoundedParameter("ColorSensitivity", 2.0, 1.0, 3.0).setDescription("Color knob sensitivity. Adjust per DJ.");
    public final BoundedParameter low1 = new BoundedParameter("low1");
    public final BoundedParameter low2 = new BoundedParameter("low2");
    public final BoundedParameter low3 = new BoundedParameter("low3");
    public final BoundedParameter low4 = new BoundedParameter("low4");
    public final BoundedParameter mid1 = new BoundedParameter("mid1");
    public final BoundedParameter mid2 = new BoundedParameter("mid2");
    public final BoundedParameter mid3 = new BoundedParameter("mid3");
    public final BoundedParameter mid4 = new BoundedParameter("mid4");
    public final BoundedParameter high1 = new BoundedParameter("high1");
    public final BoundedParameter high2 = new BoundedParameter("high2");
    public final BoundedParameter high3 = new BoundedParameter("high3");
    public final BoundedParameter high4 = new BoundedParameter("high4");
    public final BoundedParameter eqRangeMax = new BoundedParameter("EQmax", 0.5).setDescription("Equalizer knob value that will act as a maximum position. Adjust per DJ. Defaults to center.");
    public final BoundedParameter low1net = new BoundedParameter("low1net");
    public final BoundedParameter low2net = new BoundedParameter("low2net");
    public final BoundedParameter low3net = new BoundedParameter("low3net");
    public final BoundedParameter low4net = new BoundedParameter("low4net");
    public final BoundedParameter mid1net = new BoundedParameter("mid1net");
    public final BoundedParameter mid2net = new BoundedParameter("mid2net");
    public final BoundedParameter mid3net = new BoundedParameter("mid3net");
    public final BoundedParameter mid4net = new BoundedParameter("mid4net");
    public final BoundedParameter high1net = new BoundedParameter("high1net");
    public final BoundedParameter high2net = new BoundedParameter("high2net");
    public final BoundedParameter high3net = new BoundedParameter("high3net");
    public final BoundedParameter high4net = new BoundedParameter("high4net");
    public final BoundedParameter color1 = new BoundedParameter("color1");
    public final BoundedParameter color2 = new BoundedParameter("color2");
    public final BoundedParameter color3 = new BoundedParameter("color3");
    public final BoundedParameter color4 = new BoundedParameter("color4");
    public final BoundedParameter level1net = new BoundedParameter("level1net", 0.0, 3.0);
    public final BoundedParameter level2net = new BoundedParameter("level2net", 0.0, 3.0);
    public final BoundedParameter level3net = new BoundedParameter("level3net", 0.0, 3.0);
    public final BoundedParameter level4net = new BoundedParameter("level4net", 0.0, 3.0);
    private BoundedParameter[] lowraw = new BoundedParameter[]{this.low1raw, this.low2raw, this.low3raw, this.low4raw};
    private BoundedParameter[] midraw = new BoundedParameter[]{this.mid1raw, this.mid2raw, this.mid3raw, this.mid4raw};
    private BoundedParameter[] highraw = new BoundedParameter[]{this.high1raw, this.high2raw, this.high3raw, this.high4raw};
    private BoundedParameter[] low = new BoundedParameter[]{this.low1, this.low2, this.low3, this.low4};
    private BoundedParameter[] mid = new BoundedParameter[]{this.mid1, this.mid2, this.mid3, this.mid4};
    private BoundedParameter[] high = new BoundedParameter[]{this.high1, this.high2, this.high3, this.high4};
    private BoundedParameter[] lowNnet = new BoundedParameter[]{this.low1net, this.low2net, this.low3net, this.low4net};
    private BoundedParameter[] midNnet = new BoundedParameter[]{this.mid1net, this.mid2net, this.mid3net, this.mid4net};
    private BoundedParameter[] highNnet = new BoundedParameter[]{this.high1net, this.high2net, this.high3net, this.high4net};
    private BoundedParameter[] fade = new BoundedParameter[]{this.fade1, this.fade2, this.fade3, this.fade4};
    private BoundedParameter[] levelNnet = new BoundedParameter[]{this.level1net, this.level2net, this.level3net, this.level4net};
    private BoundedParameter[] colorraw = new BoundedParameter[]{this.color1raw, this.color2raw, this.color3raw, this.color4raw};
    private BoundedParameter[] color = new BoundedParameter[]{this.color1, this.color2, this.color3, this.color4};
    public final EnumParameter<Channel> aChannel = new EnumParameter<Channel>("A Channel", Channel.TWO);
    public final EnumParameter<Channel> bChannel = new EnumParameter<Channel>("B Channel", Channel.THREE);
    public final BoundedParameter lowA = new BoundedParameter("lowA");
    public final BoundedParameter lowB = new BoundedParameter("lowB");
    public final BoundedParameter midA = new BoundedParameter("midA");
    public final BoundedParameter midB = new BoundedParameter("midB");
    public final BoundedParameter highA = new BoundedParameter("highA");
    public final BoundedParameter highB = new BoundedParameter("highB");
    public final BoundedParameter lowAnet = new BoundedParameter("lowA");
    public final BoundedParameter lowBnet = new BoundedParameter("lowB");
    public final BoundedParameter midAnet = new BoundedParameter("midA");
    public final BoundedParameter midBnet = new BoundedParameter("midB");
    public final BoundedParameter highAnet = new BoundedParameter("highA");
    public final BoundedParameter highBnet = new BoundedParameter("highB");
    public final BoundedParameter fadeA = new BoundedParameter("fadeA");
    public final BoundedParameter fadeB = new BoundedParameter("fadeB");
    public final BoundedParameter colorA = new BoundedParameter("colorA");
    public final BoundedParameter colorB = new BoundedParameter("colorB");
    public final BoundedParameter levelAnet = new BoundedParameter("levelAnet", 0.0, 3.0);
    public final BoundedParameter levelBnet = new BoundedParameter("levelBnet", 0.0, 3.0);
    public final BoundedParameter lowNet = new BoundedParameter("lowNet");
    public final BoundedParameter midNet = new BoundedParameter("midNet");
    public final BoundedParameter highNet = new BoundedParameter("highNet");
    public final BoundedParameter smartXF = new BoundedParameter("SmartXF").setDescription("Crossfader position calculated using relative levels of A vs B");
    public final EnumParameter<XFMode> xfMode = new EnumParameter<XFMode>("Crossfader Sync", XFMode.OFF).setDescription("Mode for following DJM-A9 crossfader with LX");
    private final LXParameterListener aChannelListener = p -> {
        this.updateAeq();
        this.updateAcolor();
        this.updateLowNet();
        this.updateMidNet();
        this.updateHighNet();
    };
    private final LXParameterListener bChannelListener = p -> {
        this.updateBeq();
        this.updateBcolor();
        this.updateLowNet();
        this.updateMidNet();
        this.updateHighNet();
    };
    private final LXParameterListener colorSensitivityListener = p -> this.recalculateAllColors();
    private final LXParameterListener eqRangeMaxListener = p -> this.recalculateAllEq();
    private final LXParameterListener smartXFListener = p -> {
        if (this.xfMode.getEnum() == XFMode.SMART) {
            this.lx.engine.mixer.crossfader.setNormalized(this.smartXF.getNormalized());
        }
    };
    private final LXParameterListener xfModeListener = p -> {
        XFMode mode = this.xfMode.getEnum();
        if (mode == XFMode.DIRECT) {
            this.lx.engine.mixer.crossfader.setNormalized(this.crossfader.getNormalized());
        } else if (mode == XFMode.SMART) {
            this.lx.engine.mixer.crossfader.setNormalized(this.smartXF.getNormalized());
        }
    };

    public DJMA9(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.addSetting("midiChannel", this.midiChannel);
        this.addSetting("xfMode", this.xfMode);
        this.addSetting("aChannel", this.aChannel);
        this.addSetting("bChannel", this.bChannel);
        this.aChannel.addListener(this.aChannelListener);
        this.bChannel.addListener(this.bChannelListener);
        this.colorSensitivity.addListener(this.colorSensitivityListener);
        this.eqRangeMax.addListener(this.eqRangeMaxListener);
        this.smartXF.addListener(this.smartXFListener);
        this.xfMode.addListener(this.xfModeListener);
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.initialize();
        }
    }

    private void initialize() {
        this.colorParameter.setNormalized(0.5);
        for (Channel channel : ALL_CHANNELS) {
            this.updateLow(channel, 0.5);
            this.updateMid(channel, 0.5);
            this.updateHigh(channel, 0.5);
            this.updateFade(channel, 1.0);
            this.updateColor(channel, 0.5);
        }
    }

    protected void recalculateAllEq() {
        for (Channel channel : ALL_CHANNELS) {
            int c = channel.getIndex();
            this.low[c].setValue(this.scaleEq(this.lowraw[c].getValue()));
            this.mid[c].setValue(this.scaleEq(this.midraw[c].getValue()));
            this.high[c].setValue(this.scaleEq(this.highraw[c].getValue()));
            this.lowNnet[c].setValue(this.low[c].getValue() * this.fade[c].getValue());
            this.midNnet[c].setValue(this.mid[c].getValue() * this.fade[c].getValue());
            this.highNnet[c].setValue(this.high[c].getValue() * this.fade[c].getValue());
            this.updateLevelNet(channel);
        }
        this.updateAeq();
        this.updateBeq();
        this.updateLowNet();
        this.updateMidNet();
        this.updateHighNet();
    }

    protected double scaleEq(double value) {
        return LXUtils.constrain(value / this.eqRangeMax.getValue(), 0.0, 1.0);
    }

    protected void updateLow(Channel channel, double value) {
        int c = channel.getIndex();
        this.lowraw[c].setValue(value);
        this.low[c].setValue(this.scaleEq(value));
        this.lowNnet[c].setValue(this.low[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateLowNet();
    }

    protected void updateMid(Channel channel, double value) {
        int c = channel.getIndex();
        this.midraw[c].setValue(value);
        this.mid[c].setValue(this.scaleEq(value));
        this.midNnet[c].setValue(this.mid[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateMidNet();
    }

    protected void updateHigh(Channel channel, double value) {
        int c = channel.getIndex();
        this.highraw[c].setValue(value);
        this.high[c].setValue(this.scaleEq(value));
        this.highNnet[c].setValue(this.high[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateHighNet();
    }

    protected void updateFade(Channel channel, double value) {
        int c = channel.getIndex();
        this.fade[c].setValue(value);
        this.lowNnet[c].setValue(this.low[c].getValue() * value);
        this.midNnet[c].setValue(this.mid[c].getValue() * value);
        this.highNnet[c].setValue(this.high[c].getValue() * value);
        this.updateLevelNet(channel);
        this.updateABeq(channel);
    }

    protected void updateLevelNet(Channel channel) {
        int c = channel.getIndex();
        this.levelNnet[c].setValue(this.fade[c].getValue() * (this.low[c].getValue() + this.mid[c].getValue() + this.high[c].getValue()));
    }

    protected void updateLowNet() {
        this.lowNet.setValue(Math.max(this.lowAnet.getValue(), this.lowBnet.getValue()));
    }

    protected void updateMidNet() {
        this.midNet.setValue(Math.max(this.midAnet.getValue(), this.midBnet.getValue()));
    }

    protected void updateHighNet() {
        this.highNet.setValue(Math.max(this.highAnet.getValue(), this.highBnet.getValue()));
    }

    protected void updateABeq(Channel channel) {
        if (this.aChannel.getEnum().equals((Object)channel)) {
            this.updateAeq(channel);
        }
        if (this.bChannel.getEnum().equals((Object)channel)) {
            this.updateBeq(channel);
        }
    }

    protected void updateAeq() {
        this.updateAeq(this.aChannel.getEnum());
    }

    protected void updateBeq() {
        this.updateBeq(this.bChannel.getEnum());
    }

    protected void updateAeq(Channel channel) {
        int c = channel.getIndex();
        this.lowA.setValue(this.low[c].getValue());
        this.midA.setValue(this.mid[c].getValue());
        this.highA.setValue(this.high[c].getValue());
        this.fadeA.setValue(this.fade[c].getValue());
        this.lowAnet.setValue(this.lowNnet[c].getValue());
        this.midAnet.setValue(this.midNnet[c].getValue());
        this.highAnet.setValue(this.highNnet[c].getValue());
        this.levelAnet.setValue(this.levelNnet[c].getValue());
        this.updateSmartXF();
    }

    protected void updateBeq(Channel channel) {
        int c = channel.getIndex();
        this.lowB.setValue(this.low[c].getValue());
        this.midB.setValue(this.mid[c].getValue());
        this.highB.setValue(this.high[c].getValue());
        this.fadeB.setValue(this.fade[c].getValue());
        this.lowBnet.setValue(this.lowNnet[c].getValue());
        this.midBnet.setValue(this.midNnet[c].getValue());
        this.highBnet.setValue(this.highNnet[c].getValue());
        this.levelBnet.setValue(this.levelNnet[c].getValue());
        this.updateSmartXF();
    }

    protected void updateSmartXF() {
        double levA = this.levelAnet.getNormalized();
        double levB = this.levelBnet.getNormalized();
        if (levA != 0.0 || levB != 0.0) {
            this.smartXF.setValue(levA > levB ? levB / (levA + levB) : 1.0 - levA / (levA + levB));
        }
    }

    protected void recalculateAllColors() {
        for (Channel channel : ALL_CHANNELS) {
            int c = channel.getIndex();
            double value = this.colorraw[c].getValue();
            this.color[c].setValue((value < 0.5 ? (0.5 - value) * 2.0 : (value - 0.5) * 2.0) * this.colorParameter.getValue() * this.colorSensitivity.getValue());
        }
        this.updateAcolor();
        this.updateBcolor();
    }

    protected void updateColor(Channel channel, double value) {
        int c = channel.getIndex();
        this.colorraw[c].setValue(value);
        this.color[c].setValue((value < 0.5 ? (0.5 - value) * 2.0 : (value - 0.5) * 2.0) * this.colorParameter.getValue() * this.colorSensitivity.getValue());
        this.updateABcolor(channel);
    }

    protected void updateABcolor(Channel channel) {
        if (this.aChannel.getEnum().equals((Object)channel)) {
            this.updateAcolor(channel);
        }
        if (this.bChannel.getEnum().equals((Object)channel)) {
            this.updateBcolor(channel);
        }
    }

    protected void updateAcolor() {
        this.updateAcolor(this.aChannel.getEnum());
    }

    protected void updateBcolor() {
        this.updateBcolor(this.bChannel.getEnum());
    }

    protected void updateAcolor(Channel channel) {
        this.colorA.setValue(this.color[channel.getIndex()].getValue());
    }

    protected void updateBcolor(Channel channel) {
        this.colorB.setValue(this.color[channel.getIndex()].getValue());
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        MidiChannel midiChannel = this.midiChannel.getEnum();
        if (cc.getChannel() == midiChannel.index || midiChannel == MidiChannel.ANY) {
            int number = cc.getCC();
            switch (number) {
                case 4: {
                    this.updateLow(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 9: {
                    this.updateLow(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 21: {
                    this.updateLow(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 82: {
                    this.updateLow(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 3: {
                    this.updateMid(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 8: {
                    this.updateMid(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 15: {
                    this.updateMid(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 92: {
                    this.updateMid(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 2: {
                    this.updateHigh(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 7: {
                    this.updateHigh(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 14: {
                    this.updateHigh(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 81: {
                    this.updateHigh(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 17: {
                    this.updateFade(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 18: {
                    this.updateFade(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 19: {
                    this.updateFade(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 20: {
                    this.updateFade(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 24: {
                    this.masterFader.setNormalized(cc.getNormalized());
                    return;
                }
                case 25: {
                    this.boothMonitor.setNormalized(cc.getNormalized());
                    return;
                }
                case 11: {
                    this.crossfader.setNormalized(cc.getNormalized());
                    if (this.xfMode.getEnum() == XFMode.DIRECT) {
                        this.lx.engine.mixer.crossfader.setNormalized(cc.getNormalized());
                    }
                    return;
                }
                case 5: {
                    this.updateColor(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 10: {
                    this.updateColor(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 22: {
                    this.updateColor(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 83: {
                    this.updateColor(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 108: {
                    this.colorParameter.setNormalized(cc.getNormalized());
                    this.recalculateAllColors();
                    return;
                }
            }
        }
    }

    private void noteReceived(MidiNote note, boolean on) {
        MidiChannel midiChannel = this.midiChannel.getEnum();
        if (note.getChannel() == midiChannel.index || midiChannel == MidiChannel.ANY) {
            int pitch = note.getPitch();
            switch (pitch) {
                case 118: {
                    return;
                }
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void programChangeReceived(MidiProgramChange pc) {
    }

    @Override
    public void pitchBendReceived(MidiPitchBend pitchBend) {
    }

    @Override
    public void aftertouchReceived(MidiAftertouch aftertouch) {
    }

    @Override
    public void dispose() {
        this.aChannel.removeListener(this.aChannelListener);
        this.bChannel.removeListener(this.bChannelListener);
        this.colorSensitivity.removeListener(this.colorSensitivityListener);
        this.eqRangeMax.removeListener(this.eqRangeMaxListener);
        this.smartXF.removeListener(this.smartXFListener);
        this.xfMode.removeListener(this.xfModeListener);
        super.dispose();
    }

    public static enum MidiChannel {
        CH1(0),
        CH2(1),
        CH3(2),
        CH4(3),
        CH5(4),
        CH6(5),
        CH7(6),
        CH8(7),
        CH9(8),
        CH10(9),
        CH11(10),
        CH12(11),
        CH13(12),
        CH14(13),
        CH15(14),
        CH16(15),
        ANY(99);

        private final int index;
        private final String label;

        private MidiChannel(int index) {
            this.index = index;
            this.label = index == 99 ? "Any" : Integer.toString(this.index + 1);
        }

        public String toString() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum Channel {
        ONE(0),
        TWO(1),
        THREE(2),
        FOUR(3);

        private final int index;
        private final String label;

        private Channel(int index) {
            this.index = index;
            this.label = Integer.toString(this.index + 1);
        }

        public String toString() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum XFMode {
        OFF("Off"),
        DIRECT("Direct"),
        SMART("Smart");

        private final String label;

        private XFMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

