/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiAftertouch;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiProgramChange;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import java.util.Collections;
import java.util.Map;

public abstract class LXMidiSurface
implements LXMidiListener,
LXSerializable,
LXParameterListener {
    protected final LX lx;
    public final LXMidiInput input;
    public final LXMidiOutput output;
    public final BooleanParameter enabled = new BooleanParameter("Enabled").setMappable(false).setDescription("Whether the control surface is enabled");
    protected final LXParameter.Collection mutableSettings = new LXParameter.Collection();
    public final Map<String, LXParameter> settings = Collections.unmodifiableMap(this.mutableSettings);
    protected final LXParameter.Collection mutableState = new LXParameter.Collection();
    public final Map<String, LXParameter> state = Collections.unmodifiableMap(this.mutableState);
    private boolean _enabled = false;
    public static final String KEY_NAME = "name";
    public static final String KEY_SETTINGS = "settings";
    public static final String KEY_STATE = "state";

    protected LXMidiSurface(LX lx, LXMidiInput input, LXMidiOutput output) {
        this.lx = lx;
        this.input = input;
        this.output = output;
        if (this instanceof Bidirectional && output == null) {
            throw new IllegalArgumentException("Surface " + this.getClass().getSimpleName() + " requires MIDI output");
        }
        this.enabled.addListener(p -> {
            boolean on = this.enabled.isOn();
            if (on) {
                this.input.open();
                if (this.output != null) {
                    this.output.open();
                }
                this.input.addListener(this);
                this._enabled = on;
                this.onEnable(on);
            } else {
                this.onEnable(on);
                this._enabled = on;
                this.input.removeListener(this);
            }
        });
        this.output.connected.addListener(p -> {
            if (this.output.connected.isOn()) {
                this.input.open();
                this.output.open();
                this.onReconnect();
            }
        });
    }

    @Override
    public void onParameterChanged(LXParameter p) {
    }

    protected void addSetting(String key, LXListenableParameter setting) {
        if (this.mutableSettings.containsKey(key)) {
            throw new IllegalStateException("Cannot add setting twice:" + key);
        }
        this.mutableSettings.put(key, setting);
        setting.addListener(this);
    }

    protected void addState(String key, LXListenableParameter state) {
        if (this.mutableState.containsKey(key)) {
            throw new IllegalStateException("Cannot add saved state twice:" + key);
        }
        this.mutableState.put(key, state);
        state.addListener(this);
    }

    public String getName() {
        return this.input.getName();
    }

    public LXMidiInput getInput() {
        return this.input;
    }

    public LXMidiOutput getOutput() {
        return this.output;
    }

    protected void onEnable(boolean isOn) {
    }

    protected void onReconnect() {
    }

    protected void sendNoteOn(int channel, int note, int velocity) {
        if (this._enabled) {
            this.output.sendNoteOn(channel, note, velocity);
        }
    }

    protected void sendControlChange(int channel, int cc, int value) {
        if (this._enabled) {
            this.output.sendControlChange(channel, cc, value);
        }
    }

    public int getRemoteControlStart() {
        return 0;
    }

    public int getRemoteControlLength() {
        return 0;
    }

    public boolean isRemoteControlAux() {
        return false;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        JsonElement stateElem;
        JsonElement settingsElem;
        if (obj.has(KEY_SETTINGS) && (settingsElem = obj.get(KEY_SETTINGS)).isJsonObject()) {
            LXSerializable.Utils.loadParameters(settingsElem.getAsJsonObject(), this.mutableSettings);
        }
        if (obj.has(KEY_STATE) && (stateElem = obj.get(KEY_STATE)).isJsonObject()) {
            LXSerializable.Utils.loadParameters(stateElem.getAsJsonObject(), this.mutableState);
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        obj.addProperty(KEY_NAME, this.input.getName());
        if (!this.settings.isEmpty()) {
            obj.add(KEY_SETTINGS, (JsonElement)LXSerializable.Utils.saveParameters(this.mutableSettings));
        }
        if (!this.state.isEmpty()) {
            obj.add(KEY_STATE, (JsonElement)LXSerializable.Utils.saveParameters(this.mutableState));
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
    }

    @Override
    public void noteOffReceived(MidiNote note) {
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
    }

    @Override
    public void programChangeReceived(MidiProgramChange pc) {
    }

    @Override
    public void pitchBendReceived(MidiPitchBend pitchBend) {
    }

    @Override
    public void aftertouchReceived(MidiAftertouch aftertouch) {
    }

    public void dispose() {
        for (LXParameter setting : this.settings.values()) {
            ((LXListenableParameter)setting).removeListener(this);
            setting.dispose();
        }
        for (LXParameter state : this.state.values()) {
            ((LXListenableParameter)state).removeListener(this);
            state.dispose();
        }
        this.mutableSettings.clear();
    }

    public static interface Bidirectional {
    }
}

