/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.command.LXCommand;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class MidiFighterTwister
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final String DEVICE_NAME = "Midi Fighter Twister";
    public static final int CHANNEL_ROTARY_ENCODER = 0;
    public static final int CHANNEL_SWITCH_AND_COLOR = 1;
    public static final int CHANNEL_ANIMATIONS_AND_BRIGHTNESS = 2;
    public static final int CHANNEL_SYSTEM = 3;
    public static final int CHANNEL_SHIFT = 4;
    public static final int CHANNEL_SWITCH_ANIMATION = 5;
    public static final int CHANNEL_SEQUENCER = 7;
    public static final int DEVICE_KNOB = 0;
    public static final int DEVICE_KNOB_PER_BANK = 16;
    public static final int DEVICE_KNOB_NUM = 64;
    public static final int DEVICE_KNOB_MAX = 64;
    public static final int KNOB_DECREMENT_VERYFAST = 61;
    public static final int KNOB_DECREMENT_FAST = 62;
    public static final int KNOB_DECREMENT = 63;
    public static final int KNOB_INCREMENT = 65;
    public static final int KNOB_INCREMENT_FAST = 66;
    public static final int KNOB_INCREMENT_VERYFAST = 67;
    public static final int KNOB_TICKS_PER_DISCRETE_INCREMENT = 8;
    public static final int BANK1 = 0;
    public static final int BANK2 = 1;
    public static final int BANK3 = 2;
    public static final int BANK4 = 3;
    public static final int BANK1_LEFT1 = 8;
    public static final int BANK1_LEFT2 = 9;
    public static final int BANK1_LEFT3 = 10;
    public static final int BANK1_RIGHT1 = 11;
    public static final int BANK1_RIGHT2 = 12;
    public static final int BANK1_RIGHT3 = 13;
    public static final int BANK2_LEFT1 = 14;
    public static final int BANK2_LEFT2 = 15;
    public static final int BANK2_LEFT3 = 16;
    public static final int BANK2_RIGHT1 = 17;
    public static final int BANK2_RIGHT2 = 18;
    public static final int BANK2_RIGHT3 = 19;
    public static final int BANK3_LEFT1 = 20;
    public static final int BANK3_LEFT2 = 21;
    public static final int BANK3_LEFT3 = 22;
    public static final int BANK3_RIGHT1 = 23;
    public static final int BANK3_RIGHT2 = 24;
    public static final int BANK3_RIGHT3 = 25;
    public static final int BANK4_LEFT1 = 26;
    public static final int BANK4_LEFT2 = 27;
    public static final int BANK4_LEFT3 = 28;
    public static final int BANK4_RIGHT1 = 29;
    public static final int BANK4_RIGHT2 = 30;
    public static final int BANK4_RIGHT3 = 31;
    public static final int RGB_INACTIVE_COLOR = 0;
    public static final int RGB_ACTIVE_COLOR = 127;
    public static final int RGB_BLUE = 1;
    public static final int RGB_GREEN = 50;
    public static final int RGB_RED = 80;
    public static final int RGB_PRIMARY = 1;
    public static final int RGB_AUX = 80;
    public static final int RGB_ANIMATION_NONE = 0;
    public static final int RGB_TOGGLE_EVERY_8_BEATS = 1;
    public static final int RGB_TOGGLE_EVERY_4_BEATS = 2;
    public static final int RGB_TOGGLE_EVERY_2_BEATS = 3;
    public static final int RGB_TOGGLE_EVERY_BEAT = 4;
    public static final int RGB_TOGGLE_EVERY_HALF_BEAT = 5;
    public static final int RGB_TOGGLE_EVERY_QUARTER_BEAT = 6;
    public static final int RGB_TOGGLE_EVERY_EIGTH_BEAT = 7;
    public static final int RGB_TOGGLE_EVERY_SIXTEENTH_BEAT = 8;
    public static final int RGB_PULSE_EVERY_8_BEATS = 10;
    public static final int RGB_PULSE_EVERY_4_BEATS = 11;
    public static final int RGB_PULSE_EVERY_2_BEATS = 12;
    public static final int RGB_PULSE_EVERY_BEAT = 13;
    public static final int RGB_PULSE_EVERY_HALF_BEAT = 14;
    public static final int RGB_PULSE_EVERY_QUARTER_BEAT = 15;
    public static final int RGB_PULSE_EVERY_EIGTH_BEAT = 16;
    public static final int RGB_BRIGHTNESS_OFF = 17;
    public static final int RGB_BRIGHTNESS_MID = 32;
    public static final int RGB_BRIGHTNESS_MAX = 47;
    public static final int INDICATOR_ANIMATION_NONE = 48;
    public static final int INDICATOR_TOGGLE_EVERY_8_BEATS = 49;
    public static final int INDICATOR_TOGGLE_EVERY_4_BEATS = 50;
    public static final int INDICATOR_TOGGLE_EVERY_2_BEATS = 51;
    public static final int INDICATOR_TOGGLE_EVERY_BEAT = 52;
    public static final int INDICATOR_TOGGLE_EVERY_HALF_BEAT = 53;
    public static final int INDICATOR_TOGGLE_EVERY_QUARTER_BEAT = 54;
    public static final int INDICATOR_TOGGLE_EVERY_EIGTH_BEAT = 55;
    public static final int INDICATOR_TOGGLE_EVERY_SIXTEENTH_BEAT = 56;
    public static final int INDICATOR_PULSE_EVERY_8_BEATS = 57;
    public static final int INDICATOR_PULSE_EVERY_4_BEATS = 58;
    public static final int INDICATOR_PULSE_EVERY_2_BEATS = 59;
    public static final int INDICATOR_PULSE_EVERY_BEAT = 60;
    public static final int INDICATOR_PULSE_EVERY_HALF_BEAT = 61;
    public static final int INDICATOR_PULSE_EVERY_QUARTER_BEAT = 62;
    public static final int INDICATOR_PULSE_EVERY_EIGTH_BEAT = 63;
    public static final int INDICATOR_PULSE_EVERY_SIXTEENTH_BEAT = 64;
    public static final int INDICATOR_BRIGHTNESS_OFF = 65;
    public static final int INDICATOR_BRIGHTNESS_25 = 72;
    public static final int INDICATOR_BRIGHTNESS_MID = 80;
    public static final int INDICATOR_BRIGHTNESS_MAX = 95;
    public static final int RAINBOW_CYCLE = 127;
    public static final int BANK_OFF = 0;
    public static final int BANK_ON = 127;
    public final EnumParameter<KnobClickMode> knobClickMode = new EnumParameter<KnobClickMode>("Knob Click", KnobClickMode.RESET).setDescription("How to edit parameters when a knob is pressed");
    public final EnumParameter<FocusMode> focusMode = new EnumParameter<FocusMode>("Focus Buttons", FocusMode.DEVICE).setDescription("How to change focus on bottom side button press");
    public final DiscreteParameter currentBank = new DiscreteParameter("Bank", 0, 0, 4).setDescription("Which bank is selected on the MFT");
    public final BooleanParameter isAux = new BooleanParameter("Aux", false).setDescription("Whether this MFT controls the primary or aux channel");
    public static final byte MIDI_MFR_ID_0 = 0;
    public static final byte MIDI_MFR_ID_1 = 1;
    public static final byte MIDI_MFR_ID_2 = 121;
    public static final byte SYSEX_COMMAND_PUSH_CONF = 1;
    public static final byte SYSEX_COMMAND_PULL_CONF = 2;
    public static final byte SYSEX_COMMAND_SYSTEM = 3;
    public static final byte SYSEX_COMMAND_BULK_XFER = 4;
    public static final int CFG_COUNT_ENC = 15;
    public static final int CFG_COUNT_GLOBAL = 12;
    public static final byte CFG_FALSE = 0;
    public static final byte CFG_TRUE = 1;
    public static final byte CFG_GLOBAL_SSACTION_CCHOLD = 0;
    public static final byte CFG_GLOBAL_SSACTION_CCTOGGLE = 1;
    public static final byte CFG_GLOBAL_SSACTION_NOTEHOLD = 2;
    public static final byte CFG_GLOBAL_SSACTION_NOTETOGGLE = 3;
    public static final byte CFG_GLOBAL_SSACTION_SHIFTPAGE1 = 4;
    public static final byte CFG_GLOBAL_SSACTION_SHIFTPAGE2 = 5;
    public static final byte CFG_GLOBAL_SSACTION_BANKUP = 6;
    public static final byte CFG_GLOBAL_SSACTION_BANKDOWN = 7;
    public static final byte CFG_GLOBAL_SSACTION_BANK1 = 8;
    public static final byte CFG_GLOBAL_SSACTION_BANK2 = 9;
    public static final byte CFG_GLOBAL_SSACTION_BANK3 = 10;
    public static final byte CFG_GLOBAL_SSACTION_BANK4 = 11;
    public static final byte CFG_GLOBAL_SSACTION_CYCLE_BANK = 12;
    public static final byte CFG_ENC_CONTROLTYPE_ENCODER = 0;
    public static final byte CFG_ENC_CONTROLTYPE_SWITCH = 1;
    public static final byte CFG_ENC_CONTROLTYPE_SHIFT = 2;
    public static final byte CFG_ENC_MOVEMENTTYPE_DIRECT_HIGHRESOLUTION = 0;
    public static final byte CFG_ENC_MOVEMENTTYPE_EMULATION_RESPONSIVE = 1;
    public static final byte CFG_ENC_MOVEMENTTYPE_VELOCITYSENSITIVE = 2;
    public static final byte CFG_ENC_SWACTION_CCHOLD = 0;
    public static final byte CFG_ENC_SWACTION_CCTOGGLE = 1;
    public static final byte CFG_ENC_SWACTION_NOTEHOLD = 2;
    public static final byte CFG_ENC_SWACTION_NOTETOGGLE = 3;
    public static final byte CFG_ENC_SWACTION_ENCRESETVALUE = 4;
    public static final byte CFG_ENC_SWACTION_ENCFINEADJUST = 5;
    public static final byte CFG_ENC_SWACTION_SHIFTHOLD = 6;
    public static final byte CFG_ENC_SWACTION_SHIFTTOGGLE = 7;
    public static final byte CFG_ENC_MIDITYPE_SENDNOTE = 0;
    public static final byte CFG_ENC_MIDITYPE_SENDCC = 1;
    public static final byte CFG_ENC_MIDITYPE_SENDRELENC = 2;
    public static final byte CFG_ENC_MIDITYPE_SENDNOTEOFF = 3;
    public static final byte CFG_ENC_MIDITYPE_SENDSWITCHVELCONTROL = 3;
    public static final byte CFG_ENC_MIDITYPE_SENDRELENCMOUSEEMUDRAG = 4;
    public static final byte CFG_ENC_MIDITYPE_SENDRELENCMOUSEEMUSCROLL = 5;
    public static final byte CFG_ENC_INDICATORTYPE_DOT = 0;
    public static final byte CFG_ENC_INDICATORTYPE_BAR = 1;
    public static final byte CFG_ENC_INDICATORTYPE_BLENDEDBAR = 2;
    public static final byte CFG_ENC_INDICATORTYPE_BLENDEDDOT = 3;
    private final Config userConfig = new Config();
    private final Config lxConfig = new Config();
    private final DeviceListener deviceListener;
    private boolean inUpdateBank = false;

    public MidiFighterTwister(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.deviceListener = new DeviceListener(lx);
        this.addSetting("knobClickMode", this.knobClickMode);
        this.addSetting("focusMode", this.focusMode);
        this.addSetting("isAux", this.isAux);
        this.addSetting("currentBank", this.currentBank);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (this.isAux == p) {
            this.deviceListener.focusedDevice.setAux(this.isAux.isOn());
            this.deviceListener.resend();
        } else if (this.currentBank == p) {
            this.updateBank(this.currentBank.getValuei(), false);
        }
    }

    private void updateBank(int bank, boolean fromHardware) {
        if (this.inUpdateBank) {
            return;
        }
        this.inUpdateBank = true;
        if (fromHardware) {
            this.lx.command.perform(new LXCommand.Parameter.SetValue(this.currentBank, bank));
        } else {
            this.sendControlChange(3, bank, 127);
        }
        this.inUpdateBank = false;
        this.deviceListener.focusedDevice.updateRemoteControlFocus();
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.initialize();
            this.deviceListener.register();
        } else if (this.deviceListener.isRegistered) {
            this.deviceListener.unregister();
        }
    }

    @Override
    protected void onReconnect() {
        if (this.enabled.isOn()) {
            this.deviceListener.resend();
        }
    }

    private void initialize() {
        this.initializeConfig();
        this.sendControlChange(3, this.currentBank.getValuei(), 127);
        for (int i = 0; i < 64; ++i) {
            this.sendControlChange(2, 0 + i, 0);
            this.sendControlChange(2, 0 + i, 48);
            this.sendControlChange(2, 0 + i, 95);
            this.sendControlChange(0, 0 + i, 0);
            this.sendControlChange(2, 0 + i, 17);
        }
    }

    private void initializeConfig() {
        this.userConfig.pull();
        this.lxConfig.initializeLXDefaults();
        this.lxConfig.sendAll();
    }

    private void restoreConfig() {
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int channel = cc.getChannel();
        int number = cc.getCC();
        int value = cc.getValue();
        switch (channel) {
            case 0: {
                if (number >= 0 && number <= 64) {
                    int iKnob = number - 0;
                    if (value == 65 || value == 66 || value == 67) {
                        this.deviceListener.onKnobIncrement(iKnob, true);
                    } else if (value == 63 || value == 62 || value == 61) {
                        this.deviceListener.onKnobIncrement(iKnob, false);
                    } else {
                        LXMidiEngine.error("Received value " + value + " on MFT encoder " + number + ". Confirm Encoder MIDI Type is ENC 3FH/41H and controller is clean.");
                        if (value > 67) {
                            this.deviceListener.onKnobIncrement(iKnob, true);
                        } else if (value < 61) {
                            this.deviceListener.onKnobIncrement(iKnob, false);
                        }
                    }
                    return;
                }
                LXMidiEngine.error("MFT Unknown Knob: " + number);
                break;
            }
            case 1: {
                if (number >= 0 && number <= 64) {
                    this.deviceListener.onSwitch(number - 0, cc.getNormalized() > 0.0);
                    return;
                }
                LXMidiEngine.error("MFT Unknown Switch: " + number);
                break;
            }
            case 3: {
                switch (number) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (value == 127) {
                            this.updateBank(number, true);
                        }
                        return;
                    }
                    case 8: 
                    case 14: 
                    case 20: 
                    case 26: {
                        this.lx.command.perform(new LXCommand.Parameter.Increment(this.focusMode));
                        return;
                    }
                    case 11: 
                    case 17: 
                    case 23: 
                    case 29: {
                        this.lx.command.perform(new LXCommand.Parameter.Toggle(this.isAux));
                        return;
                    }
                    case 9: 
                    case 15: 
                    case 21: 
                    case 27: {
                        return;
                    }
                    case 12: 
                    case 18: 
                    case 24: 
                    case 30: {
                        return;
                    }
                    case 10: 
                    case 16: 
                    case 22: 
                    case 28: {
                        if (this.focusMode.getEnum() == FocusMode.CHANNEL) {
                            this.deviceListener.focusedDevice.previousChannel();
                            if (!this.isAux()) {
                                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                            }
                        } else {
                            this.deviceListener.focusedDevice.previousDevice();
                        }
                        return;
                    }
                    case 13: 
                    case 19: 
                    case 25: 
                    case 31: {
                        if (this.focusMode.getEnum() == FocusMode.CHANNEL) {
                            this.deviceListener.focusedDevice.nextChannel();
                            if (!this.isAux()) {
                                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                            }
                        } else {
                            this.deviceListener.focusedDevice.nextDevice();
                        }
                        return;
                    }
                }
                LXMidiEngine.error("Unrecognized midi number " + number + " on system channel from MFT. Check your configuration with Midifighter Utility.");
                return;
            }
            default: {
                LXMidiEngine.error("Unrecognized midi channel " + channel + " from MFT. Check your configuration with Midifighter Utility.");
            }
        }
    }

    private void noteReceived(MidiNote note, boolean on) {
        LXMidiEngine.error("MFT UNMAPPED Note: " + note + " " + on);
    }

    private boolean isAux() {
        return this.isAux.isOn();
    }

    @Override
    public int getRemoteControlStart() {
        return this.currentBank.getValuei() * 16;
    }

    @Override
    public int getRemoteControlLength() {
        return 16;
    }

    @Override
    public boolean isRemoteControlAux() {
        return this.isAux();
    }

    @Override
    public void dispose() {
        this.deviceListener.dispose();
        super.dispose();
    }

    private class Config {
        private static final int PART_SIZE_BYTES = 24;
        private boolean versionOK = true;
        private boolean initialized = false;
        private final Map<Byte, Byte> global = new LinkedHashMap<Byte, Byte>();
        private final Encoder[] encoders = new Encoder[64];

        private Config() {
            for (int i = 0; i < 64; ++i) {
                this.encoders[i] = new Encoder(i);
            }
        }

        private void pull() {
            LXMidiEngine.error("Warning: MFT sysex pull not implemented");
        }

        private void sendAll() {
            this.sendEncoders(true);
            this.sendGlobal();
        }

        private void sendModified() {
            if (this.sendEncoders(false)) {
                this.sendGlobal();
            }
        }

        private boolean sendEncoders(boolean forceAll) {
            if (!this.initialized) {
                LXMidiEngine.error("Cannot push empty config to MFT device");
                return false;
            }
            boolean modified = false;
            for (int i = 0; i < this.encoders.length; ++i) {
                if (!this.encoders[i].isModified && !forceAll) continue;
                this.encoders[i].send(forceAll);
                modified = true;
            }
            return modified;
        }

        private void sendGlobal() {
            if (!this.initialized) {
                LXMidiEngine.error("Cannot push empty config to MFT device");
                return;
            }
            byte[] sysex = new byte[this.global.size() * 2 + 6];
            sysex[0] = -16;
            sysex[1] = 0;
            sysex[2] = 1;
            sysex[3] = 121;
            sysex[4] = 1;
            int iSys = 5;
            for (Map.Entry<Byte, Byte> g : this.global.entrySet()) {
                sysex[iSys++] = g.getKey();
                sysex[iSys++] = g.getValue();
            }
            sysex[iSys] = -9;
            MidiFighterTwister.this.output.sendSysex(sysex);
        }

        private void initializeLXDefaults() {
            this.global.clear();
            this.global.put((byte)0, (byte)4);
            this.global.put((byte)1, (byte)1);
            this.global.put((byte)2, (byte)1);
            this.global.put((byte)3, (byte)7);
            this.global.put((byte)4, (byte)1);
            this.global.put((byte)5, (byte)1);
            this.global.put((byte)6, (byte)6);
            this.global.put((byte)7, (byte)1);
            this.global.put((byte)8, (byte)63);
            this.global.put((byte)9, (byte)127);
            this.global.put((byte)10, (byte)0);
            this.global.put((byte)11, (byte)0);
            this.global.put((byte)12, (byte)0);
            this.global.put((byte)13, (byte)2);
            this.global.put((byte)14, (byte)0);
            this.global.put((byte)15, (byte)0);
            this.global.put((byte)16, (byte)1);
            this.global.put((byte)17, (byte)0);
            this.global.put((byte)18, (byte)2);
            this.global.put((byte)19, (byte)51);
            this.global.put((byte)20, (byte)1);
            this.global.put((byte)21, (byte)63);
            this.global.put((byte)22, (byte)2);
            this.global.put((byte)23, (byte)0);
            this.global.put((byte)24, (byte)0);
            this.global.put((byte)31, (byte)127);
            this.global.put((byte)32, (byte)127);
            for (int i = 0; i < this.encoders.length; ++i) {
                Encoder enc = this.encoders[i];
                enc.setDetent(false);
                enc.set("movement", (byte)0);
                enc.set("switch_action_type", (byte)0);
                enc.set("switch_midi_channel", (byte)2);
                enc.set("switch_midi_number", (byte)enc.encoderIndex);
                enc.set("switch_midi_type", (byte)0);
                enc.set("encoder_midi_channel", (byte)1);
                enc.set("encoder_midi_number", (byte)enc.encoderIndex);
                enc.set("encoder_midi_type", (byte)2);
                enc.set("active_color", (byte)51);
                enc.set("inactive_color", (byte)1);
                enc.set("detent_color", (byte)63);
                enc.set("indicator_display_type", (byte)2);
                enc.set("is_super_knob", (byte)0);
                enc.set("encoder_shift_midi_channel", (byte)0);
            }
            this.initialized = true;
        }

        private String bytesToString(byte[] bytes) {
            String s = new String();
            for (int i = 0; i < bytes.length; ++i) {
                s = s.concat(String.format("%02X ", bytes[i]));
            }
            return s;
        }

        private class Encoder {
            private final int encoderIndex;
            private final byte sysexTag;
            private boolean isModified = false;
            private final Map<String, Setting> settings = new LinkedHashMap<String, Setting>();
            private final Setting has_detent;

            private Setting addSetting(String name, int address) {
                Setting setting = new Setting((byte)address);
                this.settings.put(name, setting);
                return setting;
            }

            private Encoder(int encoderIndex) {
                this.encoderIndex = encoderIndex;
                this.sysexTag = (byte)(encoderIndex + 1);
                this.has_detent = this.addSetting("has_detent", 10);
                this.addSetting("movement", 11);
                this.addSetting("switch_action_type", 12);
                this.addSetting("switch_midi_channel", 13);
                this.addSetting("switch_midi_number", 14);
                this.addSetting("switch_midi_type", 15);
                this.addSetting("encoder_midi_channel", 16);
                this.addSetting("encoder_midi_number", 17);
                this.addSetting("encoder_midi_type", 18);
                this.addSetting("active_color", 19);
                this.addSetting("inactive_color", 20);
                this.addSetting("detent_color", 21);
                this.addSetting("indicator_display_type", 22);
                this.addSetting("is_super_knob", 23);
                this.addSetting("encoder_shift_midi_channel", 24);
            }

            private void setDetent(boolean value) {
                this.set("has_detent", value ? (byte)1 : 0);
            }

            private void set(String setting, byte value) {
                this.isModified = this.settings.get(setting).setValue(value) || this.isModified;
            }

            private void send(boolean forceAll) {
                if (!this.isModified && !forceAll) {
                    return;
                }
                ArrayList<Byte> configData = new ArrayList<Byte>();
                for (Setting setting : this.settings.values()) {
                    if (!setting.isModified && !forceAll) continue;
                    configData.add(setting.address);
                    configData.add(setting.value);
                }
                if (!configData.isEmpty()) {
                    int bytesRemaining = configData.size();
                    int total = (bytesRemaining + 24 - 1) / 24;
                    int iConfig = 0;
                    for (int part = 1; part <= total; ++part) {
                        int size = bytesRemaining > 24 ? 24 : bytesRemaining;
                        bytesRemaining -= 24;
                        byte[] payload = new byte[size + 11];
                        payload[0] = -16;
                        payload[1] = 0;
                        payload[2] = 1;
                        payload[3] = 121;
                        payload[4] = 4;
                        payload[5] = 0;
                        payload[6] = this.sysexTag;
                        payload[7] = (byte)part;
                        payload[8] = (byte)total;
                        payload[9] = (byte)size;
                        payload[payload.length - 1] = -9;
                        for (int idx = 10; idx < size + 10; ++idx) {
                            payload[idx] = (Byte)configData.get(iConfig++);
                        }
                        MidiFighterTwister.this.output.sendSysex(payload);
                    }
                }
                this.isModified = false;
                for (Setting setting : this.settings.values()) {
                    setting.isModified = false;
                }
            }

            private void pull() {
                byte[] payload = new byte[]{-16, 0, 1, 121, 4, 1, this.sysexTag, -9};
                MidiFighterTwister.this.output.sendSysex(payload);
            }

            private class Setting {
                private final byte address;
                private byte value;
                private boolean isModified;

                private Setting(byte address) {
                    this.address = address;
                    this.value = 0;
                    this.isModified = false;
                }

                private boolean setValue(byte value) {
                    if (this.value != value) {
                        this.value = value;
                        this.isModified = true;
                    }
                    return this.isModified;
                }
            }
        }
    }

    public static enum KnobClickMode {
        RESET("Reset"),
        TEMPORARY("Temporary Edit");

        private final String label;

        private KnobClickMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum FocusMode {
        DEVICE("Device"),
        CHANNEL("Channel");

        private final String label;

        private FocusMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private final LXListenableNormalizedParameter[] knobs = new LXListenableNormalizedParameter[64];
        private final int[] knobTicks = new int[64];
        private final int[] knobIncrementSize = new int[64];
        private static final double KNOB_INCREMENT_AMOUNT = 0.007874015748031496;
        private double[] tempValues = new double[64];
        private boolean isRegistered = false;

        private DeviceListener(LX lx) {
            for (int i = 0; i < this.knobs.length; ++i) {
                this.knobs[i] = null;
                this.knobTicks[i] = 0;
                this.knobIncrementSize[i] = 1;
            }
            this.focusedDevice = new FocusedDevice(lx, MidiFighterTwister.this, this);
            this.focusedDevice.setAuxSticky(true);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        private void resend() {
            LXListenableNormalizedParameter parameter;
            int i;
            boolean isAux = MidiFighterTwister.this.isAux();
            for (i = 0; i < this.knobs.length; ++i) {
                Config.Encoder enc;
                parameter = this.knobs[i];
                Config.Encoder encoder = enc = i < MidiFighterTwister.this.lxConfig.encoders.length ? MidiFighterTwister.this.lxConfig.encoders[i] : null;
                if (parameter != null && enc != null) {
                    enc.setDetent(parameter.getPolarity() == LXParameter.Polarity.BIPOLAR);
                    continue;
                }
                if (enc == null) continue;
                enc.setDetent(false);
            }
            MidiFighterTwister.this.lxConfig.sendModified();
            for (i = 0; i < this.knobs.length; ++i) {
                parameter = this.knobs[i];
                if (parameter != null) {
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 95);
                    double normalized = parameter.getBaseNormalized();
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, (int)(normalized * 127.0));
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 47);
                    MidiFighterTwister.this.sendControlChange(1, 0 + i, isAux ? 80 : 1);
                    continue;
                }
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 72);
                if (i <= MidiFighterTwister.this.lxConfig.encoders.length && MidiFighterTwister.this.lxConfig.encoders[i].has_detent.value == 1) {
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, 63);
                } else {
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, 0);
                }
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 17);
            }
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device != device) {
                this.unregisterDevice();
                this.device = device;
                if (this.device != null) {
                    this.device.remoteControlsChanged.addListener(this);
                }
                this.registerDeviceKnobs();
            }
        }

        private void registerDeviceKnobs() {
            int e = 0;
            if (this.device != null) {
                for (LXListenableNormalizedParameter parameter : this.device.getRemoteControls()) {
                    if (e >= this.knobs.length || e >= MidiFighterTwister.this.lxConfig.encoders.length) break;
                    Config.Encoder enc = MidiFighterTwister.this.lxConfig.encoders[e];
                    if (parameter != null) {
                        enc.setDetent(parameter.getPolarity() == LXParameter.Polarity.BIPOLAR);
                    } else {
                        enc.setDetent(false);
                    }
                    ++e;
                }
            }
            MidiFighterTwister.this.lxConfig.sendModified();
            int i = 0;
            if (this.device != null) {
                boolean isAux = MidiFighterTwister.this.isAux();
                ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
                for (LXListenableNormalizedParameter parameter : this.device.getRemoteControls()) {
                    if (i >= this.knobs.length) break;
                    this.knobs[i] = parameter;
                    this.knobTicks[i] = 0;
                    if (parameter != null) {
                        if (parameter instanceof DiscreteParameter && ((DiscreteParameter)parameter).getIncrementMode() == DiscreteParameter.IncrementMode.NORMALIZED) {
                            this.knobTicks[i] = (int)(parameter.getNormalized() * 127.0);
                            this.knobIncrementSize[i] = LXUtils.max(1, 127 / ((DiscreteParameter)parameter).getRange());
                        }
                        if (!uniqueParameters.contains(parameter)) {
                            parameter.addListener(this);
                            uniqueParameters.add(parameter);
                        }
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 95);
                        double normalized = parameter.getBaseNormalized();
                        MidiFighterTwister.this.sendControlChange(0, 0 + i, (int)(normalized * 127.0));
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 47);
                        if (parameter instanceof LXCompoundModulation.Target && ((LXCompoundModulation.Target)((Object)parameter)).getModulations().size() > 0) {
                            MidiFighterTwister.this.sendControlChange(2, 0 + i, 12);
                        } else {
                            MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                        }
                    } else {
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 72);
                        if (i <= MidiFighterTwister.this.lxConfig.encoders.length && MidiFighterTwister.this.lxConfig.encoders[i].has_detent.value == 1) {
                            MidiFighterTwister.this.sendControlChange(0, 0 + i, 63);
                        } else {
                            MidiFighterTwister.this.sendControlChange(0, 0 + i, 0);
                        }
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 17);
                    }
                    MidiFighterTwister.this.sendControlChange(1, 0 + i, isAux ? 80 : 1);
                    ++i;
                }
            }
            while (i < this.knobs.length) {
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 72);
                if (i <= MidiFighterTwister.this.lxConfig.encoders.length && MidiFighterTwister.this.lxConfig.encoders[i].has_detent.value == 1) {
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, 63);
                } else {
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, 0);
                }
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 17);
                ++i;
            }
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            if (parameter == this.device.remoteControlsChanged) {
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
                return;
            }
            for (int i = 0; i < this.knobs.length; ++i) {
                if (parameter != this.knobs[i]) continue;
                double normalized = this.knobs[i].getBaseNormalized();
                if (parameter instanceof DiscreteParameter && ((DiscreteParameter)parameter).getIncrementMode() == DiscreteParameter.IncrementMode.NORMALIZED) {
                    this.knobTicks[i] = (int)(normalized * 127.0);
                }
                MidiFighterTwister.this.sendControlChange(0, 0 + i, (int)(normalized * 127.0));
            }
        }

        private void onKnobIncrement(int index, boolean isUp) {
            LXListenableNormalizedParameter knob = this.knobs[index];
            if (knob != null) {
                if (knob instanceof DiscreteParameter) {
                    if (((DiscreteParameter)knob).getIncrementMode() == DiscreteParameter.IncrementMode.NORMALIZED) {
                        int value = this.knobTicks[index] + (isUp ? 1 : -1);
                        if (knob.isWrappable()) {
                            if (value < 0 - this.knobIncrementSize[index] || value > 127 + this.knobIncrementSize[index]) {
                                value = value < 0 ? 127 : 0;
                            }
                            this.knobTicks[index] = value;
                            value = LXUtils.constrain(value, 0, 127);
                        } else {
                            this.knobTicks[index] = value = LXUtils.constrain(value, 0, 127);
                        }
                        knob.setNormalized((double)value / 127.0);
                    } else {
                        this.knobTicks[index] = isUp ? LXUtils.max(this.knobTicks[index], 0) + 1 : LXUtils.min(this.knobTicks[index], 0) - 1;
                        if (this.knobTicks[index] == 8 * (isUp ? 1 : -1)) {
                            this.knobTicks[index] = 0;
                            if (isUp) {
                                ((DiscreteParameter)knob).increment();
                            } else {
                                ((DiscreteParameter)knob).decrement();
                            }
                        }
                    }
                } else {
                    knob.incrementNormalized(0.007874015748031496 * (double)(isUp ? 1 : -1));
                }
            }
        }

        private void onSwitch(int index, boolean isPressed) {
            if (this.knobs[index] != null) {
                LXListenableNormalizedParameter p = this.knobs[index];
                if (p instanceof BooleanParameter) {
                    BooleanParameter bp = (BooleanParameter)p;
                    if (bp.getMode() == BooleanParameter.Mode.MOMENTARY) {
                        bp.setValue(isPressed);
                    } else if (isPressed) {
                        bp.toggle();
                    }
                } else if (p instanceof DiscreteParameter) {
                    if (isPressed) {
                        ((DiscreteParameter)p).increment();
                    }
                } else if (isPressed) {
                    switch (MidiFighterTwister.this.knobClickMode.getEnum()) {
                        case RESET: {
                            p.reset();
                            break;
                        }
                        case TEMPORARY: {
                            this.tempValues[index] = p.getBaseNormalized();
                        }
                    }
                } else {
                    switch (MidiFighterTwister.this.knobClickMode.getEnum()) {
                        case RESET: {
                            break;
                        }
                        case TEMPORARY: {
                            p.setNormalized(this.tempValues[index]);
                        }
                    }
                }
            }
        }

        private void unregisterDevice() {
            if (this.device != null) {
                this.device.remoteControlsChanged.removeListener(this);
                this.unregisterDeviceKnobs();
            }
            this.device = null;
        }

        private void unregisterDeviceKnobs() {
            ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
            for (int i = 0; i < this.knobs.length; ++i) {
                if (this.knobs[i] == null) continue;
                if (!uniqueParameters.contains(this.knobs[i])) {
                    uniqueParameters.add(this.knobs[i]);
                    this.knobs[i].removeListener(this);
                }
                this.knobs[i] = null;
                this.knobTicks[i] = 0;
                this.knobIncrementSize[i] = 1;
            }
        }

        private void register() {
            this.isRegistered = true;
            this.focusedDevice.register();
        }

        private void unregister() {
            this.isRegistered = false;
            this.focusedDevice.unregister();
        }

        private void dispose() {
            this.focusedDevice.dispose();
        }
    }
}

