/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXModelComponent;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.LXPresetComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClip;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class LXBus
extends LXModelComponent
implements LXPresetComponent,
LXOscComponent {
    public final CompoundParameter fader = new CompoundParameter("Fader", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the alpha level of the output of this channel");
    public final BooleanParameter arm = new BooleanParameter("Arm").setDescription("Arms the channel for clip recording");
    public final BooleanParameter selected = new BooleanParameter("Selected").setDescription("Whether the channel is selected");
    public final BooleanParameter controlsExpandedCue = new BooleanParameter("Expanded Cue", true).setDescription("Whether the control elements for this channel are expanded in cue view");
    public final BooleanParameter controlsExpandedAux = new BooleanParameter("Expanded Aux", true).setDescription("Whether the control elements for this channel are expanded in aux view");
    protected final List<LXEffect> mutableEffects = new ArrayList<LXEffect>();
    public final List<LXEffect> effects = Collections.unmodifiableList(this.mutableEffects);
    private final List<LXClip> mutableClips = new ArrayList<LXClip>();
    public final List<LXClip> clips = Collections.unmodifiableList(this.mutableClips);
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<ClipListener> clipListeners = new ArrayList<ClipListener>();
    public static final String PATH_EFFECT = "effect";
    private static final String KEY_EFFECTS = "effects";
    private static final String KEY_CLIPS = "clips";

    @Override
    protected LXModulatorComponent.Profiler constructProfiler() {
        return new Profiler();
    }

    LXBus(LX lx) {
        this(lx, null);
    }

    LXBus(LX lx, String label) {
        super(lx, label);
        this.addArray(PATH_EFFECT, this.effects);
        this.addParameter("fader", this.fader);
        this.addArray("clip", this.clips);
        this.addParameter("arm", this.arm);
        this.addParameter("selected", this.selected);
        this.addInternalParameter("controlsExpandedCue", this.controlsExpandedCue);
        this.addInternalParameter("controlsExpandedAux", this.controlsExpandedAux);
    }

    public abstract int getIndex();

    protected void setMixer(LXMixerEngine mixer) {
        this.setParent(mixer);
    }

    public final void addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXBus.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("May not add duplicate LXBus.Listener: " + listener);
        }
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered Bus.Listener: " + listener);
        }
        this.listeners.remove(listener);
    }

    public LXBus addClipListener(ClipListener listener) {
        Objects.requireNonNull(listener, "May not add null LXBus.ClipListener");
        if (this.clipListeners.contains(listener)) {
            throw new IllegalStateException("May not remove add duplicate LXBus.ClipListener: " + listener);
        }
        this.clipListeners.add(listener);
        return this;
    }

    public LXBus removeClipListener(ClipListener listener) {
        if (!this.clipListeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXBus.ClipListener: " + listener);
        }
        this.clipListeners.remove(listener);
        return this;
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_EFFECT)) {
            String effectId = parts[index + 1];
            if (effectId.matches("\\d+")) {
                return this.effects.get(Integer.parseInt(effectId) - 1).handleOscMessage(message, parts, index + 2);
            }
            for (LXEffect effect : this.effects) {
                if (!effect.getOscLabel().equals(effectId)) continue;
                return effect.handleOscMessage(message, parts, index + 2);
            }
            LXOscEngine.error("Channel " + this.getLabel() + " does not have effect at path: " + effectId + " (" + message + ")");
            return false;
        }
        return super.handleOscMessage(message, parts, index);
    }

    public LXGroup getGroup() {
        return null;
    }

    public boolean isGroup() {
        return this instanceof LXGroup;
    }

    public boolean isEmptyGroup() {
        return this.isGroup() && ((LXGroup)this).channels.size() == 0;
    }

    public boolean isChannel() {
        return this instanceof LXChannel;
    }

    public boolean isInGroup() {
        return this.getGroup() != null;
    }

    public final LXBus addEffect(LXEffect effect) {
        return this.addEffect(effect, -1);
    }

    public final LXBus addEffect(LXEffect effect, int index) {
        if (index > this.mutableEffects.size()) {
            throw new IllegalArgumentException("Illegal effect index: " + index);
        }
        if (index < 0) {
            index = this.mutableEffects.size();
        }
        this.mutableEffects.add(index, effect);
        effect.setBus(this);
        this._reindexEffects();
        for (Listener listener : this.listeners) {
            listener.effectAdded(this, effect);
        }
        return this;
    }

    public final LXBus removeEffect(LXEffect effect) {
        int index = this.mutableEffects.indexOf(effect);
        if (index >= 0) {
            effect.setIndex(-1);
            this.mutableEffects.remove(index);
            while (index < this.mutableEffects.size()) {
                this.mutableEffects.get(index).setIndex(index);
                ++index;
            }
            for (Listener listener : this.listeners) {
                listener.effectRemoved(this, effect);
            }
            effect.dispose();
        }
        return this;
    }

    public LXBus reloadEffect(LXEffect effect) {
        if (!this.effects.contains(effect)) {
            throw new IllegalStateException("Cannot reload effect not on a channel");
        }
        int index = effect.getIndex();
        JsonObject effectObj = new JsonObject();
        effect.save(this.getLX(), effectObj);
        this.removeEffect(effect);
        this.loadEffect(effectObj, index);
        return this;
    }

    private void _reindexEffects() {
        int i = 0;
        for (LXEffect e : this.mutableEffects) {
            e.setIndex(i++);
        }
    }

    public LXBus moveEffect(LXEffect effect, int index) {
        if (index < 0 || index >= this.mutableEffects.size()) {
            throw new IllegalArgumentException("Cannot move effect to invalid index: " + index);
        }
        if (!this.mutableEffects.contains(effect)) {
            throw new IllegalStateException("Cannot move effect that is not on channel: " + this + " " + effect);
        }
        this.mutableEffects.remove(effect);
        this.mutableEffects.add(index, effect);
        this._reindexEffects();
        for (Listener listener : this.listeners) {
            listener.effectMoved(this, effect);
        }
        return this;
    }

    public final List<LXEffect> getEffects() {
        return this.effects;
    }

    public LXEffect getEffect(int i) {
        return this.effects.get(i);
    }

    public LXEffect getEffect(String label) {
        for (LXEffect effect : this.effects) {
            if (!effect.getLabel().equals(label)) continue;
            return effect;
        }
        return null;
    }

    public LXClip getClip(int index) {
        return this.getClip(index, false);
    }

    public LXClip getClip(int index, boolean create) {
        if (index >= this.lx.engine.clips.numScenes.getValuei()) {
            return null;
        }
        if (index < this.clips.size()) {
            return this.clips.get(index);
        }
        if (create) {
            return this.addClip(index);
        }
        return null;
    }

    public LXClip addClip() {
        return this.addClip(this.mutableClips.size());
    }

    public LXClip addClip(int index) {
        return this.addClip(null, index);
    }

    public LXClip addClip(JsonObject clipObj, int index) {
        if (index >= 128) {
            throw new IllegalArgumentException("Cannot add clip at index >= 128");
        }
        if (this.getClip(index) != null) {
            throw new IllegalStateException("Cannot add clip at index " + index + " which already holds a clip: " + this);
        }
        while (this.mutableClips.size() <= index) {
            this.mutableClips.add(null);
        }
        LXClip clip = this.constructClip(index);
        if (clipObj != null) {
            clip.load(this.lx, clipObj);
        } else {
            clip.snapshot.initialize();
            clip.label.setValue(this.getClipLabel() + "-" + (index + 1));
        }
        this.mutableClips.set(index, clip);
        for (ClipListener listener : this.clipListeners) {
            listener.clipAdded(this, clip);
        }
        return clip;
    }

    protected String getClipLabel() {
        return "Clip";
    }

    public LXBus stopClips() {
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            clip.stop();
        }
        return this;
    }

    protected abstract LXClip constructClip(int var1);

    public void removeClip(LXClip clip) {
        int index = this.mutableClips.indexOf(clip);
        if (index < 0) {
            throw new IllegalArgumentException("Clip is not owned by channel: " + clip + " " + this);
        }
        this.removeClip(index);
    }

    public void removeClip(int index) {
        LXClip clip = this.getClip(index, false);
        if (clip != null) {
            this.mutableClips.set(index, null);
            if (this.lx.engine.clips.getFocusedClip() == clip) {
                this.lx.engine.clips.setFocusedClip(null);
            }
            for (ClipListener listener : this.clipListeners) {
                listener.clipRemoved(this, clip);
            }
            clip.dispose();
        }
    }

    @Override
    public void loop(double deltaMs) {
        this.loop(deltaMs, true);
    }

    protected void loop(double deltaMs, boolean runComponents) {
        long loopStart = System.nanoTime();
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            clip.loop(deltaMs);
        }
        if (runComponents) {
            super.loop(deltaMs);
        }
        this.profiler.loopNanos = System.nanoTime() - loopStart;
    }

    protected void disposeClips() {
        for (LXClip clip : this.mutableClips) {
            if (clip == null) continue;
            clip.dispose();
        }
        this.mutableClips.clear();
    }

    @Override
    public void dispose() {
        this.disposeClips();
        for (LXEffect effect : this.mutableEffects) {
            effect.dispose();
        }
        this.mutableEffects.clear();
        this.listeners.clear();
        this.clipListeners.clear();
        super.dispose();
    }

    @Override
    public Class<?> getPresetClass() {
        return LXBus.class;
    }

    @Override
    public void postProcessPreset(LX lx, JsonObject obj) {
        LXSerializable.Utils.stripParameter(obj, this.fader);
        LXSerializable.Utils.stripParameter(obj, this.arm);
        LXSerializable.Utils.stripParameter(obj, this.selected);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_EFFECTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.mutableEffects));
        JsonArray clipsArr = new JsonArray();
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            clipsArr.add((JsonElement)LXSerializable.Utils.toObject(lx, clip));
        }
        obj.add(KEY_CLIPS, (JsonElement)clipsArr);
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            this.removeClip(clip);
        }
        for (int i = this.mutableEffects.size() - 1; i >= 0; --i) {
            this.removeEffect(this.mutableEffects.get(i));
        }
        if (obj.has(KEY_EFFECTS)) {
            JsonArray effectsArray = obj.getAsJsonArray(KEY_EFFECTS);
            for (JsonElement effectElement : effectsArray) {
                JsonObject effectObj = (JsonObject)effectElement;
                this.loadEffect(effectObj, -1);
            }
        }
        if (obj.has(KEY_CLIPS)) {
            JsonArray clipsArr = obj.get(KEY_CLIPS).getAsJsonArray();
            for (JsonElement clipElem : clipsArr) {
                JsonObject clipObj = clipElem.getAsJsonObject();
                int clipIndex = clipObj.get("index").getAsInt();
                LXClip clip = this.addClip(clipIndex);
                clip.load(lx, clipObj);
            }
        }
        super.load(lx, obj);
    }

    private LXEffect loadEffect(JsonObject effectObj, int index) {
        LXEffect effect;
        String effectClass = effectObj.get("class").getAsString();
        try {
            effect = this.lx.instantiateEffect(effectClass);
        }
        catch (LX.InstantiationException x) {
            LX.error("Using placeholder class for missing effect: " + effectClass);
            effect = new LXEffect.Placeholder(this.lx, x);
            this.lx.pushError(x, effectClass + " could not be loaded. " + x.getMessage());
        }
        effect.load(this.lx, effectObj);
        this.addEffect(effect, index);
        return effect;
    }

    public class Profiler
    extends LXModulatorComponent.Profiler {
        public long effectNanos;

        @Override
        public long renderNanos() {
            return super.renderNanos() + this.effectNanos;
        }
    }

    public static interface Listener {
        default public void effectAdded(LXBus channel, LXEffect effect) {
        }

        default public void effectRemoved(LXBus channel, LXEffect effect) {
        }

        default public void effectMoved(LXBus channel, LXEffect effect) {
        }
    }

    public static interface ClipListener {
        public void clipAdded(LXBus var1, LXClip var2);

        public void clipRemoved(LXBus var1, LXClip var2);
    }
}

