/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXMasterClip;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.parameter.EnumParameter;

public class LXMasterBus
extends LXBus {
    public final EnumParameter<PreviewMode> previewMode = new EnumParameter<PreviewMode>("Preview Mode", PreviewMode.PRE).setDescription("Whether the preview is generated PRE or POST the master fader");

    public LXMasterBus(LX lx) {
        super(lx, "Master");
        this.addParameter("previewMode", this.previewMode);
    }

    public double getOutputBrightness() {
        switch (this.previewMode.getEnum()) {
            case PRE: {
                return this.fader.getValue();
            }
        }
        return 1.0;
    }

    @Override
    public int getIndex() {
        return this.lx.engine.mixer.channels.size();
    }

    @Override
    public String getPath() {
        return "master";
    }

    @Override
    protected LXClip constructClip(int index) {
        return new LXMasterClip(this.lx, index);
    }

    @Override
    public void postProcessPreset(LX lx, JsonObject obj) {
        super.postProcessPreset(lx, obj);
        LXSerializable.Utils.stripParameter(obj, this.previewMode);
    }

    public static enum PreviewMode {
        PRE("Pre"),
        POST("Post");

        private final String label;

        private PreviewMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

