/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXEngine;
import heronarts.lx.LXRegistry;
import heronarts.lx.LXSerializable;
import heronarts.lx.ModelBuffer;
import heronarts.lx.blend.AddBlend;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.clip.LXClip;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMasterBus;
import heronarts.lx.model.LXModel;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LXMixerEngine
extends LXComponent
implements LXOscComponent {
    static final PatternFriendAccess patternFriendAccess = new PatternFriendAccess();
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<LXAbstractChannel> mutableChannels = new ArrayList<LXAbstractChannel>();
    public final List<LXAbstractChannel> channels = Collections.unmodifiableList(this.mutableChannels);
    public final LXMasterBus masterBus;
    private final AddBlend addBlend;
    public final DiscreteParameter focusedChannel = new DiscreteParameter("Channel", 1).setDescription("Which channel is currently focused in the UI");
    public final DiscreteParameter focusedChannelAux = new DiscreteParameter("Aux", 1).setDescription("Which channel is currently focused in the auxiliary UI");
    public final CompoundParameter crossfader = new CompoundParameter("Crossfader", 0.5).setDescription("Applies blending between output groups A and B").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final ObjectParameter<LXBlend> crossfaderBlendMode;
    private LXBlend activeCrossfaderBlend;
    public final BooleanParameter cueA = new BooleanParameter("Cue-A", false).setDescription("Enables cue preview of crossfade group A");
    public final BooleanParameter cueB = new BooleanParameter("Cue-B", false).setDescription("Enables cue preview of crossfade group B");
    public final BooleanParameter auxA = new BooleanParameter("Aux-A", false).setDescription("Enables aux preview of crossfade group A");
    public final BooleanParameter auxB = new BooleanParameter("Aux-B", false).setDescription("Enables aux preview of crossfade group B");
    final ModelBuffer backgroundBlack;
    final ModelBuffer backgroundTransparent;
    private final ModelBuffer blendBufferLeft;
    private final ModelBuffer blendBufferRight;
    public final BooleanParameter viewCondensed = new BooleanParameter("Condensed", false).setDescription("Whether the mixer view should be condensed");
    public static final String PATH_CHANNEL = "channel";
    public static final String PATH_FOCUSED = "focused";
    public static final String PATH_MASTER = "master";
    private final BlendStack blendStackMain = new BlendStack();
    private final BlendStack blendStackCue = new BlendStack();
    private final BlendStack blendStackAux = new BlendStack();
    private final BlendStack blendStackLeft = new BlendStack();
    private final BlendStack blendStackRight = new BlendStack();
    private static final String KEY_CHANNELS = "channels";

    public final LXMixerEngine addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXMixerEngine.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannod add mixer listener twice: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public final LXMixerEngine removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public LXMixerEngine(LX lx) {
        super(lx, "Mixer");
        this.backgroundBlack = new ModelBuffer(lx, -16777216);
        this.backgroundTransparent = new ModelBuffer(lx, 0);
        this.blendBufferLeft = new ModelBuffer(lx);
        this.blendBufferRight = new ModelBuffer(lx);
        LX.initProfiler.log("Engine: Mixer: Buffers");
        this.addBlend = new AddBlend(lx);
        this.addBlend.onActive();
        this.crossfaderBlendMode = new ObjectParameter<LXBlend>("Crossfader Blend", new LXBlend[1]).setDescription("Sets the blend mode used for the master crossfader");
        this.updateCrossfaderBlendOptions();
        LX.initProfiler.log("Engine: Mixer: Blends");
        this.masterBus = new LXMasterBus(lx);
        this.addChild(PATH_MASTER, this.masterBus);
        LX.initProfiler.log("Engine: Mixer: Master Channel");
        lx.addListener(new LX.Listener(){

            @Override
            public void modelChanged(LX lx, LXModel model) {
                for (LXBus lXBus : LXMixerEngine.this.channels) {
                    lXBus.setModel(model);
                }
                LXMixerEngine.this.masterBus.setModel(model);
            }
        });
        lx.registry.addListener(new LXRegistry.Listener(){

            @Override
            public void channelBlendsChanged(LX lx) {
                for (LXAbstractChannel channel : LXMixerEngine.this.channels) {
                    channel.updateChannelBlendOptions();
                }
            }

            @Override
            public void transitionBlendsChanged(LX lx) {
                for (LXAbstractChannel channel : LXMixerEngine.this.channels) {
                    if (!(channel instanceof LXChannel)) continue;
                    ((LXChannel)channel).updateTransitionBlendOptions();
                }
            }

            @Override
            public void crossfaderBlendsChanged(LX lx) {
                LXMixerEngine.this.updateCrossfaderBlendOptions();
            }
        });
        this.addArray(PATH_CHANNEL, this.channels);
        this.addParameter("crossfader", this.crossfader);
        this.addParameter("crossfaderBlendMode", this.crossfaderBlendMode);
        this.addParameter("focusedChannel", this.focusedChannel);
        this.addParameter("focusedChannelAux", this.focusedChannelAux);
        this.addParameter("cueA", this.cueA);
        this.addParameter("cueB", this.cueB);
        this.addParameter("auxA", this.auxA);
        this.addParameter("auxB", this.auxB);
        this.addParameter("viewCondensed", this.viewCondensed);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        LXClip clip;
        super.onParameterChanged(p);
        if (this.crossfaderBlendMode == p) {
            this.activeCrossfaderBlend.onInactive();
            this.activeCrossfaderBlend = this.crossfaderBlendMode.getObject();
            this.activeCrossfaderBlend.onActive();
        } else if (this.cueA == p) {
            if (this.cueA.isOn()) {
                this.cueB.setValue(false);
                for (LXAbstractChannel channel : this.channels) {
                    channel.cueActive.setValue(false);
                }
            }
        } else if (this.cueB == p) {
            if (this.cueB.isOn()) {
                this.cueA.setValue(false);
                for (LXAbstractChannel channel : this.channels) {
                    channel.cueActive.setValue(false);
                }
            }
        } else if (this.auxA == p) {
            if (this.auxA.isOn()) {
                this.auxB.setValue(false);
                for (LXAbstractChannel channel : this.channels) {
                    channel.auxActive.setValue(false);
                }
            }
        } else if (this.auxB == p) {
            if (this.auxB.isOn()) {
                this.auxA.setValue(false);
                for (LXAbstractChannel channel : this.channels) {
                    channel.auxActive.setValue(false);
                }
            }
        } else if (this.focusedChannel == p && (clip = this.lx.engine.clips.getFocusedClip()) != null && clip.bus != this.getFocusedChannel()) {
            this.lx.engine.clips.setFocusedClip(null);
        }
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_CHANNEL)) {
            String channelIndex = parts[index + 1];
            LXBus channel = null;
            if (channelIndex.equals(PATH_FOCUSED)) {
                channel = this.getFocusedChannel();
            } else if (channelIndex.equals(PATH_MASTER)) {
                channel = this.masterBus;
            } else if (channelIndex.matches("\\d+")) {
                channel = this.channels.get(Integer.parseInt(channelIndex) - 1);
            } else {
                for (LXAbstractChannel bus : this.channels) {
                    if (!bus.getOscLabel().equals(channelIndex)) continue;
                    channel = bus;
                    break;
                }
            }
            if (channel == null) {
                LXOscEngine.error("Engine has no channel at path: " + channelIndex);
                return false;
            }
            if (channel instanceof LXChannel) {
                return ((LXChannel)channel).handleOscMessage(message, parts, index + 2);
            }
            return channel.handleOscMessage(message, parts, index + 2);
        }
        return super.handleOscMessage(message, parts, index);
    }

    private LXBlend[] instantiateBlends(List<Class<? extends LXBlend>> blendTypes) {
        ArrayList<LXBlend> blends = new ArrayList<LXBlend>(blendTypes.size());
        for (Class<? extends LXBlend> blend : blendTypes) {
            try {
                blends.add(this.lx.instantiateBlend(blend));
            }
            catch (LX.InstantiationException x) {
                this.lx.pushError(x, "Cannot instantiate blend class: " + blend.getName() + ". Check that content files are not missing?");
            }
        }
        return blends.toArray(new LXBlend[0]);
    }

    public LXBlend[] instantiateChannelBlends() {
        return this.instantiateBlends(this.lx.registry.channelBlends);
    }

    protected LXBlend[] instantiateTransitionBlends() {
        return this.instantiateBlends(this.lx.registry.transitionBlends);
    }

    protected LXBlend[] instantiateCrossfaderBlends() {
        return this.instantiateBlends(this.lx.registry.crossfaderBlends);
    }

    private void updateCrossfaderBlendOptions() {
        for (LXBlend blend : this.crossfaderBlendMode.getObjects()) {
            if (blend == null) continue;
            blend.dispose();
        }
        this.crossfaderBlendMode.setObjects((LXBlend[])this.instantiateCrossfaderBlends());
        this.activeCrossfaderBlend = this.crossfaderBlendMode.getObject();
        this.activeCrossfaderBlend.onActive();
    }

    public List<LXAbstractChannel> getChannels() {
        return this.channels;
    }

    public LXChannel getDefaultChannel() {
        for (LXAbstractChannel channel : this.channels) {
            if (!(channel instanceof LXChannel)) continue;
            return (LXChannel)channel;
        }
        return null;
    }

    public LXAbstractChannel getLastChannel() {
        return this.channels.get(this.channels.size() - 1);
    }

    public LXAbstractChannel getChannel(int channelIndex) {
        return this.mutableChannels.get(channelIndex);
    }

    public LXAbstractChannel getChannel(String label) {
        for (LXAbstractChannel channel : this.mutableChannels) {
            if (!channel.getLabel().equals(label)) continue;
            return channel;
        }
        return null;
    }

    public LXBus getFocusedChannel() {
        if (this.focusedChannel.getValuei() == this.mutableChannels.size()) {
            return this.masterBus;
        }
        return this.getChannel(this.focusedChannel.getValuei());
    }

    public LXMixerEngine setFocusedChannel(LXBus channel) {
        if (channel == this.masterBus) {
            this.focusedChannel.setValue(this.mutableChannels.size());
        } else {
            this.focusedChannel.setValue(this.mutableChannels.indexOf(channel));
        }
        return this;
    }

    public LXBus getFocusedChannelAux() {
        if (this.focusedChannelAux.getValuei() == this.mutableChannels.size()) {
            return this.masterBus;
        }
        return this.getChannel(this.focusedChannelAux.getValuei());
    }

    public LXMixerEngine setFocusedChannelAux(LXBus channel) {
        if (channel == this.masterBus) {
            this.focusedChannelAux.setValue(this.mutableChannels.size());
        } else {
            this.focusedChannelAux.setValue(this.mutableChannels.indexOf(channel));
        }
        return this;
    }

    public LXMixerEngine deselectChannel(LXBus bus) {
        boolean otherSelected = false;
        for (LXAbstractChannel channel : this.channels) {
            if (channel == bus || !channel.selected.isOn()) continue;
            otherSelected = true;
            break;
        }
        if (this.masterBus != bus && this.masterBus.selected.isOn()) {
            otherSelected = true;
        }
        if (otherSelected) {
            bus.selected.setValue(false);
        }
        return this;
    }

    public LXMixerEngine selectChannel(LXBus bus) {
        return this.selectChannel(bus, false);
    }

    public LXMixerEngine selectChannel(LXBus bus, boolean multipleSelection) {
        boolean bl = multipleSelection = multipleSelection && this.masterBus != bus && !this.masterBus.selected.isOn();
        if (!multipleSelection) {
            for (LXAbstractChannel channel : this.channels) {
                if (channel == bus) continue;
                channel.selected.setValue(false);
            }
            if (this.masterBus != bus) {
                this.masterBus.selected.setValue(false);
            }
        } else {
            LXGroup busGroup = bus.getGroup();
            for (LXAbstractChannel channel : this.channels) {
                if (channel.getGroup() == busGroup) continue;
                channel.selected.setValue(false);
            }
        }
        bus.selected.setValue(true);
        return this;
    }

    public LXMixerEngine selectChannelRange(LXBus destination) {
        int focusIndex = this.focusedChannel.getValuei();
        int selectIndex = destination.getIndex();
        LXGroup selectedGroup = this.getFocusedChannel().getGroup();
        int minIndex = LXUtils.min(focusIndex, selectIndex);
        int maxIndex = LXUtils.max(focusIndex, selectIndex);
        for (LXAbstractChannel bus : this.channels) {
            int busIndex = bus.getIndex();
            bus.selected.setValue(bus.getGroup() == selectedGroup && busIndex >= minIndex && busIndex <= maxIndex);
        }
        this.masterBus.selected.setValue(false);
        return this;
    }

    public LXChannel addChannel() {
        return this.addChannel(-1);
    }

    public LXChannel addChannel(int index, JsonObject channelObj) {
        return this.addChannel(index, channelObj, new LXPattern[0]);
    }

    public LXChannel addChannel(JsonObject channelObj) {
        return this.addChannel(-1, channelObj, new LXPattern[0]);
    }

    public LXChannel addChannel(int index) {
        return this.addChannel(index, null, new LXPattern[0]);
    }

    public LXChannel addChannel(LXPattern[] patterns) {
        return this.addChannel(-1, null, patterns);
    }

    public LXChannel addChannel(int index, LXPattern[] patterns) {
        return this.addChannel(index, null, patterns);
    }

    public LXChannel addChannel(int index, JsonObject channelObj, LXPattern[] patterns) {
        if (index > this.mutableChannels.size()) {
            throw new IllegalArgumentException("Invalid channel index: " + index);
        }
        if (index < 0) {
            index = this.mutableChannels.size();
        }
        LXChannel channel = new LXChannel(this.lx, index, patterns);
        channel.fader.setValue(this.channels.isEmpty() ? 1.0 : 0.0);
        if (channelObj != null) {
            channel.load(this.lx, channelObj);
        }
        this._addChannel(channel, index);
        if (this.focusedChannel.getValuei() == index) {
            this.focusedChannel.bang();
        } else {
            this.focusedChannel.setValue(index);
        }
        if (this.focusedChannelAux.getValuei() == index) {
            this.focusedChannelAux.bang();
        } else {
            this.focusedChannelAux.setValue(index);
        }
        return channel;
    }

    public LXMixerEngine group(LXGroup group, LXChannel channel, int index) {
        if (channel.getGroup() != null) {
            throw new IllegalStateException("Cannot group channel that is already in another group");
        }
        if (index <= group.getIndex() || index > group.getIndex() + group.channels.size() + 1) {
            throw new IllegalArgumentException("Invalid index specified to group channel: " + index);
        }
        this.mutableChannels.remove(channel);
        this.mutableChannels.add(index, channel);
        this._reindexChannels();
        group.addChannel(channel);
        for (Listener listener : this.listeners) {
            listener.channelMoved(this, channel);
        }
        return this;
    }

    public LXMixerEngine ungroup(LXChannel channel) {
        boolean focused = this.focusedChannel.getValuei() == channel.index;
        boolean focusedAux = this.focusedChannelAux.getValuei() == channel.index;
        LXGroup group = channel.getGroup();
        if (group != null) {
            group.removeChannel(channel);
            this.mutableChannels.remove(channel);
            this.mutableChannels.add(group.getIndex() + group.channels.size() + 1, channel);
            this._reindexChannels();
            for (Listener listener : this.listeners) {
                listener.channelMoved(this, channel);
            }
            if (focused) {
                this.focusedChannel.setValue(channel.index);
            }
            if (focusedAux) {
                this.focusedChannelAux.setValue(channel.index);
            }
        }
        return this;
    }

    public LXGroup addGroupFromSelection() {
        return this.addGroup(this.getSelectedChannelsForGroup());
    }

    public LXGroup addGroup() {
        return this.addGroup(-1);
    }

    public LXGroup addGroup(int index) {
        if (index > this.mutableChannels.size()) {
            throw new IllegalArgumentException("Invalid group index: " + index);
        }
        if (index < 0) {
            index = this.mutableChannels.size();
        }
        LXGroup group = new LXGroup(this.lx, index);
        this._addChannel(group, group.getIndex());
        return group;
    }

    public LXGroup addGroup(List<LXChannel> groupChannels) {
        if (groupChannels.isEmpty()) {
            return null;
        }
        int groupIndex = groupChannels.get((int)0).index;
        LXGroup group = new LXGroup(this.lx, groupIndex);
        int reindex = groupIndex;
        for (LXChannel channel : groupChannels) {
            this.mutableChannels.remove(channel);
            this.mutableChannels.add(reindex++, channel);
            group.addChannel(channel);
        }
        this._addChannel(group, group.getIndex());
        this._reindexChannels();
        if (this.focusedChannel.getValuei() == groupIndex) {
            this.focusedChannel.bang();
        } else {
            this.focusedChannel.setValue(groupIndex);
        }
        if (this.focusedChannelAux.getValuei() == groupIndex) {
            this.focusedChannelAux.bang();
        } else {
            this.focusedChannelAux.setValue(groupIndex);
        }
        this.selectChannel(group);
        return group;
    }

    public List<LXChannel> getSelectedChannelsForGroup() {
        ArrayList<LXChannel> groupChannels = new ArrayList<LXChannel>();
        for (LXAbstractChannel channel : this.channels) {
            if (!channel.isChannel() || !channel.selected.isOn() || channel.isInGroup()) continue;
            groupChannels.add((LXChannel)channel);
        }
        return groupChannels;
    }

    private void _addChannel(LXAbstractChannel channel, int index) {
        channel.setMixer(this);
        this.mutableChannels.add(index, channel);
        this.focusedChannel.setRange(this.mutableChannels.size() + 1);
        this.focusedChannelAux.setRange(this.mutableChannels.size() + 1);
        for (Listener listener : this.listeners) {
            listener.channelAdded(this, channel);
        }
        this._reindexChannels();
    }

    private void _reindexChannels() {
        int i = 0;
        for (LXAbstractChannel channelBus : this.channels) {
            channelBus.setIndex(i++);
        }
    }

    public void removeSelectedChannels() {
        ArrayList<LXAbstractChannel> toRemove = new ArrayList<LXAbstractChannel>();
        for (LXAbstractChannel channel : this.channels) {
            if (!channel.selected.isOn() || toRemove.contains(channel.getGroup())) continue;
            toRemove.add(channel);
        }
        for (LXAbstractChannel channel : toRemove) {
            this.removeChannel(channel);
        }
    }

    public void removeChannel(LXAbstractChannel channel) {
        boolean bl;
        LXGroup group;
        if (!this.mutableChannels.contains(channel)) {
            throw new IllegalStateException("Engine does not contain channel: " + channel);
        }
        if (channel instanceof LXGroup) {
            group = (LXGroup)channel;
            ArrayList<LXChannel> removeGroupChannels = new ArrayList<LXChannel>(group.channels);
            for (LXChannel lXChannel : removeGroupChannels) {
                this.removeChannel(lXChannel);
            }
        }
        if (channel instanceof LXChannel && (group = channel.getGroup()) != null) {
            group.removeChannel((LXChannel)channel);
        }
        this.mutableChannels.remove(channel);
        this._reindexChannels();
        int numChannels = this.mutableChannels.size();
        int focused = this.focusedChannel.getValuei();
        int focusedAux = this.focusedChannelAux.getValuei();
        if (focused > numChannels) {
            this.focusedChannel.setValue(numChannels, false);
        } else if (numChannels > 0 && focused == numChannels) {
            this.focusedChannel.setValue(numChannels - 1, false);
        }
        if (focusedAux > numChannels) {
            this.focusedChannelAux.setValue(numChannels, false);
        } else if (numChannels > 0 && focusedAux == numChannels) {
            this.focusedChannelAux.setValue(numChannels - 1, false);
        }
        this.focusedChannel.setRange(numChannels + 1);
        this.focusedChannelAux.setRange(numChannels + 1);
        this.focusedChannel.bang();
        this.focusedChannelAux.bang();
        for (Listener listener : this.listeners) {
            listener.channelRemoved(this, channel);
        }
        boolean bl2 = false;
        for (LXAbstractChannel bus : this.channels) {
            if (!bus.selected.isOn()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.getFocusedChannel().selected.setValue(true);
        }
        channel.dispose();
    }

    public void moveChannel(LXAbstractChannel channel, int delta) {
        if (delta != 1 && delta != -1) {
            throw new IllegalArgumentException("moveChannel() may only be called with delta of -1 or 1");
        }
        int index = channel.getIndex() + delta;
        if (index < 0 || index >= this.mutableChannels.size()) {
            return;
        }
        LXBus focused = this.getFocusedChannel();
        LXBus focusedAux = this.getFocusedChannelAux();
        LXGroup group = channel.getGroup();
        if (group != null) {
            if (index <= group.getIndex() || index > group.getIndex() + group.channels.size()) {
                return;
            }
            this.mutableChannels.remove(channel);
            this.mutableChannels.add(index, channel);
        } else {
            int startIndex;
            LXGroup neighborGroup;
            int neighborIndex;
            boolean isGroup = channel instanceof LXGroup;
            if (isGroup && delta > 0) {
                delta += ((LXGroup)channel).channels.size();
            }
            if ((neighborIndex = channel.getIndex() + delta) < 0 || neighborIndex >= this.mutableChannels.size()) {
                return;
            }
            LXAbstractChannel neighbor = this.mutableChannels.get(neighborIndex);
            LXGroup lXGroup = neighborGroup = neighbor instanceof LXGroup ? (LXGroup)neighbor : neighbor.getGroup();
            if (neighborGroup != null) {
                if (delta > 0) {
                    startIndex = channel.getIndex();
                    this.mutableChannels.remove(neighbor);
                    this.mutableChannels.add(startIndex, neighbor);
                    for (LXChannel subchannel : ((LXGroup)neighbor).channels) {
                        this.mutableChannels.remove(subchannel);
                        this.mutableChannels.add(++startIndex, subchannel);
                    }
                } else {
                    startIndex = neighborGroup.getIndex();
                    this.mutableChannels.remove(channel);
                    this.mutableChannels.add(startIndex, channel);
                    if (isGroup) {
                        for (LXChannel subchannel : ((LXGroup)channel).channels) {
                            this.mutableChannels.remove(subchannel);
                            this.mutableChannels.add(++startIndex, subchannel);
                        }
                    }
                }
            } else if (delta > 0) {
                startIndex = channel.getIndex();
                this.mutableChannels.remove(neighbor);
                this.mutableChannels.add(startIndex, neighbor);
            } else {
                int endIndex = channel.getIndex();
                if (isGroup) {
                    endIndex += ((LXGroup)channel).channels.size();
                }
                this.mutableChannels.remove(neighbor);
                this.mutableChannels.add(endIndex, neighbor);
            }
        }
        this._reindexChannels();
        this.focusedChannel.setValue(focused.getIndex());
        this.focusedChannelAux.setValue(focusedAux.getIndex());
        for (Listener listener : this.listeners) {
            listener.channelMoved(this, channel);
        }
    }

    public void moveChannel(LXAbstractChannel bus, int index, LXGroup group) {
        if (index < 0 || index >= this.channels.size()) {
            throw new IllegalArgumentException("Cannot move a channel to illegal index outside of mixer bounds: " + index);
        }
        LXBus focused = this.getFocusedChannel();
        LXBus focusedAux = this.getFocusedChannelAux();
        ArrayList<LXAbstractChannel> members = null;
        if (bus.isGroup()) {
            if (group != null) {
                throw new IllegalArgumentException("Cannot place a group into another group: " + bus + " -> " + group);
            }
            this.mutableChannels.remove(bus);
            members = new ArrayList<LXAbstractChannel>();
            for (LXAbstractChannel candidate : this.channels) {
                if (candidate.getGroup() != bus) continue;
                members.add(candidate);
            }
            for (LXAbstractChannel member : members) {
                this.mutableChannels.remove(member);
            }
            if (index > bus.getIndex()) {
                index -= members.size();
            }
            this.mutableChannels.add(index++, bus);
            for (LXAbstractChannel member : members) {
                this.mutableChannels.add(index++, member);
            }
        } else if (bus instanceof LXChannel) {
            LXChannel channel = (LXChannel)bus;
            if (channel.getGroup() != group) {
                if (channel.getGroup() != null) {
                    channel.getGroup().removeChannel(channel);
                }
                if (group != null) {
                    group.addChannel(channel);
                }
            }
            this.mutableChannels.remove(channel);
            this.mutableChannels.add(index, channel);
        } else {
            throw new IllegalStateException("Bus is neither a group nor a channel: " + bus);
        }
        this._reindexChannels();
        this.focusedChannel.setValue(focused.getIndex());
        this.focusedChannelAux.setValue(focusedAux.getIndex());
        for (Listener listener : this.listeners) {
            listener.channelMoved(this, bus);
            if (members == null) continue;
            for (LXAbstractChannel member : members) {
                listener.channelMoved(this, member);
            }
        }
    }

    public LXMixerEngine enableChannelCue(LXAbstractChannel channel, boolean isExclusive) {
        channel.cueActive.setValue(true);
        if (isExclusive) {
            for (LXAbstractChannel c : this.getChannels()) {
                if (channel == c) continue;
                c.cueActive.setValue(false);
            }
        }
        return this;
    }

    public LXMixerEngine enableChannelAux(LXAbstractChannel channel, boolean isExclusive) {
        channel.auxActive.setValue(true);
        if (isExclusive) {
            for (LXAbstractChannel c : this.getChannels()) {
                if (channel == c) continue;
                c.auxActive.setValue(false);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(LXEngine.Frame render, double deltaMs) {
        long channelStart = System.nanoTime();
        this.blendStackMain.initialize(this.backgroundBlack.getArray(), render.getMain());
        this.blendStackCue.initialize(this.backgroundBlack.getArray(), render.getCue());
        this.blendStackAux.initialize(this.backgroundBlack.getArray(), render.getAux());
        this.blendStackLeft.initialize(this.backgroundBlack.getArray(), this.blendBufferLeft.getArray());
        this.blendStackRight.initialize(this.backgroundBlack.getArray(), this.blendBufferRight.getArray());
        double crossfadeValue = this.crossfader.getValue();
        boolean leftBusActive = crossfadeValue < 1.0;
        boolean rightBusActive = crossfadeValue > 0.0;
        boolean cueBusActive = false;
        boolean auxBusActive = false;
        boolean isChannelMultithreaded = this.lx.engine.isChannelMultithreaded.isOn();
        boolean isPerformanceMode = this.lx.engine.performanceMode.isOn();
        if (isChannelMultithreaded) {
            Iterator<LXAbstractChannel> iterator;
            for (LXAbstractChannel channel : this.channels) {
                iterator = channel.thread;
                synchronized (iterator) {
                    channel.thread.signal.workDone = false;
                    channel.thread.deltaMs = deltaMs;
                    channel.thread.workReady = true;
                    channel.thread.notify();
                    if (!channel.thread.hasStarted) {
                        channel.thread.hasStarted = true;
                        channel.thread.start();
                    }
                }
            }
            for (LXAbstractChannel channel : this.mutableChannels) {
                iterator = channel.thread.signal;
                synchronized (iterator) {
                    while (!channel.thread.signal.workDone) {
                        try {
                            channel.thread.signal.wait();
                        }
                        catch (InterruptedException ix) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                    channel.thread.signal.workDone = false;
                }
            }
        } else {
            for (LXAbstractChannel channel : this.channels) {
                channel.loop(deltaMs);
            }
        }
        this.masterBus.loop(deltaMs);
        this.lx.engine.profiler.channelNanos = System.nanoTime() - channelStart;
        for (LXAbstractChannel channel : this.channels) {
            if (!(channel instanceof LXGroup) || !channel.isAnimating) continue;
            ((LXGroup)channel).afterLoop(deltaMs);
        }
        long nanoLimit = (long)((double)(1.0E9f / this.lx.engine.framesPerSecond.getValuef()) * 0.5);
        for (LXAbstractChannel channel : this.channels) {
            long renderNanos = channel.profiler.renderNanos();
            channel.performanceWarningFrameCount = renderNanos > nanoLimit ? ++channel.performanceWarningFrameCount : 0;
            channel.performanceWarning.setValue(channel.performanceWarningFrameCount >= 5);
        }
        boolean blendLeft = leftBusActive || this.cueA.isOn() || isPerformanceMode && this.auxA.isOn();
        boolean blendRight = rightBusActive || this.cueB.isOn() || isPerformanceMode && this.auxB.isOn();
        boolean leftExists = false;
        boolean rightExists = false;
        for (LXAbstractChannel channel : this.channels) {
            boolean isSubChannel;
            long blendStart = System.nanoTime();
            boolean bl = isSubChannel = channel.getGroup() != null;
            if (!isSubChannel) {
                double alpha;
                Object blendStack = null;
                switch (channel.crossfadeGroup.getEnum()) {
                    case A: {
                        leftExists = true;
                        blendStack = blendLeft ? this.blendStackLeft : null;
                        break;
                    }
                    case B: {
                        rightExists = true;
                        blendStack = blendRight ? this.blendStackRight : null;
                        break;
                    }
                    default: {
                        blendStack = this.blendStackMain;
                    }
                }
                if (blendStack != null && channel.enabled.isOn() && (alpha = channel.fader.getValue()) > 0.0) {
                    ((BlendStack)blendStack).blend(channel.blendMode.getObject(), channel.getColors(), alpha, channel.getModelView());
                }
            }
            if (channel.cueActive.isOn()) {
                cueBusActive = true;
                this.blendStackCue.blend((LXBlend)this.addBlend, channel.getColors(), 1.0, channel.getModelView());
            }
            if (isPerformanceMode && channel.auxActive.isOn()) {
                auxBusActive = true;
                this.blendStackAux.blend((LXBlend)this.addBlend, channel.getColors(), 1.0, channel.getModelView());
            }
            ((LXAbstractChannel.Profiler)channel.profiler).blendNanos = System.nanoTime() - blendStart;
        }
        if (this.cueA.isOn()) {
            this.blendStackCue.copyFrom(this.blendStackLeft);
            cueBusActive = true;
        } else if (this.cueB.isOn()) {
            this.blendStackCue.copyFrom(this.blendStackRight);
            cueBusActive = true;
        }
        if (isPerformanceMode) {
            if (this.auxA.isOn()) {
                this.blendStackAux.copyFrom(this.blendStackLeft);
                auxBusActive = true;
            } else if (this.auxB.isOn()) {
                this.blendStackAux.copyFrom(this.blendStackRight);
                auxBusActive = true;
            }
        }
        boolean leftContent = leftBusActive && leftExists;
        boolean rightContent = rightBusActive && rightExists;
        LXModel model = this.lx.getModel();
        if (leftContent && rightContent) {
            LXBlend blend = this.crossfaderBlendMode.getObject();
            this.blendStackLeft.transition(blend, this.blendStackRight.destination, crossfadeValue, model);
            this.blendStackMain.blend((LXBlend)this.addBlend, this.blendStackLeft, 1.0, model);
        } else if (leftContent) {
            this.blendStackMain.blend((LXBlend)this.addBlend, this.blendStackLeft, Math.min(1.0, 2.0 * (1.0 - crossfadeValue)), model);
        } else if (rightContent) {
            this.blendStackMain.blend((LXBlend)this.addBlend, this.blendStackRight, Math.min(1.0, 2.0 * crossfadeValue), model);
        }
        long effectStart = System.nanoTime();
        for (LXEffect effect : this.masterBus.getEffects()) {
            effect.setBuffer(render);
            effect.setModel(effect.getModelView());
            effect.loop(deltaMs);
        }
        ((LXBus.Profiler)this.masterBus.profiler).effectNanos = System.nanoTime() - effectStart;
        if (this.masterBus.previewMode.getEnum() == LXMasterBus.PreviewMode.POST) {
            double fader = this.masterBus.fader.getValue();
            if (fader == 0.0) {
                Arrays.fill(this.blendStackMain.output, -16777216);
            } else if (fader < 1.0) {
                int mult = LXColor.gray(100.0 * fader);
                int[] output = this.blendStackMain.output;
                for (int i = 0; i < output.length; ++i) {
                    output[i] = LXColor.multiply(output[i], mult, 256);
                }
            }
        }
        render.setCueOn(cueBusActive);
        render.setAuxOn(auxBusActive);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_CHANNELS, (JsonElement)LXSerializable.Utils.toArray(lx, this.mutableChannels));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        if (obj.has("_reset_")) {
            this.parameters.reset();
        }
        if (obj.has(KEY_CHANNELS)) {
            JsonArray channelsArray = obj.getAsJsonArray(KEY_CHANNELS);
            for (JsonElement channelElement : channelsArray) {
                this.loadChannel(channelElement.getAsJsonObject());
            }
        }
        super.load(lx, obj);
        for (LXAbstractChannel channel : this.channels) {
            LXPattern pattern;
            if (!(channel instanceof LXChannel) || (pattern = ((LXChannel)channel).getActivePattern()) == null) continue;
            pattern.activate(patternFriendAccess);
        }
    }

    @Override
    public void dispose() {
        ArrayList<LXAbstractChannel> toRemove = new ArrayList<LXAbstractChannel>(this.channels);
        Collections.reverse(toRemove);
        for (LXAbstractChannel channel : toRemove) {
            this.removeChannel(channel);
        }
        this.masterBus.dispose();
        super.dispose();
    }

    public void clear() {
        for (int i = this.mutableChannels.size() - 1; i >= 0; --i) {
            this.removeChannel(this.mutableChannels.get(i));
        }
    }

    public void loadChannel(JsonObject channelObj) {
        this.loadChannel(channelObj, -1);
    }

    public void loadChannel(JsonObject channelObj, int index) {
        String channelClass = channelObj.get("class").getAsString();
        boolean isGroup = channelObj.has("isGroup");
        LXAbstractChannel channel = isGroup || channelClass.equals("heronarts.lx.mixer.LXGroup") || channelClass.equals("heronarts.lx.LXGroup") ? this.addGroup(index) : this.addChannel(index);
        channel.load(this.lx, channelObj);
    }

    private class BlendStack {
        private int[] destination;
        private int[] output;

        private BlendStack() {
        }

        void initialize(int[] destination, int[] output) {
            this.destination = destination;
            this.output = output;
            if (this.destination == this.output) {
                LX.error(new Exception("BlendStack initialized with the same destination/output"));
            } else {
                System.arraycopy(this.destination, 0, this.output, 0, this.destination.length);
                this.destination = this.output;
            }
        }

        void blend(LXBlend blend, BlendStack that, double alpha, LXModel model) {
            this.blend(blend, that.destination, alpha, model);
        }

        void blend(LXBlend blend, int[] src, double alpha, LXModel model) {
            blend.blend(this.destination, src, alpha, this.output, model);
            this.destination = this.output;
        }

        void transition(LXBlend blend, int[] src, double lerp, LXModel model) {
            blend.lerp(this.destination, src, lerp, this.output, model);
            this.destination = this.output;
        }

        void copyFrom(BlendStack that) {
            System.arraycopy(that.destination, 0, this.output, 0, that.destination.length);
            this.destination = this.output;
        }
    }

    public static interface Listener {
        public void channelAdded(LXMixerEngine var1, LXAbstractChannel var2);

        public void channelRemoved(LXMixerEngine var1, LXAbstractChannel var2);

        public void channelMoved(LXMixerEngine var1, LXAbstractChannel var2);
    }

    public static class PatternFriendAccess {
        private PatternFriendAccess() {
        }
    }
}

