/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.model.LXModelBuilder;
import heronarts.lx.model.LXNormalizationBounds;
import heronarts.lx.model.LXPoint;
import heronarts.lx.model.LXView;
import heronarts.lx.output.LXOutput;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LXModel
extends LXNormalizationBounds
implements LXSerializable {
    private Map<GeometryFunction, float[]> geometryCache = new HashMap<GeometryFunction, float[]>();
    public final LXMatrix transform = new LXMatrix();
    public final LXPoint[] points;
    private final List<LXPoint> pointList;
    public final Map<String, String> metaData;
    public final LXModel[] children;
    private final Map<String, List<LXModel>> childDict = new HashMap<String, List<LXModel>>();
    private final Map<String, List<LXModel>> subDict = new HashMap<String, List<LXModel>>();
    final List<LXView> derivedViews = new ArrayList<LXView>();
    public final List<LXOutput> outputs;
    public final List<String> tags;
    private LXModel parent;
    private int generation = 0;
    public final int size;
    @Deprecated
    public final LXVector center = new LXVector(0.0f, 0.0f, 0.0f);
    @Deprecated
    public final LXVector average = new LXVector(0.0f, 0.0f, 0.0f);
    public float ax;
    public float ay;
    public float az;
    public float rMin;
    public float rMax;
    public float rRange;
    public float rcMin;
    public float rcMax;
    public float rcRange;
    public float azimuth;
    public float elevation;
    private LXNormalizationBounds normalizationBounds;
    private static final List<LXModel> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private final List<Listener> listeners = new ArrayList<Listener>();

    public LXModel() {
        this(new ArrayList<LXPoint>());
    }

    public LXModel(List<LXPoint> points) {
        this(points, new LXModel[0]);
    }

    public LXModel(List<LXPoint> points, String ... tags) {
        this(points, new LXModel[0], null, null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, Map<String, String> metaData, String ... tags) {
        this(points, new LXModel[0], metaData, tags);
    }

    public LXModel(List<LXPoint> points, LXModel[] children) {
        this(points, children, "model");
    }

    public LXModel(List<LXPoint> points, LXModel[] children, String ... tags) {
        this(points, children, null, null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, String ... tags) {
        this(points, children, bounds, null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, Map<String, String> metaData, String ... tags) {
        this(points, children, null, metaData, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, Map<String, String> metaData, List<String> tags) {
        this(points, children, null, metaData, tags);
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, Map<String, String> metaData, List<String> tags) {
        this.tags = LXModel.validateTags(tags);
        this.pointList = Collections.unmodifiableList(new ArrayList<LXPoint>(points));
        this.setNormalizationBounds(bounds != null ? bounds : this);
        this.children = (LXModel[])children.clone();
        this.addChildren(this.children);
        this.points = this.pointList.toArray(new LXPoint[0]);
        this.size = this.points.length;
        this.outputs = Collections.unmodifiableList(new ArrayList());
        HashMap<String, String> mutableMetadata = new HashMap<String, String>();
        if (metaData != null) {
            mutableMetadata.putAll(metaData);
        }
        this.metaData = Collections.unmodifiableMap(mutableMetadata);
        this.recomputeGeometry();
    }

    public LXModel(LXModel[] children) {
        this(children, (LXNormalizationBounds)null);
    }

    public LXModel(LXModel[] children, LXNormalizationBounds bounds) {
        this(children, bounds, "model");
    }

    public LXModel(LXModel[] children, LXNormalizationBounds bounds, String ... tags) {
        this(children, bounds, Arrays.asList(tags));
    }

    private LXModel(LXModel[] children, LXNormalizationBounds bounds, List<String> tags) {
        this.tags = LXModel.validateTags(tags);
        ArrayList<LXPoint> _points = new ArrayList<LXPoint>();
        for (LXModel child : children) {
            for (LXPoint p : child.points) {
                _points.add(p);
            }
        }
        this.setNormalizationBounds(bounds != null ? bounds : this);
        this.children = (LXModel[])children.clone();
        this.addChildren(this.children);
        this.points = _points.toArray(new LXPoint[0]);
        this.pointList = Collections.unmodifiableList(_points);
        this.size = _points.size();
        this.outputs = Collections.unmodifiableList(new ArrayList());
        this.metaData = Collections.unmodifiableMap(new HashMap());
        this.recomputeGeometry();
    }

    @Deprecated
    public LXModel(LXModelBuilder builder) {
        this(builder, true);
    }

    @Deprecated
    protected LXModel(LXModelBuilder builder, boolean isRoot) {
        if (builder.model != null) {
            throw new IllegalStateException("LXModelBuilder may only be used once: " + builder);
        }
        this.tags = LXModel.validateTags(builder.tags);
        this.children = new LXModel[builder.children.size()];
        ArrayList<LXPoint> _points = new ArrayList<LXPoint>(builder.points);
        int ci = 0;
        for (LXModelBuilder child : builder.children) {
            this.children[ci++] = new LXModel(child, false);
            for (LXPoint p : child.points) {
                _points.add(p);
            }
        }
        this.addChildren(this.children);
        if (isRoot) {
            this.setNormalizationBounds(this);
        }
        this.points = _points.toArray(new LXPoint[0]);
        this.pointList = Collections.unmodifiableList(_points);
        this.size = this.points.length;
        this.outputs = Collections.unmodifiableList(new ArrayList<LXOutput>(builder.outputs));
        this.metaData = Collections.unmodifiableMap(new HashMap());
        this.recomputeGeometry();
        if (isRoot) {
            this.reindexPoints();
            this.normalizePoints();
        }
        builder.model = this;
    }

    public static List<String> validateTags(List<String> tags) {
        Objects.requireNonNull(tags, "May not construct LXModel with null tags");
        ArrayList<String> _tags = new ArrayList<String>(tags.size());
        for (String tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException("May not pass null tag to LXModel");
            }
            if ((tag = tag.trim()).isEmpty()) {
                throw new IllegalArgumentException("May not pass empty string tag to LXModel");
            }
            if (!Tag.isValid(tag)) {
                throw new IllegalArgumentException("May not pass invalid tag to LXModel: " + tag);
            }
            if (_tags.contains(tag)) continue;
            _tags.add(tag);
        }
        return Collections.unmodifiableList(_tags);
    }

    private void setNormalizationBounds(LXNormalizationBounds normalizationBounds) {
        this.normalizationBounds = normalizationBounds;
        if (this.children != null) {
            for (LXModel child : this.children) {
                child.setNormalizationBounds(normalizationBounds);
            }
        }
    }

    public LXNormalizationBounds getNormalizationBounds() {
        return this.normalizationBounds;
    }

    public LXModel getRoot() {
        LXModel root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public LXModel getParent() {
        return this.parent;
    }

    public boolean contains(LXModel descendant) {
        for (LXModel child : this.children) {
            if (child != descendant) continue;
            return true;
        }
        for (LXModel child : this.children) {
            if (!child.contains(descendant)) continue;
            return true;
        }
        return false;
    }

    public String getPath() {
        String firstTag;
        LXModel parent = this.parent;
        boolean hasTag = !this.tags.isEmpty();
        String string = firstTag = hasTag ? this.tags.get(0) : "";
        if (parent == null) {
            return "/" + firstTag;
        }
        int index = 0;
        if (hasTag) {
            for (LXModel child : parent.childDict.get(firstTag)) {
                if (child == this) break;
                ++index;
            }
        } else {
            for (LXModel child : parent.children) {
                if (child == this) break;
                ++index;
            }
        }
        return parent.getPath() + "/" + firstTag + "[" + index + "]";
    }

    public LXModel reindexPoints() {
        int index = 0;
        for (LXPoint p : this.points) {
            p.index = index++;
        }
        return this;
    }

    private void addChildren(LXModel[] children) {
        for (LXModel child : children) {
            child.parent = this;
            child.setNormalizationBounds(this.normalizationBounds);
        }
        this.addSubmodels(children, this.childDict, false);
        this.addSubmodels(children, this.subDict, true);
    }

    private void addSubmodels(LXModel[] submodels, Map<String, List<LXModel>> dict, boolean recurse) {
        for (LXModel submodel : submodels) {
            for (String tag : submodel.tags) {
                List<LXModel> sub = dict.get(tag);
                if (sub == null) {
                    sub = new ArrayList<LXModel>();
                    dict.put(tag, sub);
                }
                sub.add(submodel);
            }
            if (!recurse) continue;
            this.addSubmodels(submodel.children, dict, recurse);
        }
    }

    public List<LXModel> children(String tag) {
        List<LXModel> children = this.childDict.get(tag);
        return children == null ? EMPTY_LIST : children;
    }

    public List<LXModel> sub(String tag) {
        List<LXModel> sub = this.subDict.get(tag);
        return sub == null ? EMPTY_LIST : sub;
    }

    public LXModel ancestor(String tag) {
        LXModel parent;
        for (parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.tags.contains(tag)) continue;
            return parent;
        }
        return parent;
    }

    public String meta(String key) {
        return this.metaData.get(key);
    }

    public final LXModel addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXModel.Listener: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public final LXModel removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXModel.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXModel update() {
        return this.update(true, false);
    }

    public LXModel update(boolean normalize) {
        return this.update(normalize, false);
    }

    public LXModel update(boolean normalize, boolean recurse) {
        if (recurse) {
            for (LXModel submodel : this.children) {
                submodel.update(false, true);
            }
        }
        this.recomputeGeometry();
        if (normalize) {
            this.normalizePoints();
        }
        for (Map.Entry entry : this.geometryCache.entrySet()) {
            this.computeGeometry((GeometryFunction)entry.getKey(), (float[])entry.getValue());
        }
        for (LXView lXView : this.derivedViews) {
            for (LXPoint p : this.points) {
                LXPoint clone = lXView.clonedPoints.get(p.index);
                if (clone == null) continue;
                clone.set(p);
            }
            boolean normalizeView = normalize && lXView.normalization == LXView.Normalization.RELATIVE;
            lXView.update(normalizeView, recurse);
        }
        this.bang();
        for (LXView lXView : this.derivedViews) {
            lXView.bang();
        }
        return this;
    }

    public LXModel bang() {
        ++this.generation;
        for (Listener listener : this.listeners) {
            listener.modelGenerationUpdated(this);
        }
        return this;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int[] toIndexBuffer() {
        return this.toIndexBuffer(0, this.points.length);
    }

    public int[] toIndexBuffer(int offset, int length) {
        if (offset < 0 || offset + length > this.points.length) {
            throw new IllegalArgumentException("Index buffer cannot exceed points array length - offset:" + offset + " length:" + length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Index buffer length cannot be negative: " + length);
        }
        int[] indexBuffer = new int[length];
        for (int i = 0; i < length; ++i) {
            indexBuffer[i] = this.points[offset + i].index;
        }
        return indexBuffer;
    }

    private void recomputeGeometry() {
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        float xMin = 0.0f;
        float xMax = 0.0f;
        float yMin = 0.0f;
        float yMax = 0.0f;
        float zMin = 0.0f;
        float zMax = 0.0f;
        float rMin = 0.0f;
        float rMax = 0.0f;
        boolean firstPoint = true;
        for (LXPoint p : this.points) {
            ax += p.x;
            ay += p.y;
            az += p.z;
            if (firstPoint) {
                xMin = xMax = p.x;
                yMin = yMax = p.y;
                zMin = zMax = p.z;
                rMin = rMax = p.r;
                firstPoint = false;
                continue;
            }
            if (p.x < xMin) {
                xMin = p.x;
            }
            if (p.x > xMax) {
                xMax = p.x;
            }
            if (p.y < yMin) {
                yMin = p.y;
            }
            if (p.y > yMax) {
                yMax = p.y;
            }
            if (p.z < zMin) {
                zMin = p.z;
            }
            if (p.z > zMax) {
                zMax = p.z;
            }
            if (p.r < rMin) {
                rMin = p.r;
            }
            if (!(p.r > rMax)) continue;
            rMax = p.r;
        }
        this.ax = ax / (float)Math.max(1, this.points.length);
        this.ay = ay / (float)Math.max(1, this.points.length);
        this.az = az / (float)Math.max(1, this.points.length);
        this.xMin = xMin;
        this.xMax = xMax;
        this.xRange = xMax - xMin;
        this.yMin = yMin;
        this.yMax = yMax;
        this.yRange = yMax - yMin;
        this.zMin = zMin;
        this.zMax = zMax;
        this.zRange = zMax - zMin;
        this.rMin = rMin;
        this.rMax = rMax;
        this.rRange = rMax - rMin;
        this.cx = xMin + 0.5f * this.xRange;
        this.cy = yMin + 0.5f * this.yRange;
        this.cz = zMin + 0.5f * this.zRange;
        this.center.set(this.cx, this.cy, this.cz);
        this.average.set(this.ax, this.ay, this.az);
        this.azimuth = (float)((Math.PI * 2 + Math.atan2(this.cx, this.cz)) % (Math.PI * 2));
        this.elevation = (float)Math.atan2(this.cy, Math.sqrt(this.cx * this.cx + this.cz * this.cz));
    }

    public LXModel normalizePoints() {
        for (LXPoint p : this.points) {
            p.normalize(this.normalizationBounds, this);
        }
        float rcMin = 0.0f;
        float rcMax = 0.0f;
        boolean firstPoint = true;
        for (LXPoint p : this.points) {
            if (firstPoint) {
                rcMin = p.rc;
                rcMax = p.rc;
                firstPoint = false;
                continue;
            }
            if (p.rc < rcMin) {
                rcMin = p.rc;
            }
            if (!(p.rc > rcMax)) continue;
            rcMax = p.rc;
        }
        this.rcMin = rcMin;
        this.rcMax = rcMax;
        this.rcRange = rcMax - rcMin;
        if (rcMax == 0.0f) {
            for (LXPoint p : this.points) {
                p.rcn = 0.5f;
            }
        } else {
            for (LXPoint p : this.points) {
                p.rcn = p.rc / this.rcMax;
            }
        }
        return this;
    }

    public List<LXPoint> getPoints() {
        return this.pointList;
    }

    public float[] getGeometry(Geometry geometry) {
        return this.getGeometry(geometry.function);
    }

    public float[] getGeometry(GeometryFunction function) {
        float[] arr = null;
        LXModel root = this.getRoot();
        if (root.normalizationBounds == this.normalizationBounds) {
            arr = root.geometryCache.get(function);
        }
        if (arr == null && (arr = this.geometryCache.get(function)) == null) {
            arr = this.computeGeometry(function);
            this.geometryCache.put(function, arr);
        }
        return arr;
    }

    public float[] computeGeometry(GeometryFunction function) {
        return this.computeGeometry(function, new float[this.getRoot().size]);
    }

    private float[] computeGeometry(GeometryFunction function, float[] arr) {
        for (LXPoint p : this.points) {
            arr[p.index] = function.compute(this, p);
        }
        return arr;
    }

    @Override
    public void save(LX lx, JsonObject object) {
        object.addProperty("class", this.getClass().getName());
    }

    @Override
    public void load(LX lx, JsonObject object) {
    }

    public void dispose() {
        while (!this.derivedViews.isEmpty()) {
            this.derivedViews.get(this.derivedViews.size() - 1).dispose();
        }
        for (LXModel child : this.children) {
            child.dispose();
        }
        this.listeners.clear();
    }

    public void debugPrint(PrintStream out) {
        this._debugPrint(out, "+ ");
    }

    private void _debugPrint(PrintStream out, String indent) {
        out.print(indent + "[");
        boolean first = true;
        for (String string : this.tags) {
            if (first) {
                first = false;
            } else {
                out.print(", ");
            }
            out.print(string);
        }
        out.print("] {");
        first = true;
        for (Map.Entry entry : this.metaData.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.print(", ");
            }
            out.print((String)entry.getKey() + ": " + (String)entry.getValue());
        }
        out.println("}");
        for (Iterator<Object> iterator : this.children) {
            super._debugPrint(out, "  " + indent);
        }
    }

    public static class Tag {
        public static final String MODEL = "model";
        public static final String VIEW = "view";
        public static final String GRID = "grid";
        public static final String ROW = "row";
        public static final String COLUMN = "column";
        public static final String STRIP = "strip";
        public static final String POINT = "point";
        public static final String POINTS = "points";
        public static final String ARC = "arc";
        public static final String SPIRAL = "spiral";
        public static final String VALID_TAG_REGEX = "[A-Za-z0-9_\\.\\-/]+";
        public static final String VALID_TEXT_FIELD_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.-/ ,";

        public static boolean isValid(String tag) {
            return tag.matches(VALID_TAG_REGEX);
        }
    }

    public static interface GeometryFunction {
        public float compute(LXModel var1, LXPoint var2);
    }

    public static interface Listener {
        public void modelGenerationUpdated(LXModel var1);
    }

    public static enum Geometry {
        RADIUS_3D_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, p.zn, 0.5f, 0.5f, 0.5f)),
        RADIUS_XY_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, 0.5f, 0.5f)),
        RADIUS_XZ_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.zn, 0.5f, 0.5f)),
        RADIUS_YZ_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.yn, p.zn, 0.5f, 0.5f)),
        RADIUS_3D_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, p.zn, 0.0f, 0.0f, 0.0f)),
        RADIUS_XY_ORIGIN_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, 0.0f, 0.0f)),
        RADIUS_XZ_ORIGIN_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.zn, 0.0f, 0.0f)),
        RADIUS_YZ_ORIGIN_NORMALIZED((model, p) -> LXUtils.distf(p.yn, p.zn, 0.0f, 0.0f)),
        RADIUS_3D_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.x, p.y, p.z, 0.0f, 0.0f, 0.0f)),
        RADIUS_XY_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.x, p.y, 0.0f, 0.0f)),
        RADIUS_XZ_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.x, p.z, 0.0f, 0.0f)),
        RADIUS_YZ_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.y, p.z, 0.0f, 0.0f)),
        AZIMUTH_XZ_CENTER_NORMALIZED((model, p) -> LXUtils.atan2pf(p.xn - 0.5f, p.zn - 0.5f)),
        ELEVATION_XZ_CENTER_NORMALIZED((model, p) -> (float)Math.atan2(p.yn - 0.5f, LXUtils.distf(p.xn, p.zn, 0.5f, 0.5f))),
        AZIMUTH_XZ_ORIGIN_ABSOLUTE((model, p) -> LXUtils.atan2pf(p.x, p.z)),
        ELEVATION_XZ_ORIGIN_ABSOLUTE((model, p) -> (float)Math.atan2(p.y, LXUtils.distf(p.x, p.z, 0.0f, 0.0f))),
        THETA_XY_ORIGIN_ABSOLUTE((model, p) -> LXUtils.atan2pf(p.y, p.x)),
        THETA_XY_CENTER_NORMALIZED((model, p) -> LXUtils.atan2pf(p.yn - 0.5f, p.xn - 0.5f));

        public final GeometryFunction function;

        private Geometry(GeometryFunction compute) {
            this.function = compute;
        }
    }
}

