/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LXView
extends LXModel {
    private static final String GROUP_SEPARATOR = "\\s*;\\s*";
    private static final String SELECTOR_SEPARATOR = "\\s*,\\s*";
    private static final char GROUP_OPERATOR = '*';
    private final LXModel model;
    final Normalization normalization;
    final Map<Integer, LXPoint> clonedPoints;

    public static LXView create(LXModel model, String viewSelector, Normalization normalization) {
        ParseState state = new ParseState(model);
        for (String groupSelector : viewSelector.trim().split(GROUP_SEPARATOR)) {
            LXView.parseGroup(state, groupSelector);
        }
        HashMap<Integer, LXPoint> clonedPoints = new HashMap<Integer, LXPoint>();
        LXModel[] views = new LXView[state.groups.size()];
        ArrayList<LXPoint> allPoints = new ArrayList<LXPoint>();
        int g = 0;
        for (List group : state.groups) {
            ArrayList<LXPoint> groupPoints = new ArrayList<LXPoint>();
            LXModel[] groupChildren = new LXModel[group.size()];
            int c = 0;
            for (LXModel sub : group) {
                for (LXPoint p : sub.points) {
                    if (clonedPoints.containsKey(p.index)) continue;
                    LXPoint copy = new LXPoint(p);
                    clonedPoints.put(p.index, copy);
                    groupPoints.add(copy);
                    allPoints.add(copy);
                }
                groupChildren[c++] = LXView.cloneModel(clonedPoints, sub);
            }
            views[g++] = new LXView(model, normalization, clonedPoints, groupPoints, groupChildren);
        }
        if (views.length == 0) {
            return new LXView(model, normalization, clonedPoints, new ArrayList<LXPoint>(), new LXModel[0]);
        }
        if (views.length == 1) {
            return views[0];
        }
        return new LXView(model, Normalization.ABSOLUTE, clonedPoints, allPoints, views);
    }

    private static void parseGroup(ParseState state, String groupSelector) {
        if ((groupSelector = groupSelector.trim()).isEmpty()) {
            return;
        }
        int subgroup = groupSelector.lastIndexOf(42);
        if (subgroup >= 0) {
            String rootSelector = groupSelector.substring(0, subgroup).replace('*', ' ').trim();
            String subSelector = groupSelector.substring(subgroup + 1).trim();
            ArrayList<LXModel> groupRoots = new ArrayList<LXModel>();
            boolean terminal = subSelector.isEmpty();
            LXView.parseGroupSelector(state, state.model, groupRoots, rootSelector, terminal);
            for (LXModel groupRoot : groupRoots) {
                ArrayList<LXModel> group = new ArrayList<LXModel>();
                if (terminal) {
                    group.add(groupRoot);
                    state.groups.add(group);
                    continue;
                }
                LXView.parseGroupSelector(state, groupRoot, group, subSelector, true);
                if (group.isEmpty()) continue;
                state.groups.add(group);
            }
        } else {
            ArrayList<LXModel> group = new ArrayList<LXModel>();
            LXView.parseGroupSelector(state, state.model, group, groupSelector, true);
            if (!group.isEmpty()) {
                state.groups.add(group);
            }
        }
    }

    private static void parseGroupSelector(ParseState state, LXModel root, List<LXModel> group, String groupSelector, boolean terminal) {
        for (String selector : groupSelector.split(SELECTOR_SEPARATOR)) {
            LXView.parseSubselector(state, root, group, selector, terminal);
        }
    }

    private static void parseSubselector(ParseState state, LXModel root, List<LXModel> group, String selector, boolean terminal) {
        if ((selector = selector.trim()).isEmpty()) {
            return;
        }
        ArrayList<LXModel> candidates = new ArrayList<LXModel>();
        candidates.add(root);
        ArrayList<LXModel> searchSpace = new ArrayList<LXModel>();
        ArrayList<LXModel> intersect = new ArrayList<LXModel>();
        boolean directChildMode = false;
        boolean andMode = false;
        for (String part : selector.split("\\s+")) {
            String tag = part.trim();
            if (">".equals(tag)) {
                directChildMode = true;
                continue;
            }
            if ("&".equals(tag)) {
                andMode = true;
                continue;
            }
            if (andMode) {
                intersect.clear();
                intersect.addAll(candidates);
            } else {
                searchSpace.clear();
                searchSpace.addAll(candidates);
            }
            candidates.clear();
            int startIndex = 0;
            int endIndex = -1;
            int increment = 1;
            int rangeStart = tag.indexOf(91);
            int rangeEnd = tag.indexOf(93);
            if (rangeStart >= 0) {
                if (rangeEnd < 0 || rangeEnd <= rangeStart) {
                    LX.error("Poorly formatted view selection range: " + tag);
                } else {
                    Object range = tag.substring(rangeStart + 1, rangeEnd).trim();
                    tag = tag.substring(0, rangeStart);
                    if ("even".equals(range)) {
                        increment = 2;
                    } else if ("odd".equals(range)) {
                        startIndex = 1;
                        increment = 2;
                    } else {
                        int dash;
                        boolean hasIncrement;
                        int colon = ((String)range).indexOf(":");
                        boolean bl = hasIncrement = colon >= 0;
                        if (hasIncrement) {
                            try {
                                increment = Integer.parseInt(((String)range).substring(colon + 1).trim());
                                range = ((String)range).substring(0, colon).trim();
                            }
                            catch (NumberFormatException nfx) {
                                LX.error("Bad number in view selection range: " + tag);
                            }
                        }
                        if ((dash = ((String)range).indexOf(45)) >= 0) {
                            try {
                                startIndex = Integer.parseInt(((String)range).substring(0, dash).trim());
                                endIndex = Integer.parseInt(((String)range).substring(dash + 1).trim());
                            }
                            catch (NumberFormatException nfx) {
                                LX.error("Bad number in view selection range: " + tag);
                            }
                        } else {
                            try {
                                if (hasIncrement) {
                                    if (!((String)range).isEmpty()) {
                                        startIndex = Integer.parseInt((String)range);
                                    }
                                } else {
                                    startIndex = endIndex = Integer.parseInt((String)range);
                                }
                            }
                            catch (NumberFormatException nfx) {
                                LX.error("Bad number in view selection range: " + tag);
                            }
                        }
                    }
                }
            }
            for (LXModel search : searchSpace) {
                List<LXModel> subs = andMode ? search.sub(tag) : (directChildMode ? search.children(tag) : search.sub(tag));
                if (increment < 1) {
                    increment = 1;
                }
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (endIndex < 0 || endIndex >= subs.size()) {
                    endIndex = subs.size() - 1;
                }
                for (int i = startIndex; i <= endIndex; i += increment) {
                    LXModel sub = subs.get(i);
                    if (state.uniqueSubmodels.contains(sub)) continue;
                    candidates.add(subs.get(i));
                }
            }
            if (andMode) {
                Iterator iter = candidates.iterator();
                while (iter.hasNext()) {
                    LXModel candidate = (LXModel)iter.next();
                    if (intersect.contains(candidate)) continue;
                    iter.remove();
                }
            }
            directChildMode = false;
            andMode = false;
        }
        if (terminal) {
            LXView.addGroupCandidates(state, group, candidates);
        } else {
            group.addAll(candidates);
        }
    }

    private static void addGroupCandidates(ParseState state, List<LXModel> group, List<LXModel> candidates) {
        for (LXModel candidate : candidates) {
            if (state.uniqueSubmodels.contains(candidate)) continue;
            boolean isDescendant = false;
            Iterator iter = state.uniqueSubmodels.iterator();
            while (!isDescendant && iter.hasNext()) {
                LXModel submodel = (LXModel)iter.next();
                if (submodel.contains(candidate)) {
                    isDescendant = true;
                    continue;
                }
                if (!candidate.contains(submodel)) continue;
                iter.remove();
                for (List existingGroup : state.groups) {
                    existingGroup.remove(submodel);
                }
            }
            if (isDescendant) continue;
            state.uniqueSubmodels.add(candidate);
            group.add(candidate);
        }
    }

    private static LXModel cloneModel(Map<Integer, LXPoint> clonedPoints, LXModel model) {
        ArrayList<LXPoint> points = new ArrayList<LXPoint>(model.points.length);
        for (LXPoint p : model.points) {
            points.add(clonedPoints.get(p.index));
        }
        LXModel[] children = new LXModel[model.children.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = LXView.cloneModel(clonedPoints, model.children[i]);
        }
        return new LXModel(points, children, model.getNormalizationBounds(), model.metaData, model.tags);
    }

    private LXView(LXModel model, Normalization normalization, Map<Integer, LXPoint> clonedPoints, List<LXPoint> points, LXModel[] children) {
        super(points, children, normalization == Normalization.ABSOLUTE ? model.getNormalizationBounds() : null, "view");
        this.model = model;
        this.normalization = normalization;
        this.clonedPoints = Collections.unmodifiableMap(clonedPoints);
        model.derivedViews.add(this);
        if (normalization == Normalization.RELATIVE) {
            this.normalizePoints();
        }
    }

    @Override
    public void dispose() {
        this.model.derivedViews.remove(this);
        super.dispose();
    }

    private static class ParseState {
        private final LXModel model;
        private final List<List<LXModel>> groups = new ArrayList<List<LXModel>>();
        private final List<LXModel> uniqueSubmodels = new ArrayList<LXModel>();

        private ParseState(LXModel model) {
            this.model = model;
        }
    }

    public static enum Normalization {
        RELATIVE("Normalize to View"),
        ABSOLUTE("Preserve Absolute");

        public final String description;

        private Normalization(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

