/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.transform.LXVector;
import java.util.ArrayList;
import java.util.List;

public class StripModel
extends LXModel {
    public final Metrics metrics;
    public final int length;

    public StripModel(Metrics metrics) {
        super(StripModel.makePoints(metrics), "strip");
        this.metrics = metrics;
        this.length = metrics.length;
    }

    public StripModel(int length) {
        this(new Metrics(length));
    }

    private static List<LXPoint> makePoints(Metrics metrics) {
        ArrayList<LXPoint> points = new ArrayList<LXPoint>(metrics.length);
        for (int i = 0; i < metrics.length; ++i) {
            points.add(new LXPoint(((Metrics)metrics).origin.x + (float)i * ((Metrics)metrics).spacing.x, ((Metrics)metrics).origin.y + (float)i * ((Metrics)metrics).spacing.y, ((Metrics)metrics).origin.z + (float)i * ((Metrics)metrics).spacing.z));
        }
        return points;
    }

    public static class Metrics {
        public final int length;
        private final LXVector origin = new LXVector(0.0f, 0.0f, 0.0f);
        private final LXVector spacing = new LXVector(1.0f, 0.0f, 0.0f);

        public Metrics(int length) {
            this.length = length;
        }

        public Metrics setOrigin(float x, float y, float z) {
            this.origin.set(x, y, z);
            return this;
        }

        public Metrics setOrigin(LXVector v) {
            this.origin.set(v);
            return this;
        }

        public Metrics setSpacing(float x, float y, float z) {
            this.spacing.set(x, y, z);
            return this;
        }

        public Metrics setSpacing(LXVector v) {
            this.spacing.set(v);
            return this;
        }
    }
}

