/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulation;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.modulation.LXParameterModulation;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameterListener;

public class LXTriggerModulation
extends LXParameterModulation {
    public final BooleanParameter source;
    public final BooleanParameter target;
    private final boolean sourceMomentary;
    private final boolean targetMomentary;
    public final EnumParameter<ToggleMode> toggleMode = new EnumParameter<ToggleMode>("Toggle Mode", ToggleMode.DIRECT).setDescription("How toggle to toggle actions are mapped");
    public final EnumParameter<MomentaryToggleMode> momentaryToggleMode = new EnumParameter<MomentaryToggleMode>("Momentary \u2192 Toggle Mode", MomentaryToggleMode.TOGGLE).setDescription("How momentary to toggle actions are mapped");
    public final EnumParameter<ToggleMomentaryMode> toggleMomentaryMode = new EnumParameter<ToggleMomentaryMode>("Toggle \u2192 Momentary Mode", ToggleMomentaryMode.ON).setDescription("How toggle to momentary actions are mapped");
    private final LXParameterListener sourceListener;

    public LXTriggerModulation(LX lx, LXModulationEngine scope, JsonObject obj) throws LXParameterModulation.ModulationException {
        this(scope, (BooleanParameter)LXTriggerModulation.getParameter(lx, scope, obj.getAsJsonObject("source")), (BooleanParameter)LXTriggerModulation.getParameter(lx, scope, obj.getAsJsonObject("target")));
    }

    public LXTriggerModulation(LXModulationEngine scope, BooleanParameter source, BooleanParameter target) throws LXParameterModulation.ModulationException {
        super(scope, source, target);
        this.source = source;
        this.target = target;
        this.sourceMomentary = source.getMode() == BooleanParameter.Mode.MOMENTARY;
        this.targetMomentary = target.getMode() == BooleanParameter.Mode.MOMENTARY;
        this.setParent(scope);
        this.addParameter("toggleMode", this.toggleMode);
        this.addParameter("momentaryToggleMode", this.momentaryToggleMode);
        this.addParameter("toggleMomentaryMode", this.toggleMomentaryMode);
        this.sourceListener = p -> {
            if (!this.enabled.isOn()) {
                return;
            }
            if (this.sourceMomentary) {
                if (this.targetMomentary) {
                    this.target.setValue(this.source.isOn());
                } else if (this.source.isOn()) {
                    this.momentaryToggleMode.getEnum().onMomentary(this.target);
                } else {
                    this.momentaryToggleMode.getEnum().onRelease(this.target);
                }
            } else if (this.targetMomentary) {
                if (this.toggleMomentaryMode.getEnum().shouldTrigger(this.source)) {
                    this.target.setValue(true);
                }
            } else {
                this.toggleMode.getEnum().onToggle(this.source, this.target);
            }
        };
        this.source.addListener(this.sourceListener);
    }

    public EnumParameter<?> getModeParameter() {
        if (this.sourceMomentary) {
            if (this.targetMomentary) {
                return null;
            }
            return this.momentaryToggleMode;
        }
        if (this.targetMomentary) {
            return this.toggleMomentaryMode;
        }
        return this.toggleMode;
    }

    @Override
    public String getPath() {
        return "trigger/" + (this.index + 1);
    }

    @Override
    public void dispose() {
        this.source.removeListener(this.sourceListener);
        super.dispose();
    }

    public static enum ToggleMode {
        DIRECT("Direct"),
        INVERT("Invert"),
        ALWAYS_ON("Any Change \u2192 On"),
        ALWAYS_OFF("Any Change \u2192 Off"),
        ALWAYS_TOGGLE("Any Change \u2192 Toggle"),
        ON_ON("On \u2192 On"),
        ON_OFF("On \u2192 Off"),
        ON_TOGGLE("On \u2192 Toggle"),
        OFF_ON("Off \u2192 On"),
        OFF_OFF("Off \u2192 Off"),
        OFF_TOGGLE("Off \u2192 Toggle");

        public final String label;

        private ToggleMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        private void onToggle(BooleanParameter source, BooleanParameter target) {
            switch (this) {
                case DIRECT: {
                    target.setValue(source.isOn());
                    break;
                }
                case INVERT: {
                    target.setValue(!source.isOn());
                    break;
                }
                case ALWAYS_ON: {
                    target.setValue(true);
                    break;
                }
                case ALWAYS_OFF: {
                    target.setValue(false);
                    break;
                }
                case ALWAYS_TOGGLE: {
                    target.toggle();
                    break;
                }
                case ON_ON: {
                    if (!source.isOn()) break;
                    target.setValue(true);
                    break;
                }
                case ON_OFF: {
                    if (!source.isOn()) break;
                    target.setValue(false);
                    break;
                }
                case ON_TOGGLE: {
                    if (!source.isOn()) break;
                    target.toggle();
                    break;
                }
                case OFF_ON: {
                    if (source.isOn()) break;
                    target.setValue(true);
                    break;
                }
                case OFF_OFF: {
                    if (source.isOn()) break;
                    target.setValue(false);
                    break;
                }
                case OFF_TOGGLE: {
                    if (source.isOn()) break;
                    target.toggle();
                }
            }
        }
    }

    public static enum MomentaryToggleMode {
        TOGGLE("Trigger \u2192 Toggle"),
        ON("Trigger \u2192 On"),
        OFF("Trigger \u2192 Off"),
        DIRECT("Trigger \u2192 Direct");

        public final String label;

        private MomentaryToggleMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        private void onMomentary(BooleanParameter target) {
            switch (this) {
                case TOGGLE: {
                    target.toggle();
                    break;
                }
                case ON: {
                    target.setValue(true);
                    break;
                }
                case OFF: {
                    target.setValue(false);
                    break;
                }
                case DIRECT: {
                    target.setValue(true);
                }
            }
        }

        private void onRelease(BooleanParameter target) {
            switch (this) {
                case DIRECT: {
                    target.setValue(false);
                    break;
                }
            }
        }
    }

    public static enum ToggleMomentaryMode {
        ON("On \u2192 Trigger"),
        OFF("Off \u2192 Trigger"),
        ALWAYS("Any Change \u2192 Trigger");

        public final String label;

        private ToggleMomentaryMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        private boolean shouldTrigger(BooleanParameter source) {
            switch (this) {
                case ALWAYS: {
                    return true;
                }
                case OFF: {
                    return !source.isOn();
                }
            }
            return source.isOn();
        }
    }
}

