/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

public class AHDSREnvelope
extends LXModulator
implements LXNormalizedParameter {
    public final BooleanParameter engage = new BooleanParameter("Engage").setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Engages the envelope");
    public final TriggerParameter retrig = new TriggerParameter("Retrig").setDescription("Retriggers the envelope without resetting it or changing engage status");
    public final BooleanParameter resetMode = new BooleanParameter("Reset", false).setDescription("Sets whether the envelope completely resets on each new engagement");
    public final BooleanParameter oneshot = new BooleanParameter("Oneshot", false).setDescription("Sets whether the envelope plays out even when disengaged");
    public EnumParameter<StageMode> stageMode = new EnumParameter<StageMode>("Stage Mode", StageMode.AHDSR).setDescription("Which stages of the envelope are active");
    public final LXParameter delay;
    public final LXParameter attack;
    public final LXParameter hold;
    public final LXParameter decay;
    public final LXParameter sustain;
    public final LXParameter release;
    public final LXParameter initial;
    public final LXParameter peak;
    private LXParameter shape;
    private double attackFrom = 0.0;
    private double decayFrom = 1.0;
    private double releaseFrom = 1.0;
    private Stage stage = Stage.OFF;
    private double stageBasis = 0.0;

    public AHDSREnvelope(String label, LXParameter delay, LXParameter attack, LXParameter hold, LXParameter decay, LXParameter sustain, LXParameter release, LXParameter initial, LXParameter peak) {
        super(label);
        this.addParameter("engage", this.engage);
        this.addParameter("retrig", this.retrig);
        this.addParameter("stageMode", this.stageMode);
        this.addParameter("resetMode", this.resetMode);
        this.addParameter("oneshot", this.oneshot);
        this.setDescription("Envelope Value");
        this.delay = delay;
        this.attack = attack;
        this.hold = hold;
        this.decay = decay;
        this.sustain = sustain;
        this.release = release;
        this.initial = initial;
        this.peak = peak;
        this.shape = new FixedParameter(1.0);
        this.attackFrom = initial.getValue();
        this.decayFrom = this.releaseFrom = peak.getValue();
    }

    private void setStage(Stage stage) {
        if (this.stage != stage) {
            this.stage = stage;
            this.onStageChanged(this.stage);
        }
    }

    protected void onStageChanged(Stage stage) {
    }

    public AHDSREnvelope setShape(LXParameter shape) {
        this.shape = shape;
        return this;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.stageMode) {
            StageMode stageMode;
            if (!(this.stage == Stage.OFF || (stageMode = this.stageMode.getEnum()).has(this.stage) && this.engage.isOn())) {
                this.stageBasis = 0.0;
                this.setStage(stageMode.endStage());
                this.decayFrom = this.releaseFrom = this.getValue();
            }
        } else if (p == this.retrig) {
            if (this.retrig.isOn()) {
                this.stageBasis = 0.0;
                this.setStage(this.stageMode.getEnum().firstStage());
                this.attackFrom = this.getValue();
            }
        } else if (p == this.engage) {
            Stage endStage;
            if (this.engage.isOn()) {
                Stage firstStage = this.stageMode.getEnum().firstStage();
                if (this.resetMode.isOn()) {
                    this.stageBasis = 0.0;
                    this.setStage(firstStage);
                    this.attackFrom = this.initial.getValue();
                } else if (this.stage != firstStage) {
                    this.stageBasis = 0.0;
                    this.setStage(firstStage);
                    this.attackFrom = this.getValue();
                }
            } else if (this.stage != Stage.OFF && !this.oneshot.isOn() && this.stage != (endStage = this.stageMode.getEnum().endStage())) {
                this.stageBasis = 0.0;
                this.setStage(endStage);
                this.decayFrom = this.releaseFrom = this.getValue();
            }
        }
    }

    @Override
    protected double computeValue(double deltaMs) {
        while (deltaMs > 0.0) {
            deltaMs = this.processStage(deltaMs);
        }
        return this.stageValue();
    }

    private double processStage(double deltaMs) {
        double stageMs = this.stageMs();
        if (stageMs < 0.0) {
            return 0.0;
        }
        double stageRemainingMs = (1.0 - this.stageBasis) * stageMs;
        if (stageMs <= 0.0 || deltaMs >= stageRemainingMs) {
            this.setStage(this.nextStage());
            this.stageBasis = 0.0;
            return deltaMs -= stageRemainingMs;
        }
        this.stageBasis += deltaMs / stageMs;
        return 0.0;
    }

    private double stageMs() {
        switch (this.stage) {
            case DELAY: {
                return this.delay.getValue();
            }
            case ATTACK: {
                return this.attack.getValue();
            }
            case HOLD: {
                return this.hold.getValue();
            }
            case DECAY: {
                return this.decay.getValue();
            }
            case RELEASE: {
                return this.release.getValue();
            }
            case SUSTAIN: {
                return this.oneshot.isOn() && !this.engage.isOn() ? 0.0 : -1.0;
            }
        }
        return -1.0;
    }

    private Stage nextStage() {
        switch (this.stage) {
            case DELAY: {
                return Stage.ATTACK;
            }
            case ATTACK: {
                this.decayFrom = this.peak.getValue();
                return this.stageMode.getEnum().has(Stage.HOLD) ? Stage.HOLD : Stage.DECAY;
            }
            case HOLD: {
                this.decayFrom = this.peak.getValue();
                return Stage.DECAY;
            }
            case DECAY: {
                if (this.stageMode.getEnum().has(Stage.SUSTAIN)) {
                    return Stage.SUSTAIN;
                }
                return Stage.OFF;
            }
            case SUSTAIN: {
                this.releaseFrom = this.sustainValue();
                return Stage.RELEASE;
            }
        }
        return Stage.OFF;
    }

    private double sustainValue() {
        return LXUtils.lerp(this.initial.getValue(), this.peak.getValue(), this.sustain.getValue());
    }

    private double stageValue() {
        switch (this.stage) {
            case DELAY: {
                return this.attackFrom;
            }
            case ATTACK: {
                return LXUtils.lerp(this.attackFrom, this.peak.getValue(), Math.pow(this.stageBasis, this.shape.getValue()));
            }
            case HOLD: {
                return this.peak.getValue();
            }
            case DECAY: {
                return LXUtils.lerp(this.stageMode.getEnum().has(Stage.SUSTAIN) ? this.sustainValue() : this.initial.getValue(), this.decayFrom, Math.pow(1.0 - this.stageBasis, this.shape.getValue()));
            }
            case SUSTAIN: {
                return this.sustainValue();
            }
            case RELEASE: {
                return LXUtils.lerp(this.initial.getValue(), this.releaseFrom, Math.pow(1.0 - this.stageBasis, this.shape.getValue()));
            }
        }
        return this.initial.getValue();
    }

    public Stage getStage() {
        return this.stage;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("Cannot setNormalized on AHDSREnvelope");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    public static enum StageMode {
        AHDSR(Stage.ATTACK, Stage.HOLD, Stage.DECAY, Stage.SUSTAIN, Stage.RELEASE),
        ADSR(Stage.ATTACK, Stage.DECAY, Stage.SUSTAIN, Stage.RELEASE),
        AHD(Stage.ATTACK, Stage.HOLD, Stage.DECAY),
        AD(Stage.ATTACK, Stage.DECAY),
        DAHDSR(Stage.DELAY, Stage.ATTACK, Stage.HOLD, Stage.DECAY, Stage.SUSTAIN, Stage.RELEASE),
        DADSR(Stage.DELAY, Stage.ATTACK, Stage.DECAY, Stage.SUSTAIN, Stage.RELEASE),
        DAHD(Stage.DELAY, Stage.ATTACK, Stage.HOLD, Stage.DECAY),
        DAD(Stage.DELAY, Stage.ATTACK, Stage.DECAY);

        public final Stage[] stages;

        private StageMode(Stage ... stages) {
            this.stages = stages;
        }

        public boolean has(Stage s) {
            for (Stage stage : this.stages) {
                if (stage != s) continue;
                return true;
            }
            return false;
        }

        public Stage firstStage() {
            return this.stages[0];
        }

        public Stage endStage() {
            return this.stages[this.stages.length - 1];
        }
    }

    public static enum Stage {
        DELAY,
        ATTACK,
        HOLD,
        DECAY,
        SUSTAIN,
        RELEASE,
        OFF;

    }
}

