/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.EnumParameter;

@LXModulator.Global(value="Logic")
@LXModulator.Device(value="Logic")
@LXCategory(value="Trigger")
public class BooleanLogic
extends LXModulator
implements LXTriggerSource,
LXOscComponent {
    public final BooleanParameter in1 = new BooleanParameter("In-1", false).setDescription("Input value 1");
    public final BooleanParameter in2 = new BooleanParameter("In-2", false).setDescription("Input value 2");
    public final BooleanParameter in3 = new BooleanParameter("In-3", false).setDescription("Input value 3");
    public final BooleanParameter in4 = new BooleanParameter("In-4", false).setDescription("Input value 4");
    public final BooleanParameter not1 = new BooleanParameter("Not-1", false).setDescription("Inverts input 1");
    public final BooleanParameter not2 = new BooleanParameter("Not-2", false).setDescription("Inverts input 2");
    public final BooleanParameter not3 = new BooleanParameter("Not-3", false).setDescription("Inverts input 3");
    public final BooleanParameter not4 = new BooleanParameter("Not-4", false).setDescription("Inverts input 4");
    public final EnumParameter<Operator> op1 = new EnumParameter<Operator>("Op-1", Operator.OR).setDescription("Logical operator 1");
    public final EnumParameter<Operator> op2 = new EnumParameter<Operator>("Op-2", Operator.OR).setDescription("Logical operator 2");
    public final EnumParameter<Operator> op3 = new EnumParameter<Operator>("Op-3", Operator.OR).setDescription("Logical operator 3");
    public final BooleanParameter out = new BooleanParameter("Out", false).setDescription("Output value");

    public BooleanLogic() {
        this("Logic");
    }

    public BooleanLogic(String label) {
        super(label);
        this.addParameter("in1", this.in1);
        this.addParameter("in2", this.in2);
        this.addParameter("in3", this.in3);
        this.addParameter("in4", this.in4);
        this.addParameter("not1", this.not1);
        this.addParameter("not2", this.not2);
        this.addParameter("not3", this.not3);
        this.addParameter("not4", this.not4);
        this.addParameter("op1", this.op1);
        this.addParameter("op2", this.op2);
        this.addParameter("op3", this.op3);
        this.addParameter("out", this.out);
        this.setMappingSource(false);
    }

    private boolean operand(BooleanParameter toggle, BooleanParameter invert) {
        return invert.isOn() ? !toggle.isOn() : toggle.isOn();
    }

    @Override
    protected double computeValue(double deltaMs) {
        boolean result = this.operand(this.in1, this.not1);
        result = this.op1.getEnum().operate(result, this.operand(this.in2, this.not2));
        result = this.op2.getEnum().operate(result, this.operand(this.in3, this.not3));
        result = this.op3.getEnum().operate(result, this.operand(this.in4, this.not4));
        this.out.setValue(result);
        return result ? 1.0 : 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.out;
    }

    public static enum Operator {
        AND("AND"),
        OR("OR"),
        XOR("XOR");

        public final String label;

        private Operator(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean operate(boolean left, boolean right) {
            switch (this) {
                case AND: {
                    return left && right;
                }
                case OR: {
                    return left || right;
                }
                case XOR: {
                    return left ^ right;
                }
            }
            return false;
        }
    }
}

