/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.utils.LXUtils;

public abstract class HistoryBuffer
extends LXModulator {
    private int cursor = 0;
    private final double[] history;

    public HistoryBuffer(int size) {
        this("BUFFER", size);
    }

    public HistoryBuffer(String label, int size) {
        super(label);
        this.history = new double[size];
    }

    @Override
    protected double computeValue(double deltaMs) {
        if (--this.cursor < 0) {
            this.cursor = this.history.length - 1;
        }
        this.history[this.cursor] = this.getFrameValue();
        return this.history[this.cursor];
    }

    protected abstract double getFrameValue();

    public double getHistory(float framesAgo) {
        if (framesAgo >= (float)(this.history.length - 1)) {
            throw new IllegalArgumentException("Overlow frame buffer, requested " + framesAgo + " overflows buffer length of " + this.history.length);
        }
        int floor = (int)framesAgo;
        float lerp = framesAgo - (float)floor;
        int ceil = floor + 1;
        return LXUtils.lerp(this.history[(this.cursor + floor) % this.history.length], this.history[(this.cursor + ceil) % this.history.length], lerp);
    }

    public double getHistory(int framesAgo) {
        if (framesAgo >= this.history.length) {
            throw new IllegalArgumentException("Overlow frame buffer, requested " + framesAgo + " overflows buffer length of " + this.history.length);
        }
        return this.history[(this.cursor + framesAgo) % this.history.length];
    }

    public float getHistoryf(int framesAgo) {
        return (float)this.getHistory(framesAgo);
    }

    public double getHistory(int framesAgo, int avgLength) {
        if (framesAgo + avgLength >= this.history.length) {
            throw new IllegalArgumentException("Overlow frame buffer, requested " + (framesAgo + avgLength) + " overflows buffer length of " + this.history.length);
        }
        double total = 0.0;
        for (int i = 0; i < avgLength; ++i) {
            total += this.history[(this.cursor + framesAgo + i) % this.history.length];
        }
        return total / (double)avgLength;
    }

    public float getHistoryf(int framesAgo, int avgLength) {
        return (float)this.getHistory(framesAgo, avgLength);
    }
}

