/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXPeriodicModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;

@LXModulator.Global(value="Interval")
@LXModulator.Device(value="Interval")
@LXCategory(value="Trigger")
public class Interval
extends LXPeriodicModulator
implements LXTriggerSource,
LXOscComponent {
    public final CompoundParameter periodMs = new CompoundParameter("Interval", 1000.0, 10.0, 60000.0).setExponent(3.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Base interval for random trigger updates");
    public final CompoundParameter randomMs = new CompoundParameter("Random", 0.0, 0.0, 60000.0).setExponent(3.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Range of random time added to each interval");
    public final CompoundParameter chance = new CompoundParameter("Chance", 100.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Chance that the trigger fires on each interval");
    private double randomInterval = 0.0;
    private final FunctionalParameter totalMs = new FunctionalParameter(){

        @Override
        public double getValue() {
            return Interval.this.periodMs.getValue() + Interval.this.randomInterval * Interval.this.randomMs.getValue();
        }
    };
    public final TriggerParameter triggerOut = new TriggerParameter("Trigger Out").setDescription("Engages when the interval triggers");

    public Interval() {
        this("Interval");
    }

    private Interval(String label) {
        super(label, null);
        this.setPeriod(this.totalMs);
        this.addParameter("periodMs", this.periodMs);
        this.addParameter("randomMs", this.randomMs);
        this.addParameter("chance", this.chance);
        this.addParameter("triggerOut", this.triggerOut);
        this.setDescription("Trigger that fires on randomized interval");
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs, double basis) {
        double d;
        if ((this.loop() || this.finished()) && (d = Math.random()) * 100.0 < this.chance.getValue()) {
            this.randomInterval = Math.random();
            this.triggerOut.trigger();
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }

    @Override
    protected double computeBasis(double basis, double value) {
        return 0.0;
    }
}

