/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXRunnableComponent;
import heronarts.lx.midi.MidiFilterParameter;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;

public abstract class LXModulator
extends LXRunnableComponent
implements LXComponent.Renamable,
LXParameter {
    private LXParameter.Formatter formatter = null;
    private LXParameter.Units units = LXParameter.Units.NONE;
    private LXParameter.Polarity polarity = LXParameter.Polarity.UNIPOLAR;
    private boolean isMappingSource = true;
    private int index = 0;
    private boolean autoStart = true;
    private double value = 0.0;
    private Throwable crash = null;
    public final BooleanParameter crashed = new BooleanParameter("Crashed", false).setDescription("Set to true by the engine if this component fails in an unexpected way");
    public final MidiFilterParameter midiFilter = new MidiFilterParameter("MIDI Filter", true).setDescription("MIDI filter settings for this modulator");

    protected LXModulator(String label) {
        super(label);
        this.addParameter("midiFilter", this.midiFilter);
    }

    public Throwable getCrash() {
        return this.crash;
    }

    public String getCrashStackTrace() {
        String string;
        StringWriter sw = new StringWriter();
        try {
            this.crash.printStackTrace(new PrintWriter(sw));
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iox) {
                return null;
            }
        }
        sw.close();
        return string;
    }

    protected LXModulator disableAutoStart() {
        this.autoStart = false;
        return this;
    }

    public LXModulator setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getOscPath() {
        String path = super.getOscPath();
        if (path != null) {
            return path;
        }
        return this.getOscLabel();
    }

    @Override
    public String getOscAddress() {
        LXComponent parent = this.getParent();
        if (parent instanceof LXOscComponent) {
            return parent.getOscAddress() + "/" + this.getOscPath();
        }
        return null;
    }

    @Override
    public LXParameter setComponent(LXComponent component, String path) {
        if (path != null) {
            throw new UnsupportedOperationException("setComponent() path not supported for LXModulator");
        }
        this.setParent(component);
        return this;
    }

    @Override
    public String getPath() {
        return "modulator/" + (this.index + 1);
    }

    @Override
    public LXModulator setFormatter(LXParameter.Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    public LXParameter.Formatter getFormatter() {
        return this.formatter != null ? this.formatter : this.getUnits();
    }

    public LXModulator setUnits(LXParameter.Units units) {
        this.units = units;
        return this;
    }

    @Override
    public LXParameter.Units getUnits() {
        return this.units;
    }

    public LXModulator setPolarity(LXParameter.Polarity polarity) {
        this.polarity = polarity;
        return this;
    }

    @Override
    public LXParameter.Polarity getPolarity() {
        return this.polarity;
    }

    public LXModulator setMappingSource(boolean isMappingSource) {
        this.isMappingSource = isMappingSource;
        return this;
    }

    public boolean isMappingSource() {
        return this.isMappingSource;
    }

    @Override
    public final double getValue() {
        return this.value;
    }

    @Override
    public final LXModulator setValue(double value) {
        return this.setValue(value, true);
    }

    protected final LXModulator setValue(double value, boolean notify) {
        this.value = value;
        if (notify) {
            this.onSetValue(value);
        }
        return this;
    }

    protected void onSetValue(double value) {
    }

    protected final LXModulator updateValue(double value) {
        this.value = value;
        return this;
    }

    public void autostart() {
        if (this.autoStart) {
            this.start();
        }
    }

    @Override
    public void loop(double deltaMs) {
        if (!this.crashed.isOn()) {
            try {
                super.loop(deltaMs);
            }
            catch (Throwable x) {
                LX.error(x, "Unexpected error in modulator loop " + this.getClass().getName() + ": " + x.getLocalizedMessage());
                this.lx.pushError(x, "Modulator " + LXComponent.getComponentName(this.getClass()) + " crashed due to an unexpected error.\n" + x.getLocalizedMessage());
                this.crash = x;
                this.crashed.setValue(true);
            }
        }
    }

    @Override
    protected final void run(double deltaMs) {
        this.value = this.computeValue(deltaMs);
    }

    protected abstract double computeValue(double var1);

    public static class Placeholder
    extends LXModulator
    implements LXComponent.Placeholder {
        private final LX.InstantiationException instantiationException;
        private String placeholderClassName;
        private JsonObject modulatorObj;

        public Placeholder(LX lx, LX.InstantiationException instantiationException, JsonObject modulatorObj) {
            super("Placeholder");
            this.instantiationException = instantiationException;
            this.placeholderClassName = modulatorObj.get("class").getAsString();
            this.modulatorObj = modulatorObj;
        }

        @Override
        public String getPlaceholderTypeName() {
            return "Modulator";
        }

        @Override
        public String getPlaceholderClassName() {
            return this.placeholderClassName;
        }

        @Override
        public LX.InstantiationException getInstantiationException() {
            return this.instantiationException;
        }

        @Override
        public void save(LX lx, JsonObject object) {
            super.save(lx, object);
            if (this.modulatorObj != null) {
                for (Map.Entry entry : this.modulatorObj.entrySet()) {
                    object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        @Override
        public void load(LX lx, JsonObject object) {
            super.load(lx, object);
            this.placeholderClassName = object.get("class").getAsString();
            this.modulatorObj = object;
        }

        @Override
        protected double computeValue(double deltaMs) {
            return 0.0;
        }
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Device {
        public String value();
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Global {
        public String value();
    }
}

