/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.Tempo;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public abstract class LXPeriodicModulator
extends LXModulator {
    public final BooleanParameter looping = new BooleanParameter("Loop", true).setDescription("Whether this modulator loops at the end of its cycle");
    public final BooleanParameter tempoSync = new BooleanParameter("Sync", false).setDescription("Whether this modulator syncs to a tempo");
    public final EnumParameter<Tempo.Division> tempoDivision = new EnumParameter<Tempo.Division>("Division", Tempo.Division.QUARTER).setDescription("Tempo division when in sync mode");
    public final BooleanParameter tempoLock = new BooleanParameter("Lock", true).setDescription("Whether this modulator is locked to the beat grid or free-running");
    private boolean finished = false;
    private boolean needsReset = false;
    private boolean disableAutoReset = false;
    private boolean looped = false;
    private int numLoops = 0;
    private boolean reset = false;
    private boolean restarted = false;
    private double basis = 0.0;
    private LXParameter period;
    private int previousCycle = 0;
    private static final String KEY_BASIS = "basis";

    protected LXPeriodicModulator(String label, LXParameter period) {
        super(label);
        this.addParameter("loop", this.looping);
        this.addParameter("tempoSync", this.tempoSync);
        this.addParameter("tempoMultiplier", this.tempoDivision);
        this.addParameter("tempoLock", this.tempoLock);
        this.tempoDivision.setWrappable(false);
        this.period = period;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.running) {
            if (this.running.isOn()) {
                this.restarted = true;
                if (this.needsReset && !this.disableAutoReset) {
                    this.setBasis(0.0);
                }
            }
        } else if (p == this.tempoLock && this.tempoLock.isOn()) {
            this.restarted = true;
        }
    }

    public LXPeriodicModulator setLooping(boolean looping) {
        this.looping.setValue(looping);
        return this;
    }

    public LXPeriodicModulator disableAutoReset() {
        this.disableAutoReset = true;
        return this;
    }

    public final double getBasis() {
        return this.basis;
    }

    public final float getBasisf() {
        return (float)this.getBasis();
    }

    @Override
    protected void onReset() {
        this.reset = true;
        this.setBasis(0.0);
        this.reset = false;
        this.needsReset = false;
    }

    public final LXPeriodicModulator randomBasis() {
        this.setBasis(Math.random());
        return this;
    }

    public final LXPeriodicModulator setBasis(double basis) {
        if (basis < 0.0) {
            basis = 0.0;
        } else if (basis > 1.0) {
            basis = 1.0;
        }
        this.basis = basis;
        this.updateValue(this.computeValue(0.0));
        return this;
    }

    @Override
    public void onSetValue(double value) {
        this.updateBasis(value);
    }

    protected final void updateBasis(double value) {
        this.basis = this.computeBasis(this.basis, value);
    }

    public final LXPeriodicModulator setPeriod(double periodMs) {
        this.period = new FixedParameter(periodMs);
        return this;
    }

    public final double getPeriod() {
        return this.period.getValue();
    }

    public final float getPeriodf() {
        return (float)this.getPeriod();
    }

    public final LXPeriodicModulator setPeriod(LXParameter period) {
        this.period = period;
        return this;
    }

    @Override
    public void loop(double deltaMs) {
        this.finished = false;
        this.looped = false;
        this.numLoops = 0;
        super.loop(deltaMs);
    }

    @Override
    protected final double computeValue(double deltaMs) {
        this.finished = false;
        this.looped = false;
        this.numLoops = 0;
        this.needsReset = false;
        double periodv = this.period.getValue();
        if (this.tempoSync.isOn()) {
            if (this.tempoLock.isOn()) {
                Tempo.Division division = this.tempoDivision.getEnum();
                int cycle = this.lx.engine.tempo.getCycleCount(division);
                this.basis = this.lx.engine.tempo.getBasis(division);
                if (!this.reset) {
                    if (this.restarted) {
                        this.restarted = false;
                    } else if (cycle != this.previousCycle) {
                        if (this.looping.isOn()) {
                            this.looped = true;
                            this.numLoops = cycle > this.previousCycle ? cycle - this.previousCycle : 1;
                        } else {
                            this.basis = 1.0;
                        }
                    }
                }
                this.previousCycle = cycle;
            } else {
                this.basis += deltaMs / this.lx.engine.tempo.period.getValue() * this.tempoDivision.getEnum().multiplier;
            }
        } else {
            this.basis = periodv == 0.0 ? 1.0 : (this.basis += deltaMs / this.period.getValue());
        }
        if (this.basis >= 1.0) {
            if (this.looping.isOn()) {
                this.looped = true;
                this.numLoops = (int)this.basis;
                this.basis %= 1.0;
            } else {
                this.basis = 1.0;
                this.finished = true;
                this.needsReset = true;
                this.stop();
            }
        }
        return this.computeValue(deltaMs, this.basis);
    }

    public final boolean loop() {
        return this.looped;
    }

    public final int numLoops() {
        return this.numLoops;
    }

    public final boolean finished() {
        return this.finished;
    }

    protected abstract double computeValue(double var1, double var3);

    protected abstract double computeBasis(double var1, double var3);

    @Override
    public void save(LX lx, JsonObject object) {
        super.save(lx, object);
        object.addProperty(KEY_BASIS, (Number)this.basis);
    }

    @Override
    public void load(LX lx, JsonObject object) {
        super.load(lx, object);
        if (object.has(KEY_BASIS)) {
            this.setBasis(object.get(KEY_BASIS).getAsDouble());
        }
    }
}

