/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXPeriodicModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

public abstract class LXRangeModulator
extends LXPeriodicModulator
implements LXNormalizedParameter {
    private LXParameter startValue;
    private LXParameter endValue;
    private double exponent = 1.0;

    protected LXRangeModulator(String label, LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        super(label, periodMs);
        this.startValue = startValue;
        this.endValue = endValue;
        this.updateValue(startValue.getValue());
    }

    public final LXRangeModulator setRange(double startValue, double endValue, double periodMs) {
        this.setPeriod(periodMs);
        this.startValue = new FixedParameter(startValue);
        this.endValue = new FixedParameter(endValue);
        this.onRangeChanged();
        return this;
    }

    public LXRangeModulator setExponent(double exponent) {
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("May not set zero or negative exponent");
        }
        this.exponent = exponent;
        return this;
    }

    @Override
    public double getExponent() {
        return this.exponent;
    }

    public final LXRangeModulator setRange(double startValue, double endValue) {
        this.startValue = new FixedParameter(startValue);
        this.endValue = new FixedParameter(endValue);
        this.onRangeChanged();
        return this;
    }

    public final LXRangeModulator setStartValue(double startValue) {
        return this.setStartValue(new FixedParameter(startValue));
    }

    public final LXRangeModulator setEndValue(double endValue) {
        return this.setEndValue(new FixedParameter(endValue));
    }

    public final LXRangeModulator setRangeFromHereTo(double endValue) {
        return this.setRange(this.getValue(), endValue);
    }

    public final LXRangeModulator setRangeFromHereTo(double endValue, double periodMs) {
        return this.setRange(this.getValue(), endValue, periodMs);
    }

    private void onRangeChanged() {
        double sv = this.startValue.getValue();
        double ev = this.endValue.getValue();
        double min = Math.min(sv, ev);
        double max = Math.max(sv, ev);
        double value = this.getValue();
        if (value < min) {
            this.setValue(min);
        } else if (value > max) {
            this.setValue(max);
        } else {
            this.updateBasis(value);
        }
    }

    public LXRangeModulator setStartValue(LXParameter startValue) {
        this.startValue = startValue;
        this.onRangeChanged();
        return this;
    }

    public LXRangeModulator setEndValue(LXParameter endValue) {
        this.endValue = endValue;
        this.onRangeChanged();
        return this;
    }

    @Override
    public void onSetValue(double value) {
        double sv = this.startValue.getValue();
        double ev = this.endValue.getValue();
        double min = Math.min(sv, ev);
        double max = Math.max(sv, ev);
        if (value < min) {
            this.updateValue(min);
            this.updateBasis(min);
        } else if (value > max) {
            this.updateValue(max);
            this.updateBasis(max);
        } else {
            this.updateBasis(value);
        }
    }

    @Override
    public final LXRangeModulator setNormalized(double normalized) {
        double sv = this.startValue.getValue();
        double ev = this.endValue.getValue();
        this.setValue(sv + (ev - sv) * normalized);
        return this;
    }

    private final double getNormalized(double value) {
        double ev;
        double sv = this.startValue.getValue();
        if (sv == (ev = this.endValue.getValue())) {
            return 0.0;
        }
        return (value - sv) / (ev - sv);
    }

    @Override
    public final double getNormalized() {
        return this.getNormalized(this.getValue());
    }

    @Override
    public final float getNormalizedf() {
        return (float)this.getNormalized();
    }

    @Override
    protected final double computeValue(double deltaMs, double basis) {
        double ev;
        double sv = this.startValue.getValue();
        if (sv == (ev = this.endValue.getValue())) {
            return sv;
        }
        return sv + this.computeNormalizedValue(deltaMs, basis) * (ev - sv);
    }

    @Override
    protected final double computeBasis(double basis, double value) {
        double ev;
        double sv = this.startValue.getValue();
        if (sv == (ev = this.endValue.getValue())) {
            return 0.0;
        }
        return this.computeNormalizedBasis(basis, this.getNormalized(value));
    }

    protected abstract double computeNormalizedValue(double var1, double var3);

    protected abstract double computeNormalizedBasis(double var1, double var3);
}

