/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXRangeModulator;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;

public abstract class LXVariablePeriodModulator
extends LXRangeModulator {
    public final EnumParameter<ClockMode> clockMode = new EnumParameter<ClockMode>("Clock Mode", ClockMode.FAST).setDescription("Clock mode of the modulator");
    public final CompoundParameter periodFast = new CompoundParameter("Period", 1000.0, 100.0, 60000.0).setDescription("Sets the period of the modulator in msecs").setExponent(4.0).setUnits(LXParameter.Units.MILLISECONDS);
    public final CompoundParameter periodSlow = new CompoundParameter("Period", 10000.0, 1000.0, 900000.0).setDescription("Sets the period of the modulator in msecs").setExponent(4.0).setUnits(LXParameter.Units.MILLISECONDS);
    private boolean inClockUpdate = false;

    protected LXVariablePeriodModulator(String label, LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        super(label, startValue, endValue, periodMs);
        this.addParameter("clockMode", this.clockMode);
        this.addParameter("periodFast", this.periodFast);
        this.addParameter("periodSlow", this.periodSlow);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.clockMode) {
            this.inClockUpdate = true;
            switch (this.clockMode.getEnum()) {
                case FAST: {
                    this.setPeriod(this.periodFast);
                    this.tempoSync.setValue(false);
                    break;
                }
                case SLOW: {
                    this.setPeriod(this.periodSlow);
                    this.tempoSync.setValue(false);
                    break;
                }
                case SYNC: {
                    this.tempoSync.setValue(true);
                }
            }
            this.inClockUpdate = false;
        } else if (p == this.tempoSync) {
            if (this.tempoSync.isOn()) {
                this.clockMode.setValue((Object)ClockMode.SYNC);
            } else if (!this.inClockUpdate) {
                this.clockMode.setValue((Object)ClockMode.FAST);
            }
        }
    }

    public static enum ClockMode {
        FAST,
        SLOW,
        SYNC;


        public String toString() {
            switch (this) {
                case FAST: {
                    return "Fast";
                }
                case SLOW: {
                    return "Slow";
                }
            }
            return "Sync";
        }
    }
}

