/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

public interface LXWaveshape {
    public static final LXWaveshape SIN = new LXWaveshape(){

        @Override
        public double compute(double basis) {
            return 0.5 * (1.0 + Math.sin(basis * (Math.PI * 2) - 1.5707963267948966));
        }

        @Override
        public double invert(double value, double basisHint) {
            double sinValue = -1.0 + 2.0 * value;
            double angle = Math.asin(sinValue);
            if (basisHint > 0.5) {
                angle = Math.PI - angle;
            }
            return (angle + 1.5707963267948966) / (Math.PI * 2);
        }

        public String toString() {
            return "Sine";
        }
    };
    public static final LXWaveshape TRI = new LXWaveshape(){

        @Override
        public double compute(double basis) {
            return basis < 0.5 ? 2.0 * basis : 1.0 - 2.0 * (basis - 0.5);
        }

        @Override
        public double invert(double value, double basisHint) {
            return basisHint < 0.5 ? value / 2.0 : 1.0 - value / 2.0;
        }

        public String toString() {
            return "Triangle";
        }
    };
    public static final LXWaveshape UP = new LXWaveshape(){

        @Override
        public double compute(double basis) {
            return basis;
        }

        @Override
        public double invert(double value, double basisHint) {
            return value;
        }

        public String toString() {
            return "Up";
        }
    };
    public static final LXWaveshape DOWN = new LXWaveshape(){

        @Override
        public double compute(double basis) {
            return 1.0 - basis;
        }

        @Override
        public double invert(double value, double basisHint) {
            return 1.0 - value;
        }

        public String toString() {
            return "Down";
        }
    };
    public static final LXWaveshape SQUARE = new LXWaveshape(){

        @Override
        public double compute(double basis) {
            return basis < 0.5 ? 0.0 : 1.0;
        }

        @Override
        public double invert(double value, double basisHint) {
            return value == 0.0 ? 0.0 : 0.5;
        }

        public String toString() {
            return "Square";
        }
    };

    public double compute(double var1);

    public double invert(double var1, double var3);
}

