/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;

@LXModulator.Global(value="MIDI Note")
@LXModulator.Device(value="MIDI Note")
@LXCategory(value="Trigger")
public class MidiNoteTrigger
extends LXModulator
implements LXTriggerSource,
LXOscComponent,
LXMidiListener {
    public final BooleanParameter legato = new BooleanParameter("Legato").setDescription("Whether to sustain held legato notes");
    public final BooleanParameter triggerOut = new BooleanParameter("Trigger Out").setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Indicates whenever the MIDI trig fires");
    private int noteCount = 0;

    public MidiNoteTrigger() {
        this("MIDI Note");
    }

    public MidiNoteTrigger(String label) {
        super(label);
        this.addParameter("triggerOut", this.triggerOut);
        this.setMappingSource(false);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.legato) {
            this.noteCount = 0;
            this.triggerOut.setValue(false);
        }
    }

    @Override
    protected double computeValue(double deltaMs) {
        return 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        ++this.noteCount;
        this.triggerOut.setValue(true);
        if (!this.legato.isOn()) {
            this.triggerOut.setValue(false);
        }
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        if (this.noteCount > 0) {
            --this.noteCount;
        }
        if (!this.legato.isOn() || this.noteCount == 0) {
            this.triggerOut.setValue(false);
        }
    }
}

