/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.AHDSREnvelope;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="AHDSR")
@LXModulator.Device(value="AHDSR")
@LXCategory(value="Core")
public class MultiModeEnvelope
extends AHDSREnvelope
implements LXOscComponent,
LXNormalizedParameter,
LXTriggerSource,
LXMidiListener {
    public final CompoundParameter shape = new CompoundParameter("Shape", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Shape of the envelope response curves");
    private final FunctionalParameter shapePow = new FunctionalParameter("Shape"){

        @Override
        public double getValue() {
            double s = MultiModeEnvelope.this.shape.getValue();
            if (s > 0.0) {
                return LXUtils.lerp(1.0, 3.0, s);
            }
            return 1.0 / LXUtils.lerp(1.0, 3.0, -s);
        }
    };
    public final BooleanParameter manualTrigger = new BooleanParameter("Trigger", false).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Manually engage the gate");
    public final TriggerParameter targetTrigger = new TriggerParameter("Trigger").setDescription("Engage the gate from a trigger");
    public final BoundedParameter midiVelocityResponse = new BoundedParameter("Velocity", 25.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Degree to which MIDI velocity influences ceiling level");
    public final BoundedParameter midiNoteResponse = new BoundedParameter("Note Response", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Degree to which MIDI note influences ceiling level");
    public final BooleanParameter midiLegato = new BooleanParameter("Legato", false).setDescription("Whether to skip retrigger on legato midi notes");
    private int midiLegatoCount = 0;

    private static final CompoundParameter initial() {
        return new CompoundParameter("Initial", 0.0, 0.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Initial Value");
    }

    private static final CompoundParameter peak() {
        return new CompoundParameter("Peak", 1.0, 0.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Peak Value");
    }

    private static final CompoundParameter delay() {
        return new CompoundParameter("Delay", 0.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Delay Time");
    }

    private static final CompoundParameter attack() {
        return new CompoundParameter("Attack", 100.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Attack Time");
    }

    private static final CompoundParameter hold() {
        return new CompoundParameter("Hold", 0.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Hold Time");
    }

    private static final CompoundParameter decay() {
        return new CompoundParameter("Decay", 1000.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Decay Time");
    }

    private static final CompoundParameter sustain() {
        return new CompoundParameter("Sustain", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sustain Level");
    }

    private static final CompoundParameter release() {
        return new CompoundParameter("Release", 1000.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Release Time");
    }

    public MultiModeEnvelope() {
        this("AHDSR");
    }

    public MultiModeEnvelope(String label) {
        super(label, MultiModeEnvelope.delay(), MultiModeEnvelope.attack(), MultiModeEnvelope.hold(), MultiModeEnvelope.decay(), MultiModeEnvelope.sustain(), MultiModeEnvelope.release(), MultiModeEnvelope.initial(), MultiModeEnvelope.peak());
        this.setShape(this.shapePow);
        this.addParameter("initial", this.initial);
        this.addParameter("peak", this.peak);
        this.addParameter("delay", this.delay);
        this.addParameter("attack", this.attack);
        this.addParameter("hold", this.hold);
        this.addParameter("decay", this.decay);
        this.addParameter("sustain", this.sustain);
        this.addParameter("release", this.release);
        this.addParameter("shape", this.shape);
        this.addParameter("manualTrigger", this.manualTrigger);
        this.addParameter("targetTrigger", this.targetTrigger);
        this.addLegacyParameter("midiEnabled", this.midiFilter.enabled);
        this.addParameter("midiVelocityResponse", this.midiVelocityResponse);
        this.addParameter("midiNoteResponse", this.midiNoteResponse);
        this.addLegacyParameter("midiMinNote", this.midiFilter.minNote);
        this.addLegacyParameter("midiNoteRange", this.midiFilter.noteRange);
        this.addLegacyParameter("midiChannel", this.midiFilter.channel);
        this.addParameter("midiLegato", this.midiLegato);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.midiFilter.enabled) {
            this.midiLegatoCount = 0;
            this.engage.setValue(false);
        } else if (p == this.manualTrigger) {
            this.peak.setValue(1.0);
            this.engage.setValue(this.manualTrigger.isOn());
        } else if (p == this.targetTrigger) {
            this.peak.setValue(1.0);
            this.engage.setValue(this.targetTrigger.isOn());
        }
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.engage;
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        ++this.midiLegatoCount;
        boolean legato = this.midiLegato.isOn();
        if (legato && this.midiLegatoCount > 1) {
            return;
        }
        float velocity = 0.0f;
        float velResponse = this.midiVelocityResponse.getValuef() / 100.0f;
        float scaleVelocity = ((float)note.getVelocity() - this.midiFilter.minVelocity.getValuef() + 1.0f) / this.midiFilter.velocityRange.getValuef();
        velocity = velResponse >= 0.0f ? LXUtils.lerpf(1.0f, scaleVelocity, velResponse) : LXUtils.lerpf(1.0f, 1.0f - scaleVelocity, -velResponse);
        float noteResponse = this.midiNoteResponse.getValuef() / 100.0f;
        if (noteResponse >= 0.0f) {
            float noteVelocity = ((float)note.getPitch() - this.midiFilter.minNote.getValuef() + 1.0f) / this.midiFilter.noteRange.getValuef();
            this.peak.setValue(velocity * LXUtils.lerpf(1.0f, noteVelocity, noteResponse));
        } else {
            float noteVelocity = (this.midiFilter.minNote.getValuef() + this.midiFilter.noteRange.getValuef() + 1.0f - (float)note.getPitch()) / this.midiFilter.noteRange.getValuef();
            this.peak.setValue(velocity * LXUtils.lerpf(1.0f, noteVelocity, -noteResponse));
        }
        if (this.engage.isOn()) {
            if (!legato) {
                if (this.resetMode.isOn()) {
                    this.engage.setValue(false);
                    this.engage.setValue(true);
                } else {
                    this.retrig.setValue(true);
                }
            }
        } else {
            this.engage.setValue(true);
        }
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.midiLegatoCount = Math.max(0, this.midiLegatoCount - 1);
        if (this.midiLegatoCount == 0) {
            this.engage.setValue(false);
        }
    }
}

