/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="Multi Trig")
@LXModulator.Device(value="Multi Trig")
@LXCategory(value="Trigger")
public class MultiTrig
extends LXModulator
implements LXOscComponent,
LXTriggerSource {
    public static final int MAX_OUTPUTS = 5;
    public final TriggerParameter triggerIn = new TriggerParameter("Trig", this::onTrig).setDescription("Trigger input");
    public final CompoundParameter inputChance = new CompoundParameter("Chance", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Chance that device responds to input");
    public final TriggerParameter inputIndicator = new TriggerParameter("Input").setDescription("Indicates when the input has fired");
    public final DiscreteParameter numOutputs = new DiscreteParameter("Num Outs", 5, 0, 6).setDescription("Number of active outputs");
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.ALL).setDescription("Operation mode");
    public final TriggerParameter out1 = new TriggerParameter("Out 1").setDescription("Trigger Output 1");
    public final TriggerParameter out2 = new TriggerParameter("Out 2").setDescription("Trigger Output 2");
    public final TriggerParameter out3 = new TriggerParameter("Out 3").setDescription("Trigger Output 3");
    public final TriggerParameter out4 = new TriggerParameter("Out 4").setDescription("Trigger Output 4");
    public final TriggerParameter out5 = new TriggerParameter("Out 5").setDescription("Trigger Output 5");
    public final CompoundParameter chance1 = new CompoundParameter("Chance 1", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Chance of output on output 1");
    public final CompoundParameter chance2 = new CompoundParameter("Chance 1", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Chance of output on output 2");
    public final CompoundParameter chance3 = new CompoundParameter("Chance 1", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Chance of output on output 3");
    public final CompoundParameter chance4 = new CompoundParameter("Chance 1", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Chance of output on output 4");
    public final CompoundParameter chance5 = new CompoundParameter("Chance 1", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Chance of output on output 5");
    private final TriggerParameter[] out = new TriggerParameter[]{this.out1, this.out2, this.out3, this.out4, this.out5};
    private final CompoundParameter[] chance = new CompoundParameter[]{this.chance1, this.chance2, this.chance3, this.chance4, this.chance5};
    private int index = 0;
    private int increment = 1;

    public MultiTrig() {
        this("Multi Trig");
        this.addParameter("triggerIn", this.triggerIn);
        this.addParameter("inputChance", this.inputChance);
        this.addParameter("numOutputs", this.numOutputs);
        this.addParameter("mode", this.mode);
        this.addParameter("out1", this.out1);
        this.addParameter("out2", this.out2);
        this.addParameter("out3", this.out3);
        this.addParameter("out4", this.out4);
        this.addParameter("out5", this.out5);
        this.addParameter("chance1", this.chance1);
        this.addParameter("chance2", this.chance2);
        this.addParameter("chance3", this.chance3);
        this.addParameter("chance4", this.chance4);
        this.addParameter("chance5", this.chance5);
        this.setMappingSource(false);
    }

    public MultiTrig(String label) {
        super(label);
    }

    private void onTrig() {
        if (!this.running.isOn() || this.inputChance.getValue() <= Math.random()) {
            return;
        }
        this.inputIndicator.trigger();
        int numOutputs = this.numOutputs.getValuei();
        if (numOutputs == 0) {
            return;
        }
        switch (this.mode.getEnum()) {
            case ALL: {
                for (int i = 0; i < numOutputs; ++i) {
                    this.triggerOut(i);
                }
                break;
            }
            case RANDOM: {
                this.triggerOut(LXUtils.randomi(0, numOutputs - 1));
                break;
            }
            case CYCLE: {
                this.index = (this.index + 1) % numOutputs;
                this.triggerOut(this.index);
                break;
            }
            case REVERSE: {
                this.index = (this.index + numOutputs - 1) % numOutputs;
                this.triggerOut(this.index);
                break;
            }
            case FLIP: {
                if (this.index <= 0) {
                    this.increment = 1;
                } else if (this.index >= numOutputs - 1) {
                    this.increment = -1;
                }
                this.index += this.increment;
                this.triggerOut(this.index);
            }
        }
    }

    private void triggerOut(int index) {
        if (this.chance[index].getValue() > Math.random()) {
            this.out[index].trigger();
        }
    }

    @Override
    protected double computeValue(double deltaMs) {
        return 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return null;
    }

    public static enum Mode {
        ALL("All"),
        RANDOM("Random"),
        CYCLE("Cycle"),
        REVERSE("Reverse"),
        FLIP("Flip");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

