/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXRangeModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public class QuadraticEnvelope
extends LXRangeModulator {
    private Ease ease = Ease.IN;

    public QuadraticEnvelope(double startValue, double endValue, double periodMs) {
        this((LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(LXParameter startValue, double endValue, double periodMs) {
        this(startValue, (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(double startValue, LXParameter endValue, double periodMs) {
        this((LXParameter)new FixedParameter(startValue), endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(double startValue, double endValue, LXParameter periodMs) {
        this((LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public QuadraticEnvelope(LXParameter startValue, LXParameter endValue, double periodMs) {
        this(startValue, endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(LXParameter startValue, double endValue, LXParameter periodMs) {
        this(startValue, (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public QuadraticEnvelope(double startValue, LXParameter endValue, LXParameter periodMs) {
        this((LXParameter)new FixedParameter(startValue), endValue, periodMs);
    }

    public QuadraticEnvelope(LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        this("QENV", startValue, endValue, periodMs);
    }

    public QuadraticEnvelope(String label, double startValue, double endValue, double periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(String label, LXParameter startValue, double endValue, double periodMs) {
        this(label, startValue, (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(String label, double startValue, LXParameter endValue, double periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(String label, double startValue, double endValue, LXParameter periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public QuadraticEnvelope(String label, LXParameter startValue, LXParameter endValue, double periodMs) {
        this(label, startValue, endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public QuadraticEnvelope(String label, LXParameter startValue, double endValue, LXParameter periodMs) {
        this(label, startValue, (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public QuadraticEnvelope(String label, double startValue, LXParameter endValue, LXParameter periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), endValue, periodMs);
    }

    public QuadraticEnvelope(String label, LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        super(label, startValue, endValue, periodMs);
        this.setExponent(2.0);
        this.setLooping(false);
    }

    public QuadraticEnvelope setEase(Ease ease) {
        this.ease = ease;
        return this;
    }

    @Override
    protected double computeNormalizedValue(double deltaMs, double basis) {
        double exponent = this.getExponent();
        switch (this.ease) {
            case IN: {
                return Math.pow(basis, exponent);
            }
            case OUT: {
                return 1.0 - Math.pow(1.0 - basis, exponent);
            }
            case BOTH: {
                if (basis < 0.5) {
                    return 0.5 * Math.pow(2.0 * basis, exponent);
                }
                return 0.5 + 0.5 * (1.0 - Math.pow(1.0 - 2.0 * (basis - 0.5), exponent));
            }
        }
        return 0.0;
    }

    @Override
    protected double computeNormalizedBasis(double basis, double normalizedValue) {
        switch (this.ease) {
            case IN: {
                return Math.sqrt(normalizedValue);
            }
            case OUT: {
                return 1.0 - Math.sqrt(1.0 - normalizedValue);
            }
            case BOTH: {
                if (normalizedValue < 0.5) {
                    return Math.sqrt(normalizedValue *= 2.0) / 2.0;
                }
                normalizedValue = (normalizedValue - 0.5) * 2.0;
                return 0.5 + (1.0 - Math.sqrt(1.0 - normalizedValue)) / 2.0;
            }
        }
        return 0.0;
    }

    public static enum Ease {
        IN,
        OUT,
        BOTH;

    }
}

