/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXRangeModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public class SinLFO
extends LXRangeModulator {
    public SinLFO(double startValue, double endValue, double periodMs) {
        this((LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(LXParameter startValue, double endValue, double periodMs) {
        this(startValue, (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(double startValue, LXParameter endValue, double periodMs) {
        this((LXParameter)new FixedParameter(startValue), endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(double startValue, double endValue, LXParameter periodMs) {
        this((LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public SinLFO(LXParameter startValue, LXParameter endValue, double periodMs) {
        this(startValue, endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(LXParameter startValue, double endValue, LXParameter periodMs) {
        this(startValue, (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public SinLFO(double startValue, LXParameter endValue, LXParameter periodMs) {
        this((LXParameter)new FixedParameter(startValue), endValue, periodMs);
    }

    public SinLFO(LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        this("SIN", startValue, endValue, periodMs);
    }

    public SinLFO(String label, double startValue, double endValue, double periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(String label, LXParameter startValue, double endValue, double periodMs) {
        this(label, startValue, (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(String label, double startValue, LXParameter endValue, double periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(String label, double startValue, double endValue, LXParameter periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public SinLFO(String label, LXParameter startValue, LXParameter endValue, double periodMs) {
        this(label, startValue, endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public SinLFO(String label, LXParameter startValue, double endValue, LXParameter periodMs) {
        this(label, startValue, (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public SinLFO(String label, double startValue, LXParameter endValue, LXParameter periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), endValue, periodMs);
    }

    public SinLFO(String label, LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        super(label, startValue, endValue, periodMs);
    }

    @Override
    protected double computeNormalizedValue(double deltaMs, double basis) {
        return (1.0 + Math.sin(basis * (Math.PI * 2) - 1.5707963267948966)) / 2.0;
    }

    @Override
    protected double computeNormalizedBasis(double basis, double normalizedValue) {
        double sinValue = -1.0 + 2.0 * normalizedValue;
        double angle = Math.asin(sinValue);
        if (basis > 0.5) {
            angle = Math.PI - angle;
        }
        return (angle + 1.5707963267948966) / (Math.PI * 2);
    }
}

