/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.Tempo;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXPeriodicModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;

@LXModulator.Global(value="Step Sequencer")
@LXModulator.Device(value="Step Sequencer")
@LXCategory(value="Trigger")
public class StepSequencer
extends LXPeriodicModulator
implements LXTriggerSource {
    public static final int MAX_STEPS = 16;
    public final DiscreteParameter numSteps = new DiscreteParameter("Num Steps", 16, 1, 17).setDescription("Number of active steps");
    public final EnumParameter<TriggerMode> triggerMode = new EnumParameter<TriggerMode>("Trig Mode", TriggerMode.INTERNAL).setDescription("Whether triggers are internally or externally generated");
    public final CompoundParameter stepTimeMs = new CompoundParameter("Step Time", 500.0, 50.0, 5000.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Manual Step Time");
    public final TriggerParameter triggerIn = new TriggerParameter("Trigger In", this::onTriggerIn).setDescription("Advances the step sequencer manually");
    public final TriggerParameter triggerOut = new TriggerParameter("Trig Out").setDescription("Fires on an active step");
    public final BooleanParameter[] steps = new BooleanParameter[16];
    public final BooleanParameter[] activeStep = new BooleanParameter[16];
    private final FunctionalParameter totalMs = new FunctionalParameter(){

        @Override
        public double getValue() {
            return StepSequencer.this.triggerMode.getEnum() == TriggerMode.EXTERNAL ? Double.POSITIVE_INFINITY : StepSequencer.this.stepTimeMs.getValue();
        }
    };
    private int step = 0;

    public StepSequencer() {
        super("Step Sequencer", null);
        this.setPeriod(this.totalMs);
        this.tempoSync.setValue(true);
        this.setMappingSource(false);
        this.addParameter("numSteps", this.numSteps);
        this.addParameter("triggerMode", this.triggerMode);
        this.addParameter("triggerIn", this.triggerIn);
        this.addParameter("triggerOut", this.triggerOut);
        for (int i = 0; i < this.steps.length; ++i) {
            this.steps[i] = new BooleanParameter("Step-" + (i + 1), false).setDescription("Whether the sequencer triggers on step " + (i + 1));
            this.addParameter("step-" + (i + 1), this.steps[i]);
            this.activeStep[i] = new BooleanParameter("Trig-" + (i + 1)).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Fires on step " + (i + 1));
            this.addParameter("activeStep-" + (i + 1), this.activeStep[i]);
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.triggerMode) {
            if (this.triggerMode.getEnum() == TriggerMode.EXTERNAL) {
                this.tempoSync.setValue(false);
                this.setBasis(0.0);
            }
        } else if (p == this.numSteps) {
            this.nextStep(0, false);
        }
    }

    private void nextStep(int increment, boolean trigger) {
        this.step = this.tempoSync.isOn() && this.tempoLock.isOn() ? this.lx.engine.tempo.getCycleCount((Tempo.Division)((Object)this.tempoDivision.getEnum())) % this.numSteps.getValuei() : (this.step + increment) % this.numSteps.getValuei();
        for (int i = 0; i < this.activeStep.length; ++i) {
            this.activeStep[i].setValue(i == this.step);
        }
        if (trigger && this.steps[this.step].isOn()) {
            this.triggerOut.trigger();
        }
    }

    private void onTriggerIn() {
        if (this.running.isOn() && this.triggerMode.getEnum() == TriggerMode.EXTERNAL) {
            this.nextStep(1, true);
        }
    }

    @Override
    protected double computeValue(double deltaMs, double basis) {
        if (this.loop() || this.finished()) {
            this.nextStep(1, true);
        }
        return 0.0;
    }

    @Override
    protected double computeBasis(double basis, double value) {
        throw new UnsupportedOperationException("StepSequencer does not support computeBasis");
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }

    public static enum TriggerMode {
        INTERNAL("Internal"),
        EXTERNAL("External");

        public final String label;

        private TriggerMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

