/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.TimeParameter;
import java.util.Calendar;

@LXModulator.Global(value="Timer")
@LXCategory(value="Trigger")
public class Timer
extends LXModulator
implements LXNormalizedParameter,
LXTriggerSource,
LXOscComponent {
    public final TimeParameter time = new TimeParameter("Time").setDescription("What time of day the timer fires");
    public final BooleanParameter sunday = new BooleanParameter("Sunday", true).setDescription("Whether the timer fires on Sunday");
    public final BooleanParameter monday = new BooleanParameter("Monday", true).setDescription("Whether the timer fires on Monday");
    public final BooleanParameter tuesday = new BooleanParameter("Tuesday", true).setDescription("Whether the timer fires on Tuesday");
    public final BooleanParameter wednesday = new BooleanParameter("Wednesday", true).setDescription("Whether the timer fires on Wednesday");
    public final BooleanParameter thursday = new BooleanParameter("Thursday", true).setDescription("Whether the timer fires on Thursday");
    public final BooleanParameter friday = new BooleanParameter("Friday", true).setDescription("Whether the timer fires on Friday");
    public final BooleanParameter saturday = new BooleanParameter("Saturday", true).setDescription("Whether the timer fires on Saturday");
    private final BooleanParameter[] days = new BooleanParameter[]{this.sunday, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday};
    private final Calendar calendar = Calendar.getInstance();
    public final BooleanParameter triggerOut = new BooleanParameter("Trigger Out").setDescription("Indicates when the timer fires").setMode(BooleanParameter.Mode.MOMENTARY);

    public Timer() {
        this("Timer");
    }

    public Timer(String label) {
        super(label);
        this.addParameter("time", this.time);
        this.addParameter("sunday", this.sunday);
        this.addParameter("monday", this.monday);
        this.addParameter("tuesday", this.tuesday);
        this.addParameter("wednesday", this.wednesday);
        this.addParameter("thursday", this.thursday);
        this.addParameter("friday", this.friday);
        this.addParameter("saturday", this.saturday);
        this.addParameter("triggerOut", this.triggerOut);
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs) {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        boolean active = false;
        int day = this.calendar.get(7);
        if (this.days[day - 1].isOn()) {
            int timerSeconds;
            int thisSeconds = TimeParameter.getSecondsOfDay(this.calendar);
            active = thisSeconds == (timerSeconds = this.time.getSecondsOfDay());
        }
        this.triggerOut.setValue(active);
        return active ? 1.0 : 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("Timer does not support setNormalized");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }
}

