/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXPath;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.parameter.LXParameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;

public class LXOscQueryServer {
    private final LX lx;
    private ServerThread thread = null;

    public LXOscQueryServer(LX lx) {
        this.lx = lx;
    }

    public void bind(int port) {
        this.unbind();
        this.thread = new ServerThread(port);
    }

    public void unbind() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread.dispose();
            this.thread = null;
        }
    }

    private class ServerThread
    extends Thread {
        private ServerSocket serverSocket = null;
        private boolean closing = false;
        private final int port;

        private ServerThread(int port) {
            this.port = port;
            try {
                this.serverSocket = new ServerSocket();
                this.serverSocket.setReuseAddress(true);
                this.start();
            }
            catch (IOException iox) {
                LX.error(iox, "Could not create LXOscQueryServer server socket");
                this.serverSocket = null;
            }
        }

        @Override
        public void run() {
            try {
                LXOscEngine.log("Binding LXOscQueryServer on port " + this.port);
                this.serverSocket.bind(new InetSocketAddress(InetAddress.getLocalHost(), this.port));
                while (!this.isInterrupted()) {
                    Socket socket = this.serverSocket.accept();
                    this.handleClient(socket);
                }
            }
            catch (IOException iox) {
                if (!this.closing) {
                    LX.error(iox, "LXOscQueryServer IO error");
                }
            }
            catch (Exception x) {
                LX.error(x, "LXOscQueryServer unexpected error");
            }
            this.dispose();
        }

        public void dispose() {
            if (this.serverSocket != null) {
                try {
                    this.closing = true;
                    this.serverSocket.close();
                }
                catch (IOException iox) {
                    LX.error(iox, "Error closing LXOscQueryServer server socket");
                }
                finally {
                    this.serverSocket = null;
                }
                LXOscEngine.log("Closed LXOscQueryServer on port " + this.port);
            }
        }

        private void handleClient(Socket socket) throws IOException {
            socket.setSoTimeout(1000);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            try (InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                String get = null;
                URI uri = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("GET")) {
                        get = line;
                        String[] parts = line.split(" ");
                        if (parts.length < 1) continue;
                        try {
                            uri = new URI(parts[1]);
                        }
                        catch (URISyntaxException urisx) {
                            LX.error(urisx, "Bad URI syntax: " + parts[1]);
                            uri = null;
                        }
                        continue;
                    }
                    if (!line.isEmpty()) continue;
                    if (uri == null) {
                        LX.error("Did not find a URI in HTTP request, closing: " + get);
                        break;
                    }
                    this.sendResponse(uri, os);
                    get = null;
                    uri = null;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            is.close();
            os.close();
            socket.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendResponse(URI uri, OutputStream os) throws IOException {
            OscQueryResponse extensions;
            OscQueryResponse response = new OscQueryResponse();
            if ("HOST_INFO".equals(uri.getQuery())) {
                response.obj.addProperty("NAME", "LX:" + this.port);
                response.obj.addProperty("OSC_PORT", (Number)this.port);
                extensions = new JsonObject();
                extensions.addProperty("VALUE", true);
                extensions.addProperty("DESCRIPTION", true);
                response.obj.add("EXTENSIONS", (JsonElement)extensions);
            } else {
                ((LXOscQueryServer)LXOscQueryServer.this).lx.engine.addTask(() -> {
                    if ("/".equals(uri.getPath())) {
                        response.obj.addProperty("FULL_PATH", "/");
                        response.obj.addProperty("DESCRIPTION", "Root Node");
                        JsonObject contents = new JsonObject();
                        contents.add("lx", (JsonElement)((LXOscQueryServer)LXOscQueryServer.this).lx.engine.toOscQuery());
                        response.obj.add("CONTENTS", (JsonElement)contents);
                    } else {
                        LXPath path = LXPath.get(LXOscQueryServer.this.lx, uri.getPath());
                        if (path == null) {
                            response.rc = "404 NOT FOUND";
                        } else if (path instanceof LXComponent) {
                            response.obj = ((LXComponent)path).toOscQuery();
                        } else if (path instanceof LXParameter) {
                            response.obj = path.getParent().toOscQuery((LXParameter)path);
                        }
                    }
                    OscQueryResponse oscQueryResponse = response;
                    synchronized (oscQueryResponse) {
                        response.ready = true;
                        response.notify();
                    }
                });
                extensions = response;
                synchronized (extensions) {
                    if (!response.ready) {
                        try {
                            response.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            String json = new Gson().toJson((JsonElement)response.obj);
            byte[] bytes = json.getBytes("UTF-8");
            String httpHeader = "HTTP/1.1 " + response.rc + "\r\nContent-Type: application/json\r\nConnection: keep-alive\r\nContent-Length: " + bytes.length + "\r\n\r\n";
            os.write(httpHeader.getBytes());
            os.write(bytes);
            os.flush();
        }

        private class OscQueryResponse {
            private boolean ready = false;
            private String rc = "200 OK";
            private JsonObject obj = new JsonObject();

            private OscQueryResponse() {
            }
        }
    }
}

