/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import heronarts.lx.osc.OscArgument;
import java.nio.ByteBuffer;

public class OscBlob
implements OscArgument {
    private int byteLength;
    private byte[] data;

    public OscBlob(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot pass null array to OscBlob constructor");
        }
        this.setData(data);
    }

    public byte[] getData() {
        return this.data;
    }

    public OscBlob setData(byte[] data) {
        this.data = data;
        this.byteLength = 4 + data.length;
        while (this.byteLength % 4 > 0) {
            ++this.byteLength;
        }
        return this;
    }

    @Override
    public int getByteLength() {
        return this.byteLength;
    }

    @Override
    public char getTypeTag() {
        return 'b';
    }

    public String toString() {
        return "<" + this.data.length + "-byte blob>";
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.byteLength);
        buffer.put(this.data);
        for (int i = this.data.length; i < this.byteLength; ++i) {
            buffer.put((byte)0);
        }
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public float toFloat() {
        return 0.0f;
    }

    @Override
    public double toDouble() {
        return 0.0;
    }

    @Override
    public boolean toBoolean() {
        return false;
    }
}

