/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import heronarts.lx.osc.OscException;
import heronarts.lx.osc.OscMalformedDataException;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.osc.OscPacket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OscBundle
extends OscPacket
implements Iterable<OscMessage> {
    private static final byte[] BUNDLE_HEADER = new byte[]{35, 98, 117, 110, 100, 108, 101, 0};
    private long timeTag = 1L;
    private final List<OscPacket> elements = new ArrayList<OscPacket>();

    public List<OscPacket> getElements() {
        return this.elements;
    }

    public OscBundle addElement(OscPacket packet) {
        this.elements.add(packet);
        return this;
    }

    public long getTimeTag() {
        return this.timeTag;
    }

    public OscBundle setTimeTag(long timeTag) {
        this.timeTag = timeTag;
        return this;
    }

    public static OscBundle parse(InetAddress source, byte[] data, int offset, int len) throws OscException {
        for (int i = 0; i < BUNDLE_HEADER.length; ++i) {
            if (data[offset + i] == BUNDLE_HEADER[i]) continue;
            throw new OscMalformedDataException("Missing #bundle header in OscBundle", data, offset, len);
        }
        OscBundle bundle = new OscBundle();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        bundle.setTimeTag(buffer.getLong(offset += BUNDLE_HEADER.length));
        offset += 8;
        while (offset < len) {
            int packetLength = buffer.getInt(offset);
            bundle.addElement(OscPacket.parse(source, data, offset += 4, offset + packetLength));
            offset += packetLength;
        }
        return bundle;
    }

    @Override
    public Iterator<OscMessage> iterator() {
        ArrayList<OscMessage> messages = new ArrayList<OscMessage>(this.elements.size());
        OscBundle.flattenMessages(messages, this);
        return messages.iterator();
    }

    private static void flattenMessages(List<OscMessage> messages, OscBundle bundle) {
        for (int i = 0; i < bundle.elements.size(); ++i) {
            OscPacket element = bundle.elements.get(i);
            if (element instanceof OscMessage) {
                messages.add((OscMessage)element);
                continue;
            }
            if (!(element instanceof OscBundle)) continue;
            OscBundle.flattenMessages(messages, (OscBundle)element);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (OscMessage message : this) {
            sb.append(message.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put(BUNDLE_HEADER);
        buffer.putLong(this.timeTag);
        for (OscPacket packet : this.elements) {
            int sizePosition = buffer.position();
            buffer.position(sizePosition + 4);
            packet.serialize(buffer);
            buffer.putInt(sizePosition, buffer.position() - (sizePosition + 4));
        }
    }
}

