/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import heronarts.lx.osc.OscArgument;
import heronarts.lx.osc.OscException;
import heronarts.lx.osc.OscMalformedDataException;
import java.nio.ByteBuffer;

public class OscString
implements OscArgument {
    private String value;
    private int byteLength;

    public OscString(char[] value) {
        this(new String(value));
    }

    public OscString(String value) {
        this.setValue(value);
    }

    public OscString setValue(String value) {
        this.value = value;
        this.byteLength = value.length() + 1;
        while (this.byteLength % 4 > 0) {
            ++this.byteLength;
        }
        return this;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int getByteLength() {
        return this.byteLength;
    }

    public static OscString parse(byte[] data, int offset, int len) throws OscException {
        for (int i = offset; i < len; ++i) {
            if (data[i] != 0) continue;
            return new OscString(new String(data, offset, i - offset));
        }
        throw new OscMalformedDataException("OscString has no terminating null character", data, offset, len);
    }

    @Override
    public char getTypeTag() {
        return 's';
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        byte[] bytes = this.value.getBytes();
        buffer.put(bytes);
        for (int i = bytes.length; i < this.byteLength; ++i) {
            buffer.put((byte)0);
        }
    }

    @Override
    public int toInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public float toFloat() {
        return Float.parseFloat(this.value);
    }

    @Override
    public double toDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    public boolean toBoolean() {
        return this.value.equals("true") || this.value.equals("TRUE");
    }
}

