/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXDatagram;

public class ArtNetDatagram
extends LXDatagram {
    public static final int ARTNET_PORT = 6454;
    public static final int MAX_DATA_LENGTH = 512;
    public static final int MAX_UNIVERSE = 32768;
    public static final int ARTNET_HEADER_LENGTH = 18;
    public static final int SEQUENCE_INDEX = 12;
    private static final int DEFAULT_UNIVERSE = 0;
    public static final int UNIVERSE_LSB = 14;
    public static final int UNIVERSE_MSB = 15;
    public static final int DATA_LENGTH_MSB = 16;
    public static final int DATA_LENGTH_LSB = 17;
    public static final byte[] HEADER = new byte[]{65, 114, 116, 45, 78, 101, 116, 0};
    private boolean sequenceEnabled = false;
    private byte sequence = 1;
    private final int dataLength;
    private int universeNumber;

    private static int dmxDataLength(int length) {
        return length + length % 2;
    }

    public ArtNetDatagram(LX lx, LXModel model) {
        this(lx, model, 0);
    }

    public ArtNetDatagram(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, 0);
    }

    public ArtNetDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder) {
        this(lx, indexBuffer, byteOrder, 0);
    }

    public ArtNetDatagram(LX lx, LXModel model, int universeNumber) {
        this(lx, model.toIndexBuffer(), universeNumber);
    }

    public ArtNetDatagram(LX lx, LXModel model, LXBufferOutput.ByteOrder byteOrder, int universeNumber) {
        this(lx, model.toIndexBuffer(), byteOrder, universeNumber);
    }

    public ArtNetDatagram(LX lx, int[] indexBuffer, int universeNumber) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, universeNumber);
    }

    public ArtNetDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int universeNumber) {
        this(lx, indexBuffer, byteOrder, byteOrder.getNumBytes() * indexBuffer.length, universeNumber);
    }

    public ArtNetDatagram(LX lx, LXModel model, int dataLength, int universeNumber) {
        this(lx, model.toIndexBuffer(), LXBufferOutput.ByteOrder.RGB, dataLength, universeNumber);
    }

    public ArtNetDatagram(LX lx, LXModel model, LXBufferOutput.ByteOrder byteOrder, int dataLength, int universeNumber) {
        this(lx, model.toIndexBuffer(), byteOrder, dataLength, universeNumber);
    }

    public ArtNetDatagram(LX lx, int[] indexBuffer, int dataLength, int universeNumber) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, dataLength, universeNumber);
    }

    public ArtNetDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int dataLength, int universeNumber) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder), dataLength, universeNumber);
    }

    public ArtNetDatagram(LX lx, IndexBuffer indexBuffer, int universeNumber) {
        this(lx, indexBuffer, indexBuffer.numChannels, universeNumber);
    }

    public ArtNetDatagram(LX lx, IndexBuffer indexBuffer, int dataLength, int universeNumber) {
        super(lx, indexBuffer, 18 + ArtNetDatagram.dmxDataLength(dataLength));
        this.dataLength = ArtNetDatagram.dmxDataLength(dataLength);
        this.setPort(6454);
        this.validateBufferSize();
        System.arraycopy(HEADER, 0, this.buffer, 0, HEADER.length);
        this.buffer[8] = 0;
        this.buffer[9] = 80;
        this.buffer[10] = 0;
        this.buffer[11] = 14;
        this.buffer[12] = 0;
        this.buffer[13] = 0;
        this.setUniverseNumber(universeNumber);
        this.buffer[16] = (byte)(this.dataLength >>> 8 & 0xFF);
        this.buffer[17] = (byte)(this.dataLength & 0xFF);
    }

    public ArtNetDatagram setUniverseNumber(int universeNumber) {
        this.universeNumber = universeNumber;
        this.buffer[14] = (byte)(universeNumber & 0xFF);
        this.buffer[15] = (byte)(universeNumber >>> 8 & 0xFF);
        return this;
    }

    public int getUniverseNumber() {
        return this.universeNumber;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public ArtNetDatagram setSequenceEnabled(boolean sequenceEnabled) {
        this.sequenceEnabled = sequenceEnabled;
        if (!this.sequenceEnabled) {
            this.buffer[12] = 0;
        }
        return this;
    }

    @Override
    protected int getDataBufferOffset() {
        return 18;
    }

    @Override
    protected void updateSequenceNumber() {
        if (this.sequenceEnabled) {
            this.sequence = (byte)(this.sequence + 1);
            if (this.sequence == 0) {
                this.sequence = (byte)(this.sequence + 1);
            }
            this.buffer[12] = this.sequence;
        }
    }
}

