/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.OPCSocket;
import java.io.IOException;

public class FadecandySocket
extends OPCSocket {
    public static final int DEFAULT_PORT = 7890;
    private byte firmwareConfig = 0;
    private String colorCorrection = null;
    private final byte[] firmwarePacket = new byte[9];

    public FadecandySocket(LX lx) {
        this(lx, lx.getModel());
    }

    public FadecandySocket(LX lx, LXModel model) {
        this(lx, model.toIndexBuffer());
    }

    public FadecandySocket(LX lx, int[] indexBuffer) {
        super(lx, indexBuffer);
        this.setPort(7890);
    }

    @Override
    protected void didConnect() {
        this.sendColorCorrectionPacket();
        this.sendFirmwareConfigPacket();
    }

    public FadecandySocket setDithering(boolean enabled) {
        this.firmwareConfig = enabled ? (byte)(this.firmwareConfig & 0xFFFFFFFE) : (byte)(this.firmwareConfig | 1);
        this.sendFirmwareConfigPacket();
        return this;
    }

    public FadecandySocket setInterpolation(boolean enabled) {
        this.firmwareConfig = enabled ? (byte)(this.firmwareConfig & 0xFFFFFFFD) : (byte)(this.firmwareConfig | 2);
        this.sendFirmwareConfigPacket();
        return this;
    }

    public FadecandySocket setStatusLedAuto() {
        this.firmwareConfig = (byte)(this.firmwareConfig & 0xC);
        this.sendFirmwareConfigPacket();
        return this;
    }

    public FadecandySocket setStatusLed(boolean on) {
        this.firmwareConfig = (byte)(this.firmwareConfig | 4);
        this.firmwareConfig = on ? (byte)(this.firmwareConfig | 8) : (byte)(this.firmwareConfig & 0xFFFFFFF7);
        this.sendFirmwareConfigPacket();
        return this;
    }

    private void sendFirmwareConfigPacket() {
        if (!this.isConnected()) {
            return;
        }
        this.firmwarePacket[0] = 0;
        this.firmwarePacket[1] = -1;
        this.firmwarePacket[2] = 0;
        this.firmwarePacket[3] = 5;
        this.firmwarePacket[4] = 0;
        this.firmwarePacket[5] = 1;
        this.firmwarePacket[6] = 0;
        this.firmwarePacket[7] = 2;
        this.firmwarePacket[8] = this.firmwareConfig;
        try {
            this.output.write(this.firmwarePacket);
        }
        catch (IOException iox) {
            this.disconnect(iox);
        }
    }

    public FadecandySocket setColorCorrection(float gamma, float red, float green, float blue) {
        this.colorCorrection = "{ \"gamma\": " + gamma + ", \"whitepoint\": [" + red + "," + green + "," + blue + "]}";
        this.sendColorCorrectionPacket();
        return this;
    }

    public FadecandySocket setColorCorrection(String s) {
        this.colorCorrection = s;
        this.sendColorCorrectionPacket();
        return this;
    }

    private void sendColorCorrectionPacket() {
        if (this.colorCorrection == null || !this.isConnected()) {
            return;
        }
        byte[] content = this.colorCorrection.getBytes();
        int packetLen = content.length + 4;
        byte[] header = new byte[]{0, -1, (byte)(packetLen >> 8), (byte)(packetLen & 0xFF), 0, 1, 0, 1};
        try {
            this.output.write(header);
            this.output.write(content);
        }
        catch (IOException iox) {
            this.disconnect(iox);
        }
    }
}

