/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.List;

public class IndexBuffer {
    public final Segment[] segments;
    public final int numChannels;

    public IndexBuffer(int[] indices) {
        this(new Segment(indices));
    }

    public IndexBuffer(int[] indices, LXBufferOutput.ByteOrder byteOrder) {
        this(new Segment(indices, byteOrder));
    }

    public IndexBuffer(int[] indices, LXBufferOutput.ByteOrder byteOrder, int channel) {
        this(new Segment(indices, byteOrder, channel));
    }

    public IndexBuffer(int[] indices, LXBufferOutput.ByteOrder byteOrder, int channel, LXParameter brightness) {
        this(new Segment(indices, byteOrder, channel, brightness));
    }

    public IndexBuffer(List<Segment> segments) {
        this(segments.toArray(new Segment[0]));
    }

    public IndexBuffer(Segment ... segments) {
        this.segments = segments;
        int endChannel = -1;
        for (Segment segment : segments) {
            if (segment.endChannel <= endChannel) continue;
            endChannel = segment.endChannel;
        }
        this.numChannels = endChannel + 1;
    }

    public static class Segment {
        public final int[] indices;
        public final LXBufferOutput.ByteEncoder byteEncoder;
        public final int startChannel;
        public final int endChannel;
        public final int byteLength;
        public final LXParameter brightness;

        public Segment(int[] indices) {
            this(indices, LXBufferOutput.ByteOrder.RGB);
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder) {
            this(indices, byteEncoder, 0);
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder, int channel) {
            this(indices, byteEncoder, channel, new FixedParameter(1.0));
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder, int channel, LXParameter brightness) {
            this.indices = indices;
            this.byteEncoder = byteEncoder;
            this.startChannel = channel;
            this.byteLength = this.indices.length * this.byteEncoder.getNumBytes();
            this.endChannel = this.startChannel + this.byteLength - 1;
            this.brightness = brightness;
        }
    }
}

