/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXOutput;

public abstract class LXBufferOutput
extends LXOutput {
    protected final IndexBuffer indexBuffer;

    protected LXBufferOutput(LX lx, IndexBuffer indexBuffer) {
        super(lx);
        this.indexBuffer = indexBuffer;
    }

    protected abstract byte[] getDataBuffer();

    protected abstract int getDataBufferOffset();

    protected LXBufferOutput updateDataBuffer(int[] colors, LXOutput.GammaTable glut, double brightness) {
        byte[] buffer = this.getDataBuffer();
        for (IndexBuffer.Segment segment : this.indexBuffer.segments) {
            int glutIndex = (int)Math.round(255.0 * brightness * segment.brightness.getValue());
            LXOutput.GammaTable.Curve gamma = glut.level[glutIndex];
            ByteEncoder byteEncoder = segment.byteEncoder;
            int numBytes = byteEncoder.getNumBytes();
            int offset = this.getDataBufferOffset() + segment.startChannel;
            if (byteEncoder instanceof ByteOrder) {
                int color;
                int index;
                int i;
                ByteOrder byteOrder = (ByteOrder)byteEncoder;
                int[] byteOffset = byteOrder.getByteOffset();
                if (byteOrder.hasWhite) {
                    int w;
                    int b;
                    int g;
                    int r;
                    if (numBytes == 1) {
                        for (i = 0; i < segment.indices.length; ++i) {
                            index = segment.indices[i];
                            color = index >= 0 ? colors[index] : 0;
                            r = color >> 16 & 0xFF;
                            g = color >> 8 & 0xFF;
                            b = color & 0xFF;
                            w = (r + b + g) / 3;
                            buffer[offset] = gamma.white[w];
                            offset += numBytes;
                        }
                        continue;
                    }
                    for (i = 0; i < segment.indices.length; ++i) {
                        index = segment.indices[i];
                        color = index >= 0 ? colors[index] : 0;
                        r = color >> 16 & 0xFF;
                        g = color >> 8 & 0xFF;
                        b = color & 0xFF;
                        w = r < g ? (r < b ? r : b) : (g < b ? g : b);
                        buffer[offset + byteOffset[0]] = gamma.red[r -= w];
                        buffer[offset + byteOffset[1]] = gamma.green[g -= w];
                        buffer[offset + byteOffset[2]] = gamma.blue[b -= w];
                        buffer[offset + byteOffset[3]] = gamma.white[w];
                        offset += numBytes;
                    }
                    continue;
                }
                for (i = 0; i < segment.indices.length; ++i) {
                    index = segment.indices[i];
                    color = index >= 0 ? colors[index] : 0;
                    buffer[offset + byteOffset[0]] = gamma.red[color >> 16 & 0xFF];
                    buffer[offset + byteOffset[1]] = gamma.green[color >> 8 & 0xFF];
                    buffer[offset + byteOffset[2]] = gamma.blue[color & 0xFF];
                    offset += numBytes;
                }
                continue;
            }
            for (int i = 0; i < segment.indices.length; ++i) {
                int index = segment.indices[i];
                int color = index >= 0 ? colors[index] : 0;
                byteEncoder.writeBytes(color, gamma, buffer, offset);
                offset += numBytes;
            }
        }
        return this;
    }

    public static interface ByteEncoder {
        public int getNumBytes();

        public void writeBytes(int var1, LXOutput.GammaTable.Curve var2, byte[] var3, int var4);
    }

    public static enum ByteOrder implements ByteEncoder
    {
        RGB(new int[]{0, 1, 2}),
        RBG(new int[]{0, 2, 1}),
        GRB(new int[]{1, 0, 2}),
        GBR(new int[]{2, 0, 1}),
        BRG(new int[]{1, 2, 0}),
        BGR(new int[]{2, 1, 0}),
        RGBW(new int[]{0, 1, 2, 3}, true),
        RBGW(new int[]{0, 2, 1, 3}, true),
        GRBW(new int[]{1, 0, 2, 3}, true),
        GBRW(new int[]{2, 0, 1, 3}, true),
        BRGW(new int[]{1, 2, 0, 3}, true),
        BGRW(new int[]{2, 1, 0, 3}, true),
        WRGB(new int[]{1, 2, 3, 0}, true),
        WRBG(new int[]{1, 3, 2, 0}, true),
        WGRB(new int[]{2, 1, 3, 0}, true),
        WGBR(new int[]{3, 1, 2, 0}, true),
        WBRG(new int[]{2, 3, 1, 0}, true),
        WBGR(new int[]{3, 2, 1, 0}, true),
        W(new int[]{0}, true);

        private final int[] byteOffset;
        public final boolean hasWhite;

        private ByteOrder(int[] byteOffset) {
            this(byteOffset, false);
        }

        private ByteOrder(int[] byteOffset, boolean hasWhite) {
            this.byteOffset = byteOffset;
            this.hasWhite = hasWhite;
        }

        @Override
        public int getNumBytes() {
            return this.byteOffset.length;
        }

        public int[] getByteOffset() {
            return this.byteOffset;
        }

        @Override
        public void writeBytes(int color, LXOutput.GammaTable.Curve gamma, byte[] output, int offset) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            if (this.hasWhite) {
                if (this.byteOffset.length == 1) {
                    output[offset] = gamma.white[(r + b + g) / 3];
                } else {
                    int w = r < g ? (r < b ? r : b) : (g < b ? g : b);
                    output[offset + this.byteOffset[0]] = gamma.red[r - w];
                    output[offset + this.byteOffset[1]] = gamma.green[g - w];
                    output[offset + this.byteOffset[2]] = gamma.blue[b - w];
                    output[offset + this.byteOffset[3]] = gamma.white[w];
                }
            } else {
                output[offset + this.byteOffset[0]] = gamma.red[r];
                output[offset + this.byteOffset[1]] = gamma.green[g];
                output[offset + this.byteOffset[2]] = gamma.blue[b];
            }
        }
    }
}

