/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.output.LXOutputGroup;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import java.net.InetAddress;

public abstract class LXOutput
extends LXComponent {
    public static final float MAX_FRAMES_PER_SECOND = 300.0f;
    public final BooleanParameter enabled = new BooleanParameter("Enabled", true).setDescription("Whether the output is active");
    public final BoundedParameter framesPerSecond = new BoundedParameter("FPS", 0.0, 300.0).setMappable(false).setDescription("Maximum frames per second this output will send (0 for no limiting)");
    public final BoundedParameter gamma = (BoundedParameter)new BoundedParameter("Gamma", 1.0, 1.0, 4.0).setMappable(false).setOscMode(LXNormalizedParameter.OscMode.ABSOLUTE).setDescription("Gamma correction on the output, 1 is linear (no gamma)");
    public final EnumParameter<GammaMode> gammaMode = new EnumParameter<GammaMode>("Gamma Mode", GammaMode.INHERIT);
    public final CompoundParameter brightness = new CompoundParameter("Brightness", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Level of the output");
    public final DiscreteParameter whitePointRed = new DiscreteParameter("White Point Red", 255, 0, 256).setMappable(false).setDescription("White point value for red pixel output");
    public final DiscreteParameter whitePointGreen = new DiscreteParameter("White Point Green", 255, 0, 256).setMappable(false).setDescription("White point value for green pixel output");
    public final DiscreteParameter whitePointBlue = new DiscreteParameter("White Point Blue", 255, 0, 256).setMappable(false).setDescription("White point value for blue pixel output");
    public final DiscreteParameter whitePointWhite = new DiscreteParameter("White Point White", 255, 0, 256).setMappable(false).setDescription("White point value for white pixel output");
    private long lastFrameMillis = 0L;
    private GammaTable gammaLut = null;
    private boolean hasCustomGamma = false;
    private GammaTable customGammaLut = null;
    private LXOutput gammaDelegate = null;
    private static final String OUTPUT_LOG_PREFIX = "[I/O] ";

    private void buildGammaTable() {
        if (this.gammaMode.getEnum() == GammaMode.DIRECT) {
            if (this.gammaLut == null) {
                this.gammaLut = new GammaTable();
            }
            double gamma = this.gamma.getValue();
            double whitePointRed = this.whitePointRed.getValue();
            double whitePointGreen = this.whitePointGreen.getValue();
            double whitePointBlue = this.whitePointBlue.getValue();
            double whitePointWhite = this.whitePointWhite.getValue();
            for (int b = 0; b < 256; ++b) {
                GammaTable.Curve.generate(this.gammaLut.level[b].red, b, gamma, whitePointRed);
                GammaTable.Curve.generate(this.gammaLut.level[b].green, b, gamma, whitePointGreen);
                GammaTable.Curve.generate(this.gammaLut.level[b].blue, b, gamma, whitePointBlue);
                GammaTable.Curve.generate(this.gammaLut.level[b].white, b, gamma, whitePointWhite);
            }
        }
    }

    protected LXOutput(LX lx) {
        this(lx, "Output");
    }

    protected LXOutput(LX lx, String label) {
        super(lx, label);
        this.buildGammaTable();
        this.addParameter("enabled", this.enabled);
        this.addParameter("brightness", this.brightness);
        this.addParameter("fps", this.framesPerSecond);
        this.addParameter("gamma", this.gamma);
        this.addParameter("gammaMode", this.gammaMode);
        this.addParameter("whitePointRed", this.whitePointRed);
        this.addParameter("whitePointGreen", this.whitePointGreen);
        this.addParameter("whitePointBlue", this.whitePointBlue);
        this.addParameter("whitePointWhite", this.whitePointWhite);
    }

    @Deprecated
    public void setGammaTable(byte[][] gammaLut) {
        this.setGammaTable(new GammaTable(gammaLut));
    }

    public void setGammaTable(GammaTable gammaLut) {
        this.customGammaLut = gammaLut;
        this.hasCustomGamma = true;
    }

    public void setGammaDelegate(LXOutput gammaDelegate) {
        this.gammaDelegate = gammaDelegate;
    }

    private GammaTable getGammaLut() {
        if (this.hasCustomGamma) {
            return this.customGammaLut;
        }
        switch (this.gammaMode.getEnum()) {
            case DIRECT: {
                return this.gammaLut;
            }
        }
        LXOutput gammaOutput = this.gammaDelegate != null ? this.gammaDelegate : (LXOutput)this.getParent();
        return gammaOutput.getGammaLut();
    }

    public void setGroup(LXOutputGroup output) {
        super.setParent(output);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.gamma || p == this.gammaMode || p == this.whitePointRed || p == this.whitePointGreen || p == this.whitePointBlue || p == this.whitePointWhite) {
            this.buildGammaTable();
        }
    }

    public LXOutput send(int[] colors) {
        return this.send(colors, 1.0);
    }

    public final LXOutput send(int[] colors, double brightness) {
        if (!this.enabled.isOn()) {
            return this;
        }
        long now = System.currentTimeMillis();
        double fps = this.framesPerSecond.getValue();
        if (fps == 0.0 || (double)(now - this.lastFrameMillis) > 1000.0 / fps) {
            this.onSend(colors, this.getGammaLut(), brightness *= this.brightness.getValue());
            this.lastFrameMillis = now;
        }
        return this;
    }

    protected abstract void onSend(int[] var1, GammaTable var2, double var3);

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.brightness.reset();
            this.framesPerSecond.reset();
            this.gamma.reset();
            this.whitePointRed.reset();
            this.whitePointGreen.reset();
            this.whitePointBlue.reset();
            this.whitePointWhite.reset();
        }
    }

    public static final void log(String message) {
        LX.log(OUTPUT_LOG_PREFIX + message);
    }

    public static final void error(String message) {
        LX.error(OUTPUT_LOG_PREFIX + message);
    }

    public static final void error(Exception x, String message) {
        LX.error(x, OUTPUT_LOG_PREFIX + message);
    }

    public static enum GammaMode {
        INHERIT,
        DIRECT;

    }

    public static class GammaTable {
        public static final int NUM_STEPS = 256;
        public static final int WHITE_POINT_MAX = 255;
        public final Curve[] level = new Curve[256];

        public GammaTable() {
            for (int i = 0; i < this.level.length; ++i) {
                this.level[i] = new Curve();
            }
        }

        @Deprecated
        private GammaTable(byte[][] lut) {
            for (int i = 0; i < this.level.length; ++i) {
                this.level[i] = new Curve(lut[i], lut[i], lut[i], lut[i]);
            }
        }

        public static class Curve {
            public final byte[] red;
            public final byte[] green;
            public final byte[] blue;
            public final byte[] white;
            private static final double INV_255_2 = 1.5378700499807768E-5;
            private static final double INV_255_3 = 6.030862941101084E-8;

            private Curve() {
                this(new byte[256], new byte[256], new byte[256], new byte[256]);
            }

            private Curve(byte[] red, byte[] green, byte[] blue, byte[] white) {
                this.red = red;
                this.green = green;
                this.blue = blue;
                this.white = white;
            }

            private static void generate(byte[] output, int b, double gamma, double whitePoint) {
                if (gamma == 1.0) {
                    for (int in = 0; in < 256; ++in) {
                        output[in] = (byte)(0xFF & (int)Math.round((double)(in * b) * whitePoint * 1.5378700499807768E-5));
                    }
                } else {
                    for (int in = 0; in < 256; ++in) {
                        output[in] = (byte)(0xFF & (int)Math.round(Math.pow((double)(in * b) * whitePoint * 6.030862941101084E-8, gamma) * 255.0));
                    }
                }
            }
        }
    }

    public static interface InetOutput {
        public static final int NO_PORT = -1;

        public InetOutput setAddress(InetAddress var1);

        public InetAddress getAddress();

        public InetOutput setPort(int var1);

        public int getPort();
    }
}

