/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.output.LXOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LXOutputGroup
extends LXOutput {
    private final List<LXOutput> mutableChildren = new ArrayList<LXOutput>();
    public final List<LXOutput> children = Collections.unmodifiableList(this.mutableChildren);

    public LXOutputGroup(LX lx) {
        this(lx, "Output");
    }

    public LXOutputGroup(LX lx, String label) {
        super(lx, label);
        this.gammaMode.setValue((Object)LXOutput.GammaMode.DIRECT);
    }

    public LXOutputGroup addChild(LXOutput child) {
        if (this.children.contains(child)) {
            throw new IllegalStateException("May not add duplicate child to LXOutputGroup: " + child);
        }
        child.setGroup(this);
        this.mutableChildren.add(child);
        return this;
    }

    public LXOutputGroup removeChild(LXOutput child) {
        if (!this.children.contains(child)) {
            throw new IllegalStateException("May not add remove non-existent child from LXOutputGroup: " + child);
        }
        this.mutableChildren.remove(child);
        return this;
    }

    protected LXOutputGroup clearChildren() {
        this.mutableChildren.clear();
        return this;
    }

    @Override
    protected void onSend(int[] colors, LXOutput.GammaTable glut, double brightness) {
        for (LXOutput child : this.children) {
            child.send(colors, brightness);
        }
    }
}

