/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXDatagram;
import heronarts.lx.output.OPCOutput;

public class OPCDatagram
extends LXDatagram
implements OPCOutput {
    public static final int MAX_DATA_LENGTH = 65535;

    public OPCDatagram(LX lx, LXModel model) {
        this(lx, model, 0);
    }

    public OPCDatagram(LX lx, LXModel model, byte opcChannel) {
        this(lx, model.toIndexBuffer(), opcChannel);
    }

    public OPCDatagram(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, 0);
    }

    public OPCDatagram(LX lx, int[] indexBuffer, byte opcChannel) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, opcChannel);
    }

    public OPCDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, byte opcChannel) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder), opcChannel);
    }

    public OPCDatagram(LX lx, IndexBuffer indexBuffer, byte opcChannel) {
        super(lx, indexBuffer, 4 + indexBuffer.numChannels);
        int dataLength = indexBuffer.numChannels;
        this.validateBufferSize();
        this.buffer[0] = opcChannel;
        this.buffer[1] = 0;
        this.buffer[2] = (byte)(dataLength >>> 8);
        this.buffer[3] = (byte)(dataLength & 0xFF);
    }

    @Override
    public OPCDatagram setChannel(byte channel) {
        this.buffer[0] = channel;
        return this;
    }

    public byte getChannel() {
        return this.buffer[0];
    }

    @Override
    protected int getDataBufferOffset() {
        return 4;
    }
}

