/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXSocket;
import heronarts.lx.output.OPCOutput;

public class OPCSocket
extends LXSocket
implements OPCOutput {
    static final int OFFSET_R = 0;
    static final int OFFSET_G = 1;
    static final int OFFSET_B = 2;
    private final byte[] packetData;

    public OPCSocket(LX lx) {
        this(lx, lx.getModel());
    }

    public OPCSocket(LX lx, LXModel model) {
        this(lx, model.toIndexBuffer());
    }

    public OPCSocket(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, 0);
    }

    public OPCSocket(LX lx, int[] indexBuffer, byte opcChannel) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, opcChannel);
    }

    public OPCSocket(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder) {
        this(lx, indexBuffer, byteOrder, 0);
    }

    public OPCSocket(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, byte opcChannel) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder), opcChannel);
    }

    public OPCSocket(LX lx, IndexBuffer indexBuffer, byte opcChannel) {
        super(lx, indexBuffer);
        int dataLength = indexBuffer.numChannels;
        this.packetData = new byte[4 + dataLength];
        this.packetData[0] = opcChannel;
        this.packetData[1] = 0;
        this.packetData[2] = (byte)(dataLength >>> 8);
        this.packetData[3] = (byte)(dataLength & 0xFF);
    }

    @Override
    public OPCSocket setChannel(byte channel) {
        this.packetData[0] = channel;
        return this;
    }

    @Override
    protected byte[] getDataBuffer() {
        return this.packetData;
    }

    @Override
    protected int getDataBufferOffset() {
        return 4;
    }
}

