/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXDatagram;

public class StreamingACNDatagram
extends LXDatagram {
    public static final int OFFSET_PRIORITY = 108;
    public static final int OFFSET_SEQUENCE_NUMBER = 111;
    public static final int OFFSET_UNIVERSE_NUMBER = 113;
    public static final int OFFSET_DMX_DATA = 126;
    public static final int MAX_DATA_LENGTH = 512;
    public static final int DEFAULT_PORT = 5568;
    private static final int DEFAULT_UNIVERSE_NUMBER = 1;
    public static final int DEFAULT_PRIORITY = 100;
    public static final int MAX_PRIORITY = 200;
    private int universeNumber;
    private int priority = 100;

    public StreamingACNDatagram(LX lx, LXModel model) {
        this(lx, model, 1);
    }

    public StreamingACNDatagram(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, 1);
    }

    public StreamingACNDatagram(LX lx, LXModel model, int universeNumber) {
        this(lx, model.toIndexBuffer(), universeNumber);
    }

    public StreamingACNDatagram(LX lx, int[] indexBuffer, int universeNumber) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, universeNumber);
    }

    public StreamingACNDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int universeNumber) {
        this(lx, indexBuffer, byteOrder, indexBuffer.length * byteOrder.getNumBytes(), universeNumber);
    }

    protected StreamingACNDatagram(LX lx, int dataSize, int universeNumber) {
        this(lx, new int[0], LXBufferOutput.ByteOrder.RGB, dataSize, universeNumber);
    }

    public StreamingACNDatagram(LX lx, int[] indexBuffer, int dataSize, int universeNumber) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, dataSize, universeNumber);
    }

    public StreamingACNDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int dataSize, int universeNumber) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder), dataSize, universeNumber);
    }

    public StreamingACNDatagram(LX lx, IndexBuffer indexBuffer, int universeNumber) {
        this(lx, indexBuffer, indexBuffer.numChannels, universeNumber);
    }

    public StreamingACNDatagram(LX lx, IndexBuffer indexBuffer, int dataSize, int universeNumber) {
        super(lx, indexBuffer, 126 + dataSize);
        this.setPort(5568);
        this.setUniverseNumber(universeNumber);
        this.setPriority(this.priority);
        this.validateBufferSize();
        this.buffer[0] = 0;
        this.buffer[1] = 16;
        this.buffer[2] = 0;
        this.buffer[3] = 0;
        this.buffer[4] = 65;
        this.buffer[5] = 83;
        this.buffer[6] = 67;
        this.buffer[7] = 45;
        this.buffer[8] = 69;
        this.buffer[9] = 49;
        this.buffer[10] = 46;
        this.buffer[11] = 49;
        this.buffer[12] = 55;
        this.buffer[13] = 0;
        this.buffer[14] = 0;
        this.buffer[15] = 0;
        int flagLength = 0x7000 | this.buffer.length - 16 & 0xFFFFFFF;
        this.buffer[16] = (byte)(flagLength >> 8 & 0xFF);
        this.buffer[17] = (byte)(flagLength & 0xFF);
        this.buffer[18] = 0;
        this.buffer[19] = 0;
        this.buffer[20] = 0;
        this.buffer[21] = 4;
        for (int i = 22; i < 38; ++i) {
            this.buffer[i] = (byte)i;
        }
        flagLength = 0x7000 | this.buffer.length - 38 & 0xFFF;
        this.buffer[38] = (byte)(flagLength >> 8 & 0xFF);
        this.buffer[39] = (byte)(flagLength & 0xFF);
        this.buffer[40] = 0;
        this.buffer[41] = 0;
        this.buffer[42] = 0;
        this.buffer[43] = 2;
        this.buffer[44] = 76;
        this.buffer[45] = 88;
        this.buffer[46] = 45;
        byte[] versionBytes = "1.0.0".getBytes();
        System.arraycopy(versionBytes, 0, this.buffer, 47, versionBytes.length);
        for (int i = 47 + versionBytes.length; i < 108; ++i) {
            this.buffer[i] = 0;
        }
        this.buffer[109] = 0;
        this.buffer[110] = 0;
        this.buffer[111] = 0;
        this.buffer[112] = 0;
        flagLength = 0x7000 | this.buffer.length - 115 & 0xFFF;
        this.buffer[115] = (byte)(flagLength >> 8 & 0xFF);
        this.buffer[116] = (byte)(flagLength & 0xFF);
        this.buffer[117] = 2;
        this.buffer[118] = -95;
        this.buffer[119] = 0;
        this.buffer[120] = 0;
        this.buffer[121] = 0;
        this.buffer[122] = 1;
        int numProperties = 1 + dataSize;
        this.buffer[123] = (byte)(numProperties >> 8 & 0xFF);
        this.buffer[124] = (byte)(numProperties & 0xFF);
        this.buffer[125] = 0;
    }

    public StreamingACNDatagram setPriority(int priority) {
        if (priority < 0 || priority > 200) {
            throw new IllegalArgumentException("sACN priority must be 0-200");
        }
        this.priority = priority;
        this.buffer[108] = (byte)(0xFF & this.priority);
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public StreamingACNDatagram setUniverseNumber(int universeNumber) {
        this.universeNumber = universeNumber &= 0xFFFF;
        this.buffer[113] = (byte)(universeNumber >> 8 & 0xFF);
        this.buffer[114] = (byte)(universeNumber & 0xFF);
        return this;
    }

    public int getUniverseNumber() {
        return this.universeNumber;
    }

    public void setDmxData(byte data, int channel) {
        if (channel < 0 || channel >= this.buffer.length - 126) {
            throw new IndexOutOfBoundsException("Channel is greater than DMX data length");
        }
        this.buffer[126 + channel] = data;
    }

    public void setDmxData(byte[] data, int channel) {
        if (channel < 0 || channel > this.buffer.length - 126 - data.length) {
            throw new IndexOutOfBoundsException("Channel is greater than DMX data length");
        }
        System.arraycopy(data, 0, this.buffer, 126, data.length);
    }

    @Override
    protected int getDataBufferOffset() {
        return 126;
    }

    @Override
    protected void updateSequenceNumber() {
        this.buffer[111] = (byte)(this.buffer[111] + 1);
    }
}

