/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AggregateParameter
extends LXListenableParameter {
    private final Map<String, LXListenableParameter> _subparameters = new LinkedHashMap<String, LXListenableParameter>();
    public final Map<String, LXListenableParameter> subparameters = Collections.unmodifiableMap(this._subparameters);
    private boolean inSubparameterUpdate = false;
    private boolean inValueUpdate = false;
    private final LXParameterListener subparameterListener = p -> {
        if (!this.inValueUpdate) {
            boolean push = this.inSubparameterUpdate;
            this.inSubparameterUpdate = true;
            this.onSubparameterUpdate(p);
            this.inSubparameterUpdate = push;
        }
    };

    protected AggregateParameter(String label) {
        this(label, 0.0);
    }

    protected AggregateParameter(String label, double value) {
        super(label, value);
    }

    protected void addSubparameter(String path, LXListenableParameter parameter) {
        if (this._subparameters.containsKey(path)) {
            throw new IllegalStateException("Cannot add sub-parameter at path " + path + ", sub-parameter already exists");
        }
        this._subparameters.put(path, parameter);
        parameter.setParentParameter(this);
        parameter.addListener(this.subparameterListener);
    }

    @Override
    protected final double updateValue(double value) {
        this.inValueUpdate = true;
        value = this.onUpdateValue(value);
        if (!this.inSubparameterUpdate) {
            this.updateSubparameters(value);
        }
        this.inValueUpdate = false;
        return value;
    }

    protected double onUpdateValue(double value) {
        return value;
    }

    protected abstract void updateSubparameters(double var1);

    protected abstract void onSubparameterUpdate(LXParameter var1);

    public LXListenableNormalizedParameter getRemoteControl() {
        for (LXListenableParameter subparam : this.subparameters.values()) {
            if (!(subparam instanceof LXListenableNormalizedParameter)) continue;
            return (LXListenableNormalizedParameter)subparam;
        }
        return null;
    }

    @Override
    public void dispose() {
        for (LXListenableParameter parameter : this._subparameters.values()) {
            parameter.removeListener(this.subparameterListener);
        }
        super.dispose();
    }
}

