/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

public abstract class BoundedFunctionalParameter
extends FunctionalParameter
implements LXNormalizedParameter {
    public final BoundedParameter.Range range;
    private double exponent = 1.0;
    private BoundedParameter.NormalizationCurve curve = BoundedParameter.NormalizationCurve.NORMAL;

    public BoundedFunctionalParameter(String label) {
        this(label, 0.0, 1.0);
    }

    protected BoundedFunctionalParameter(String label, double max) {
        this(label, 0.0, max);
    }

    protected BoundedFunctionalParameter(String label, double v0, double v1) {
        super(label);
        this.range = new BoundedParameter.Range(v0, v1);
    }

    @Override
    public BoundedFunctionalParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public LXParameter setValue(double value) {
        throw new UnsupportedOperationException("BoundedFunctionalParameter does not support setValue()");
    }

    protected abstract double computeValue();

    @Override
    public final double getValue() {
        return this.range.constrain(this.computeValue());
    }

    @Override
    public final float getValuef() {
        return (float)this.getValue();
    }

    @Override
    public BoundedFunctionalParameter setNormalized(double normalized) {
        throw new UnsupportedOperationException("BoundedFunctionalParameter does not support setValue()");
    }

    @Override
    public double getNormalized() {
        return this.range.getNormalized(this.getValue(), this.exponent, BoundedParameter.NormalizationCurve.NORMAL);
    }

    public LXNormalizedParameter setExponent(double exponent) {
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("May not set zero or negative exponent");
        }
        this.exponent = exponent;
        return this;
    }

    @Override
    public double getExponent() {
        return this.exponent;
    }

    public LXNormalizedParameter setNormalizationCurve(BoundedParameter.NormalizationCurve curve) {
        this.curve = curve;
        return this;
    }

    public BoundedParameter.NormalizationCurve getNormalizationCurve() {
        return this.curve;
    }
}

