/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

public class BoundedParameter
extends LXListenableNormalizedParameter {
    private NormalizationCurve curve = NormalizationCurve.NORMAL;
    public final Range range;
    private final LXListenableParameter underlying;
    private static final int NO_DETENT = -1;
    private static final int TICKS_PER_DETENT = 12;
    private boolean detentsEnabled = false;
    private double[] detents = null;
    private boolean detentsNormalized = false;
    private int detentIndex = -1;
    private int detentTicks = 0;

    public BoundedParameter(String label) {
        this(label, 0.0);
    }

    public BoundedParameter(String label, double value) {
        this(label, value, 1.0);
    }

    public BoundedParameter(String label, double value, double max) {
        this(label, value, 0.0, max);
    }

    public BoundedParameter(String label, double value, double v0, double v1) {
        this(label, value, v0, v1, null);
    }

    public BoundedParameter(LXListenableParameter underlying, double v0, double v1) {
        this(underlying.getLabel(), underlying.getValue(), v0, v1, underlying);
    }

    protected BoundedParameter(String label, double value, double v0, double v1, LXListenableParameter underlying) {
        super(label, value < Math.min(v0, v1) ? Math.min(v0, v1) : (value > Math.max(v0, v1) ? Math.max(v0, v1) : value));
        this.range = new Range(v0, v1);
        this.underlying = underlying;
        if (this.underlying != null) {
            this.underlying.addListener(p -> {
                double v = p.getValue();
                if (v >= this.range.min && v <= this.range.max) {
                    this.setValue(v);
                }
            });
        }
    }

    @Override
    public BoundedParameter setWrappable(boolean wrappable) {
        super.setWrappable(wrappable);
        return this;
    }

    @Override
    public BoundedParameter setMappable(boolean mappable) {
        super.setMappable(mappable);
        return this;
    }

    @Override
    public BoundedParameter setUnits(LXParameter.Units units) {
        super.setUnits(units);
        return this;
    }

    @Override
    public BoundedParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public BoundedParameter setPolarity(LXParameter.Polarity polarity) {
        super.setPolarity(polarity);
        return this;
    }

    @Override
    public BoundedParameter setExponent(double exponent) {
        super.setExponent(exponent);
        return this;
    }

    public BoundedParameter setNormalizationCurve(NormalizationCurve curve) {
        this.curve = curve;
        return this;
    }

    public NormalizationCurve getNormalizationCurve() {
        return this.curve;
    }

    public boolean isDetentEnabled() {
        return this.detentsEnabled && this.detents != null;
    }

    public BoundedParameter setDetentsEnabled(boolean detentEnabled) {
        this.detentsEnabled = detentEnabled;
        return this;
    }

    public BoundedParameter setDetents(double ... detents) {
        return this.setDetents(detents, false);
    }

    public BoundedParameter setDetentsNormalized(double ... detents) {
        return this.setDetents(detents, true);
    }

    protected BoundedParameter setDetents(double[] detents, boolean normalized) {
        BoundedParameter.validateDetents(detents, normalized ? 0.0 : this.range.min, normalized ? 1.0 : this.range.max);
        this.detents = detents;
        this.detentsNormalized = normalized;
        this.detentIndex = -1;
        this.detentTicks = 0;
        this.detentsEnabled = true;
        return this;
    }

    private static final void validateDetents(double[] detents, double min, double max) {
        if (detents.length == 0) {
            throw new IllegalArgumentException("Detents array cannot be empty");
        }
        double prev = Double.NEGATIVE_INFINITY;
        for (double d : detents) {
            if (d < min || d > max) {
                throw new IllegalArgumentException("Invalid detent value: " + d);
            }
            if (d <= prev) {
                throw new IllegalArgumentException("Detents must be in order: " + d + " is not > " + prev);
            }
            prev = d;
        }
    }

    @Override
    public BoundedParameter reset() {
        this.detentIndex = -1;
        this.detentTicks = 0;
        super.reset();
        return this;
    }

    @Override
    public BoundedParameter incrementValue(double amount) {
        return this.incrementValue(amount, this.isWrappable());
    }

    public BoundedParameter incrementValue(double amount, boolean wrap) {
        double newValue = this.getValue() + amount;
        if (wrap) {
            if (newValue > this.range.max) {
                newValue = this.range.min + (newValue - this.range.max) % this.range.range;
            } else if (newValue < this.range.min) {
                newValue = this.range.max + (newValue - this.range.min) % this.range.range;
            }
        }
        this.detentIndex = -1;
        this.detentTicks = 0;
        return (BoundedParameter)this.setValue(newValue);
    }

    @Override
    public BoundedParameter setNormalized(double normalized) {
        return this.setNormalized(normalized, false);
    }

    private BoundedParameter setNormalized(double normalized, boolean fromDetent) {
        if (!fromDetent) {
            this.detentIndex = -1;
            this.detentTicks = 0;
        }
        this.setValue(this.range.normalizedToValue(normalized, this.getExponent(), this.getNormalizationCurve()));
        return this;
    }

    public LXListenableNormalizedParameter incrementDetentTicks(boolean increase) {
        return this.incrementDetentTicks(increase, this.isWrappable());
    }

    public LXListenableNormalizedParameter incrementDetentTicks(boolean increase, boolean wrap) {
        return this.incrementNormalized(increase ? 1.0 : -1.0, wrap, true);
    }

    @Override
    public LXListenableNormalizedParameter incrementNormalized(double amount, boolean wrap) {
        return this.incrementNormalized(amount, wrap, this.isDetentEnabled());
    }

    private LXListenableNormalizedParameter incrementNormalized(double amount, boolean wrap, boolean detent) {
        if (detent && this.detents != null) {
            boolean positive = amount > 0.0;
            int increment = positive ? 1 : -1;
            if (this.detentTicks > 0 != positive) {
                this.detentTicks = 0;
            }
            this.detentTicks += increment;
            if (Math.abs(this.detentTicks) >= 12) {
                this.incrementDetent(increment, wrap);
            }
            return this;
        }
        this.detentTicks = 0;
        this.detentIndex = -1;
        return super.incrementNormalized(amount, wrap);
    }

    public BoundedParameter nextDetent() {
        return this.nextDetent(this.isWrappable());
    }

    public BoundedParameter nextDetent(boolean wrap) {
        return this.incrementDetent(1, wrap);
    }

    public BoundedParameter prevDetent() {
        return this.prevDetent(this.isWrappable());
    }

    public BoundedParameter prevDetent(boolean wrap) {
        return this.incrementDetent(-1, wrap);
    }

    private BoundedParameter incrementDetent(int inc, boolean wrap) {
        this.detentTicks = 0;
        if (this.detents == null) {
            return this;
        }
        int newDetentIndex = -1;
        if (this.detentIndex != -1) {
            newDetentIndex = this.detentIndex + inc;
        } else {
            double current = this.detentsNormalized ? this.getNormalized() : this.getValue();
            for (newDetentIndex = 0; newDetentIndex < this.detents.length && current >= this.detents[newDetentIndex]; ++newDetentIndex) {
            }
            if (inc < 0 && --newDetentIndex >= 0 && current <= this.detents[newDetentIndex]) {
                --newDetentIndex;
            }
        }
        if (!(wrap || newDetentIndex >= 0 && newDetentIndex < this.detents.length)) {
            return this;
        }
        this.detentIndex = (newDetentIndex + this.detents.length) % this.detents.length;
        if (this.detentsNormalized) {
            this.setNormalized(this.detents[this.detentIndex], true);
        } else {
            this.setValue(this.detents[this.detentIndex]);
        }
        return this;
    }

    public double getRange() {
        return this.range.range;
    }

    @Override
    public double getNormalized() {
        return this.range.getNormalized(this.getValue(), this.getExponent(), this.getNormalizationCurve());
    }

    @Override
    public double getValueFromNormalized(double normalized) {
        return this.range.normalizedToValue(normalized);
    }

    @Override
    public float getNormalizedf() {
        return (float)this.getNormalized();
    }

    @Override
    protected double updateValue(double value) {
        value = this.range.constrain(value);
        if (this.underlying != null) {
            this.underlying.setValue(value);
        }
        return value;
    }

    public static enum NormalizationCurve {
        NORMAL,
        REVERSE,
        BIAS_CENTER,
        BIAS_OUTER;

    }

    public static class Range {
        public final double v0;
        public final double v1;
        public final double min;
        public final double max;
        public final double vRange;
        public final double range;

        public Range(double v0, double v1) {
            this.v0 = v0;
            this.v1 = v1;
            if (v0 < v1) {
                this.min = v0;
                this.max = v1;
            } else {
                this.min = v1;
                this.max = v0;
            }
            this.vRange = this.v1 - this.v0;
            this.range = this.max - this.min;
        }

        public double constrain(double value) {
            return LXUtils.constrain(value, this.min, this.max);
        }

        public double getNormalized(double value) {
            return this.getNormalized(value, 1.0);
        }

        public double getNormalized(double value, double exponent) {
            return this.getNormalized(value, exponent, NormalizationCurve.NORMAL);
        }

        public double getNormalized(double value, double exponent, NormalizationCurve curve) {
            if (this.v0 == this.v1) {
                return 0.0;
            }
            value = this.constrain(value);
            double normalized = (value - this.v0) / this.vRange;
            if (exponent != 1.0) {
                double expInv = 1.0 / exponent;
                switch (curve) {
                    case NORMAL: {
                        normalized = Math.pow(normalized, expInv);
                        break;
                    }
                    case REVERSE: {
                        normalized = 1.0 - Math.pow(1.0 - normalized, expInv);
                        break;
                    }
                    case BIAS_CENTER: {
                        if (normalized < 0.5) {
                            normalized = 0.5 - 0.5 * Math.pow(2.0 * (0.5 - normalized), expInv);
                            break;
                        }
                        normalized = 0.5 + 0.5 * Math.pow(2.0 * (normalized - 0.5), expInv);
                        break;
                    }
                    case BIAS_OUTER: {
                        normalized = normalized < 0.5 ? 0.5 * Math.pow(2.0 * normalized, expInv) : 1.0 - 0.5 * Math.pow(2.0 * (1.0 - normalized), expInv);
                    }
                }
            }
            return normalized;
        }

        public double normalizedToValue(double normalized) {
            return this.normalizedToValue(normalized, 1.0);
        }

        public double normalizedToValue(double normalized, double exponent) {
            return this.normalizedToValue(normalized, exponent, NormalizationCurve.NORMAL);
        }

        public double normalizedToValue(double normalized, double exponent, NormalizationCurve curve) {
            if (normalized < 0.0) {
                normalized = 0.0;
            } else if (normalized > 1.0) {
                normalized = 1.0;
            }
            if (exponent != 1.0) {
                switch (curve) {
                    case NORMAL: {
                        normalized = Math.pow(normalized, exponent);
                        break;
                    }
                    case REVERSE: {
                        normalized = 1.0 - Math.pow(1.0 - normalized, exponent);
                        break;
                    }
                    case BIAS_CENTER: {
                        if (normalized < 0.5) {
                            normalized = 0.5 - 0.5 * Math.pow(2.0 * (0.5 - normalized), exponent);
                            break;
                        }
                        normalized = 0.5 + 0.5 * Math.pow(2.0 * (normalized - 0.5), exponent);
                        break;
                    }
                    case BIAS_OUTER: {
                        normalized = normalized < 0.5 ? 0.5 * Math.pow(2.0 * normalized, exponent) : 1.0 - 0.5 * Math.pow(2.0 * (1.0 - normalized), exponent);
                    }
                }
            }
            return this.v0 + this.vRange * normalized;
        }
    }
}

